<?php

/**

 * Base class for displaying a list of items in "Newswire List" page.

 *

 * @package WP Newswire

 * @subpackage List_Table

 */

class WP_Newswire_List_Page_List_Table extends WP_Newswire_List_Table {

    public $wp_newswire_type;

            

    function __construct( $type ) {

        parent::__construct( array(

            'plural' => 'newswire_list',

            'screen' => null

        ) );

        $this->wp_newswire_type = $type;

    }

    function prepare_items() {

        $this->_column_headers = array(

            array(

                'cb' => '<input type="checkbox" />',

                'wpnwr_keywords' => __( 'Keywords', 'wp_newswire' ),

                'wpnwr_autopost' => __( 'Autopost', 'wp_newswire' )

//                'wpnwr_posts' => __( 'Posts', 'wp_newswire' )

            ),

            array(),

            array(

                'wpnwr_keywords'    => 'keywords'

//                'wpnwr_posts'   => 'posts',

            )

        );

        

        if( $this->wp_newswire_type == 'rss' ){

            $this->_column_headers[0]['wpnwr_rss_address'] = __( 'RSS Feed Address', 'wp_newswire' );

        }

        

        if( isset( $_GET['order'] ) ){

            $order = ( $_GET['order'] == 'asc' ) ? 'asc' : 'desc';

            $orderbys = array( 

                'k' => 'keywords',

                'p' => 'posts'

            );

            if( isset($_GET['orderby']) && isset( $orderbys[$_GET['orderby']] ) ){

                $orderby = $orderbys[$_GET['orderby']];

            }

        }

        $items = WP_Newswire_Feed_Manager::get_all_items( $this->wp_newswire_type, $orderby, $order );

        $this->items = array();

        foreach( $items as $item ){

            $this->items[] = array(

                'id' => $item->id,

                'cb' => false,

                'wpnwr_keywords' => $item->keywords,

                'wpnwr_autopost' => ! $item->options['manually'],

//                'wpnwr_posts' => $item->posts,

                'wpnwr_rss_address' => $item->options['address'],

            );

        }

    }

    

    function display_tablenav( $which = 'top' ) {

        return;

    }

    

    function column_cb( $item ){

        return '<input type="checkbox" name="delete_feed_item[]" value="' . esc_attr( $item['id'] ) . '" />';

    }

    

    function column_default( $item, $column_name ) {

        return esc_html( $item[$column_name] );

    }

    

    function column_wpnwr_keywords( $item ) {

        if( ! isset( $item['wpnwr_keywords'] ) || trim( $item['wpnwr_keywords'] === '' ) ){

            return '<i>' . __( 'No keywords.', 'wp_newswire' ) . '</i>';

        }

        return $item['wpnwr_keywords'];

    }

    

    function column_wpnwr_autopost( $item ) {

        return ( $item['wpnwr_autopost'] ) ? __( 'Yes', 'wp_newswire' ) : __( 'No', 'wp_newswire' );

    }

    

    function column_wpnwr_rss_address( $item ) {

        if( ! isset( $item['wpnwr_rss_address'] ) || $item['wpnwr_rss_address'] === '' ){

            return '';

        }

        

        $link_html = '<a href="' . esc_attr( $item['wpnwr_rss_address'] ) . '" target="_blank">' .

                    esc_html( $item['wpnwr_rss_address'] ) . '</a>';

        return $link_html;

    }

    

}