<?php



/**

 * @package WP_Newswire

 * @subpackage Importer

 */

class WP_Newswire_Import_Manager{

    public $number;

    public $items = array();

    public $keywords = '';

    public $has_errors = false;

    public $last_inserted_item = false;

    public $filter_time = false;

    protected $skip_keyword_search = false;

            

    function __construct( $number = 0, $keywords = '' ) {

        $this->number = (int) $number;

        $this->keywords = $keywords;

    }

    

    /**

     * Retrieves all of the fetched items from the source.

     */

    public function get_items() {

        die( __( 'This function needs to be overwritten by the extended class.', 'wp_newswire' ) );

    }

    

    /**

     * Returns DateTime object for the current item date.

     */

    public function get_item_datetime( $item ) {

        die( __( 'This function needs to be overwritten by the extended class.', 'wp_newswire' ) );

    }

    

    /**

     * Returns content that would be searched for the specified keywords in the item.

     */

    public function get_item_keywords_search_area_content( $item ) {

        die( __( 'This function needs to be overwritten by the extended class.', 'wp_newswire' ) );

    }



    /**

     * Prepare items.

     * 

     * Needs to be overwritten by the extended class.

     */

    public function prepare_items() {

		$counter = 0;

        $entries = array();

        $items = $this->get_items();

        if( $this->filter_time === 0 ){

            $this->items = array_reverse( $items );

            $this->items = array_slice( $this->items, 0, $this->number );
            return;

        } // all items are new, slice from oldest
		
        foreach( $items as $item ){
            if( $this->filter_time !== false ){

                $time = $this->get_item_datetime( $item );

                $u_time = ( 0 === $time ) ? 0 : ( (int) $time->format( 'U' ) );

                if( $this->filter_time >= $u_time ){
					break;
                } // skip through old items

            }// get only new items

            else if($this->number <= $counter ){

                break;

            } // reached number of imports 

            if( $this->keywords !== '' && ( ! $this->skip_keyword_search ) ){

                $keyword_search_content = $this->get_item_keywords_search_area_content( $item );

                if( ! wp_newswire_has_keywords( $this->keywords, $keyword_search_content ) ){

                    continue;

                } // keywords not found

            } // check for keywords

            $this->items[] = $item;   

            $counter ++;

        }

        if( ! empty( $this->items) ){

            $this->items = array_reverse( $this->items );  // push newest posts to the top

            if( $this->filter_time !== false ){

                $this->items = array_slice( $this->items, 0, $this->number );

            } // cut to number

        }

    }

    

    /**

     * Prepare single item. Array with at least following required items:

     *      title - Item title.

     *      content - Item content.

     *      original_content - Item content in it's initial fetched form.

     *      date - PHP DateTime object of item's date.

     *      image - Optional. URL to the item image. If specified will download it,

     * if skipped will try to find the image in the original_content

     * 

     * Needs to be overwritten by the extended class.

     */

    public function prepare_item( $item, $args ) {

        die( __( 'This function needs to be overwritten by the extended class.', 'wp_newswire' ) );

    }

    

    /**

     * Indicates if there are any items to import.

     * 

     * @return boolean False when no items are found.

     */

    public function has_items() {

        return ! empty( $this->items );

    }

    

    /**

     * Inserts items as posts.

     * 

     * @param array $args Arguments such as content length, html after&before etc

     * @return int Number of successfully inserted items.

     */

    public function insert_all( $args ) {

        $inserts = 0;

        

        foreach( $this->items as $item ){

            $item_data = $this->prepare_item( $item, $args );

            $inserted = $this->insert_item( $item_data, $args );

            

            if( $inserted ){

                $inserts ++;

            }

        }



       return $inserts;    

    }

    

    /**

     * Insert single item.

     * 

     * @staticvar int $order Used to increase the menu_order of the post for each

     * next one.

     * @param array $item Priorly prepared item.

     * @param array $args Array with extra arguments.

     * @return boolean | int ID of inerted post on success, false on failure.

     */

    public function insert_item( $item, $args ) {

        sleep(.1); // WP loop order by default is by date, wait a bit for time difference to register

        static $order = 0;

        $order ++;

        

        if( isset( $args['_status'] ) ){

            $status = $args['_status'];

        } // custom status

        else{

            $status = $args['manually'] ? 'pending' : 'publish';

        } // status

        

        if( isset( $args['_type'] ) ){

            $type = $args['_type'];

        } // custom post type

        else{

            $type = $args['manually'] ? 'wp_nswr_queue_item' : $args['post_type'];

        } // post type

        

        // Putting post data together

        $postarr = array(

            'post_status' => $status,

            'post_type' => $type,

            'post_content' => $item['content'],

            'post_title' => wp_strip_all_tags($item['title']),

            'menu_order' => $order,

            'post_category' => array( (int) $args['post_category'] )

        );



        $post_inserted = wp_insert_post( $postarr );



        if( is_a( $post_inserted, 'WP_Error' ) ){

            return false;

        } // Post was not inserted

        

        // preserve post_type, post_category values in metadata

        add_post_meta( $post_inserted , 'wpnwr_queue_meta', array(

            'post_type' => $args['post_type'],

            'post_category' => $args['post_category']

        ));

        

        if( ! (boolean) $args['_hidden_insertion'] ){

            $this->last_inserted_item = $item;

        } // skip recording last item

        

        if( $args['include_images'] === true ){

            $img = ( isset( $item['image'] ) ) 

                    ? $item['image']

                    : wp_newswire_find_first_image( $item['original_content'] ); 

            if ( $img ){

                $img = str_replace( ' ', '%20', $img );

                add_action( 'add_attachment', array( 'WP_Newswire_Import_Manager', '_hook_set_as_featured_image' ) );

                add_filter( 'sanitize_file_name_chars',  array( 'WP_Newswire_Import_Manager', '_hook_sanitize_file_name_chars' ), 10, 2 );

                WP_Newswire::image_sideload_library();

                $image_downloaded = media_sideload_image( $img, $post_inserted, $item['title'] );

                if( is_a( $image_downloaded, 'WP_Error' ) ){

                    wp_newswire_add_message( 

                            sprintf( __( 'Image was not uploaded. Error: %s', 'wp_newswire' ), $image_downloaded->get_error_message() ),

                            'error' );

                }

                remove_action( 'add_attachment', array( 'WP_Newswire_Import_Manager', '_hook_set_as_featured_image' ) );

                remove_filter( 'sanitize_file_name_chars',  array( 'WP_Newswire_Import_Manager', '_hook_sanitize_file_name_chars' ) );

            } // image found or specified

        } // Set featured image



        return $post_inserted;

    }

    

    /**

    * Sets attached image file as attachment. Use this function in 'add_attachment' 

    * hook.

    * 

    * @param int $image_ID Attached image ID.

    * @note Can be removed and replaced with inline function in PHP 5+

    */

    public function _hook_set_as_featured_image( $image_ID ) {

        $image = get_post( $image_ID );

        update_post_meta( $image->post_parent, '_thumbnail_id' ,$image_ID );

    }

    

    public function _hook_sanitize_file_name_chars( $special_chars, $filename_raw ) {

        if( ! in_array( '%20', $special_chars ) ){

            $special_chars[] = '%20';

        }

        if( ! in_array( '+', $special_chars ) ){

            $special_chars[] = '+';

        }

        

        return $special_chars;

    }

}