<?php



class WP_Newswire_Feed_Iterator{

    public $current_feed;

    protected $iterator_point = 0;

    public $full_cycled = false;

            

    function __construct() {

        $this->iterator_point = abs( (int) get_option( 'wpnwr_feed_iterator_point' ) );

    }

    

    public function current() {

        if( $this->current_feed && $this->current_feed->id ){

            return $this->current_feed;

        } // current feed is set

        if( $this->iterator_point ){

            $this->current_feed = new WP_Newswire_Feed_Item( $this->iterator_point );

        } // current feed is not set, try to retrieve

        if( ! $this->current_feed || ! $this->current_feed->id ){

            return $this->next();

        } // current feed or no feed is available, get the next available

        else{

            return $this->current_feed;

        } // feed successfully retrieved

    }

    

    public function next() {

        global $wpdb;

        $next_item_data = $wpdb->get_row(

                $wpdb->prepare(

                    'SELECT * FROM ' . WP_NEWSWIRE_TABLE_NAME . ' WHERE `id` > %d ORDER BY `id` LIMIT 1', 

                        $this->iterator_point ),

                ARRAY_A );

        

        if( ! $next_item_data ){

            if( $this->iterator_point === 0 ){

                return;

            } // the table is empty of entries

            else{

                $this->iterator_point = 0;

                $this->full_cycled = true;

                return $this->next();

            } // it is the end of the table, cycle back to the first entry.

        } // the next feed item is unavailable



        $this->current_feed = new WP_Newswire_Feed_Item();

        $this->current_feed->set_data( $next_item_data, 'mysql' ); // Set new current feed

        

        update_option( 'wpnwr_feed_iterator_point', $next_item_data['id'] ); // save iterator point

        $this->iterator_point = $next_item_data['id']; // remember last iterator point

        return $this->current_feed;

    }

}