<?php



/**

 * @package WP_Newswire

 * @subpackage Feed

 */



class WP_Newswire_Feed_Item{

    public $id = 0;

    public $hash = '';

    public $type;

    public $keywords;

    public $posts = 0;

    public $options = array(

        // 'manually' => false,

        // 'include_images' => false,

        // 'length' => 0,

        // 'html_before' => '',

        // 'html_after' => ''

    );

    public $time;





    /**

     * 

     * @param int $id Item ID. Optional. 

     */

    function __construct( $id = 0 ) {

        if( $id ){

            global $wpdb;

            $data = $wpdb->get_row(

                    $wpdb->prepare( 'SELECT * FROM ' . WP_NEWSWIRE_TABLE_NAME . ' WHERE `id` = %d', $id ), ARRAY_A );

            if( ! $data ){

                return;

            } // no feed items available

            $this->set_data( $data, 'mysql' );

        }

    }

    

    /**

     * Sets data for current object.

     * 

     * @param array $data Associative array with object data.

     */

    public function set_data( $data, $data_type = 'array' ) {

        if( $data_type === 'mysql' ){

            $this->options = maybe_unserialize( $data['options'] );

            $this->hash = $data['hash'];

        } // sanitize data from database

        else{

            $this->options = ( isset( $data['options'] ) )

                ? $data['options'] 

                : array(

                    'manually' => $data['manually'],

                    'include_images' => $data['include_images'],

                    'length' => $data['length'],

                    'html_before' => $data['html_before'],

                    'html_after' => $data['html_after'],

                    'post_type' => $data['post_type'],

                    'post_category' => $data['post_category']

                );

            $this->hash = hash( 'md5', $data['hash'] );

        }

        

        if( isset( $data['id'] ) ){

            $this->id = (int) $data['id'];

        }

        $this->type = $data['type'];

        $this->keywords = $data['keywords'];

        $this->posts = $data['posts'];

        

        if( isset( $data['_options'] ) ){

            $this->options  = array_merge( $this->options, (array) $data['_options'] );

        } // extra options

        

        $this->time = ( isset( $data['time'] ) ) ? $data['time'] : null;

        

    }

    

    /**

     * Inserts current item into database.

     * 

     * @global object $wpdb WordPress Database Object

     * @return boolean | int Inserted item ID on success, false on failure.

     */

    public function insert() {

        global $wpdb;

        

        if( $this->options['post_type'] === 'page' ){

            unset( $this->options['post_category'] );

        } // ignore categories for pages

        

        $inserted = $wpdb->insert( WP_NEWSWIRE_TABLE_NAME, array(

            'hash' => $this->hash,

            'type' => $this->type,

            'keywords' => $this->keywords,

            'posts' => $this->posts,

            'options' => maybe_serialize( $this->options ),

            'time' => $this->time ? $this->time->format('Y-m-d H:i:s') : null

        ), array( '%s', '%s', '%s', '%d', '%s', '%s' ) );

        

        if( $inserted === false ){

            return false;

        }

        

        return $wpdb->insert_id;

    }

    

    /**

     * Deletes feed item with the specified ID from the database.

     * 

     * @global object $wpdb WP Database object.

     * @param int $item_id Item ID.

     * @return boolean | int Number of rows affected, false on failure.

     */

    public function delete_item( $item_id ) {

        global $wpdb;

        

        return $wpdb->delete( WP_NEWSWIRE_TABLE_NAME, array( 'id' => $item_id ), array( '%d' ) );

    }

    

    /**

     * Updates time of the feed's last fetch.

     * 

     * @global object $wpdb WordPress Database object.

     * @param object $date DateTime object. New date.

     * @return False if errors, or the number of rows affected if successful.

     */

    public function update_date( $date ) {

        global $wpdb;

        

        $updated = $wpdb->update( WP_NEWSWIRE_TABLE_NAME , array(

            'time' => $date->format('Y-m-d H:i:s')

        ), array(

            'id' => $this->id

        ), array( '%s' ), array( '%d' ) );

        

        return $updated;

    }

}