<?php

/**
 * @package WP_Newswire
 */
class WP_Newswire_Admin{
    
    /**
     * Initializes admin. 
     */
    public function init() {        WP_Newswire_Admin::check_action_requests();
        add_action( 'admin_menu', array( 'WP_Newswire_Admin', 'admin_menu' ), 9 );
        add_action( 'admin_enqueue_scripts', array( 'WP_Newswire_Admin', 'admin_scripts' ) );
    }
    
    /**
     * Checks action requests on admin pages and handles them.
     * 
     * @return boolean False when no requests found.
     */
    public function check_action_requests() {
        if( ! isset( $_GET['page'] ) && ! isset( $_GET['action'] )){
            return false;
        } // no actions pending
                
        if( ! current_user_can( 'manage_options' ) ){
            wp_die( __( 'Sorry, you are not allowed to perform requested actions.', 'wp_newswire' ) );
        }
        $page = $_GET['page'];
        $function_name = 'page_' . $page . '_actions_handler';
        if( method_exists( WP_Newswire_Admin, $function_name ) ){
            call_user_func( array( 'WP_Newswire_Admin', $function_name ) );
        }
    }
    
    /**
     * Registers admin menus.
     */
    public function admin_menu() {
        $pages[] = add_menu_page( __( 'WP Newswire', 'wp_newswire' ), __( 'WP Newswire', 'wp_newswire' ), 'manage_options', 'wp_newswire_add_rss', array( 'WP_Newswire_Admin', 'admin_page_add_rss' ), 'dashicons-download', WP_NEWSWIRE_QUEUE_MENU_POS );
        $pages[] = add_submenu_page( 'wp_newswire_add_rss', __( 'Add RSS Feed', 'wp_newswire' ), __( 'Add RSS Feed', 'wp_newswire' ), 'manage_options', 'wp_newswire_add_rss', array( 'WP_Newswire_Admin', 'admin_page_add_rss' ) );
        $pages[] = add_submenu_page( 'wp_newswire_add_rss', __( 'Add Videos', 'wp_newswire' ), __( 'Add Videos', 'wp_newswire' ), 'manage_options', 'wp_newswire_add_videos', array( 'WP_Newswire_Admin', 'admin_page_add_videos' ) );
        $pages[] = add_submenu_page( 'wp_newswire_add_rss', __( 'Add PR Wire', 'wp_newswire' ), __( 'Add PR Wire', 'wp_newswire' ), 'manage_options', 'wp_newswire_add_pr_wire', array( 'WP_Newswire_Admin', 'admin_page_add_pr_wire' ) );
        $pages[] = add_submenu_page( 'wp_newswire_add_rss', __( 'Newswire List', 'wp_newswire' ), __( 'Newswire List', 'wp_newswire' ), 'manage_options', 'wp_newswire_list', array( 'WP_Newswire_Admin', 'admin_page_newswire_list' ) );
        $pages[] = add_submenu_page( 'wp_newswire_add_rss', __( 'Settings', 'wp_newswire' ), __( 'Settings', 'wp_newswire' ), 'manage_options', 'wp_newswire_settings', array( 'WP_Newswire_Admin', 'admin_page_settings' ) );

        foreach( $pages as $page ){
            add_action( 'admin_print_styles-' . $page, array( 'WP_Newswire_Admin', 'admin_page_scripts' ) );
            add_action( 'load-' . $page, array( 'WP_Newswire_Admin', 'help' ) );
        }
    }
    
    public static function help() {
        // We are in the correct screen because we are taking advantage of the load-* action (below)

        $wpcron_admin_url = admin_url( 'options-general.php?page=wp-cron-control' );
	$screen = get_current_screen();
	//$screen->remove_help_tabs();
	$screen->add_help_tab( array(
		'id'       => 'wpnwr-help-cron',
		'title'    => __( 'Cron' ),
		'content'  => '<p>The plugin uses WP cron to schedule importing and posting content from feeds. </p>'
            . '<p>Since WP cron relies on active user visitations to execute, during website '
            . 'downtime the posts may not be imported, for which we recommend following the instructions below:</p>'
            . '<ol>'
                . '<li>Install <a href="https://wordpress.org/plugins/wp-cron-control/" target="_blank">WP-Cron Control</a> '
                    . 'plugin on your website. </li>'
                . '<li>Go to <a href="' . $wpcron_admin_url . '">WP-Cron Control Settings</a> and follow instructions to setup '
                    . 'cron on your server.</li>'
            . '</ol>'
	));
	//add more help tabs as needed with unique id's

	// Help sidebars are optional
	$screen->set_help_sidebar(
		'<p><a href="https://wordpress.org/plugins/wp-cron-control/" target="_blank">WP-Cron Control Plugin</a></p>'
	);
    }

    /**
     * Enqueues scripts for all of admin. 
     */
    public function admin_scripts() {
        wp_enqueue_script( 'wp_newswire_admin_all', WP_NEWSWIRE_ASSETS_ADMIN_URI . 'all.js', array( 'jquery' ) );
        global $wp_newswire_queue_manager;
        wp_localize_script( 'wp_newswire_admin_all', 'WP_Newswire_Data', array(
            'queue_count' => $wp_newswire_queue_manager->queue_count,
            'approve_text' => __( 'Approve', 'wp_newswire' ),
            'ajax_url' => admin_url( 'admin-ajax.php' )
        ) );
    }
    
    /**
     * Enqueues scripts for admin pages. 
     */
    public function admin_page_scripts() {
        wp_enqueue_style( 'wp-newswire-admin-styles', WP_NEWSWIRE_ASSETS_ADMIN_URI.'custom.css' );
        wp_enqueue_script( 'wp-newswire-admin-script', WP_NEWSWIRE_ASSETS_ADMIN_URI.'custom.js' );
    }
     
# Action Handlers 
    
    public function _add_feed_actions_handler( $nonce_field, $nonce_action, $add_feed_function, $success_message ) {
        if( ! isset( $_POST['wpnwr_feed'] ) ){
            return;
        } // no data 
        
        $action = $_GET['action'];
        wp_newswire_check_nonce( $nonce_field, $nonce_action ); // check nonce
        
        $data = $_POST['wpnwr_feed'];
        if( $action === 'add' ){
            $feed_added = call_user_func( $add_feed_function, $data ); // add the new video feed
            if( $feed_added ){
                wp_newswire_add_message( $success_message );
            }
        }
    }
    
    public function page_wp_newswire_add_rss_actions_handler() {
        WP_Newswire_Admin::_add_feed_actions_handler( 
                'wpnwr_add_rss_nonce', 
                'wpnwr_add_rss', 
                array( 'WP_Newswire_Feed_Manager', 'add_rss_feed' ),
                __( 'RSS Feed added.', 'wp_newswire' ) );
    }
    
    public function page_wp_newswire_add_videos_actions_handler() {
        WP_Newswire_Admin::_add_feed_actions_handler( 
                'wpnwr_add_videos_nonce', 
                'wpnwr_add_videos', 
                array( 'WP_Newswire_Feed_Manager', 'add_video_feed' ),
                __( 'Video Feed added.', 'wp_newswire' ) );
    }
    
    public function page_wp_newswire_add_pr_wire_actions_handler() {	WP_Newswire_Admin::_add_feed_actions_handler( 
                'wpnwr_add_prwire_nonce', 
                'wpnwr_add_prwire', 
                array( 'WP_Newswire_Feed_Manager',  'add_prwire_feed' ),
                __( 'PR Wire added.', 'wp_newswire' ) );
    }
    
    public function page_wp_newswire_list_actions_handler() {
        if( ! empty( $_POST['delete_feed_item'] ) ){
            wp_newswire_check_nonce( 'wpnwr_newswire_list_nonce', 'wpnwr_newswire_list' ); // check nonce
            foreach( (array) $_POST['delete_feed_item'] as $item_ID ){
                WP_Newswire_Feed_Item::delete_item( $item_ID );
            }
        }
    }
    
    public function page_wp_newswire_settings_actions_handler() {
        if( ! empty( $_POST['wpnwr_settings'] ) ){
            wp_newswire_check_nonce( 'wpnwr_settings_nonce', 'wpnwr_settings' ); // check nonce
            
            $settings_manager = new WP_Newswire_Settings_Manager( $_POST['wpnwr_settings'] );
            $validated = $settings_manager->validate();
            if( ! $validated ){
                return;
            }
            
            $updated = WP_Newswire_Settings_Manager::update_settings( $_POST['wpnwr_settings'] );
            if( ! $updated ){
                wp_newswire_add_message( __( 'Settings could not be updated.', 'wp_newswire' ), 'error' );
            }
            else{
                // reschedule cron
                global $wp_newswire_settings_manager;
                $wp_newswire_settings_manager->init();                
                WP_Newswire_Queue_Manager::reschedule_cron_event();  
                wp_newswire_add_message( __( 'Settings updated.', 'wp_newswire' ) );
            }
        }
        
    }
    
    
# Admin Pages
    
    /**
     * Inner function to prepare form data on 'Add Feed' type of admin pages.
     * 
     * @return array Feed data.
     */
    public function _admin_page_prepare_data() {
        if( empty ( $_POST['wpnwr_feed'] ) ){
            return array();
        }
        
        $data = $_POST['wpnwr_feed'];
        $data['html_before'] = stripslashes_deep( $data['html_before'] );
        $data['html_after'] = stripslashes_deep( $data['html_after'] );
        
        return $data;
    }
    
    /**
     * Displays admin page: Add RSS Feed
     */
    public function admin_page_add_rss() {
        $data = WP_Newswire_Admin::_admin_page_prepare_data();
        wp_newswire_view( 'add-rss-feed', $data );
    }
    
    /**
     * Displays admin page: Add Videos
     */
    public function admin_page_add_videos() {
        $data = WP_Newswire_Admin::_admin_page_prepare_data();
        wp_newswire_view( 'add-videos', $data );
    }
    
    /**
     * Displays admin page: Add PR Wire
     */
    public function admin_page_add_pr_wire() {
        $data = WP_Newswire_Admin::_admin_page_prepare_data();
        wp_newswire_view( 'prwire', $data );
    }
    
    /**
     * Displays admin page: Newswire List
     */
    public function admin_page_newswire_list() {
        wp_newswire_view( 'newswire-list' );
    }
    
    /**
     * Displays admin page: Newswire List
     */
    public function admin_page_settings() {
        if( isset( $_POST['wpnwr_settings'] ) ){
            $data = $_POST['wpnwr_settings'];
        }
        else{
            global $wp_newswire_settings_manager;
            $data = $wp_newswire_settings_manager->settings;
        }
        wp_newswire_view( 'settings', array( 'settings' => $data ) );
    }
    
}