/* -----------------------------------------------------------------------------

WP Newswire: Custom scripts for all administration.

----------------------------------------------------------------------------- */

jQuery(document).ready(function(){
    
    // ----- START Queue Count Update ----- //
    
    (function($){
        'use strict';
        var $counter = $('.wp_nwr_queue_count');
        
        function set_counter(value){
            if( value < 1 ){
                $counter.text('');
                return;
            }
            $counter.text('( '+value+' )');
        }

        set_counter(WP_Newswire_Data.queue_count);
        
        wp.heartbeat.enqueue(
            'wp-newswire-queue-count', {}, false
        );

        $(document).on( 'heartbeat-tick.wp-newswire-queue-count', function( event, data ) {
            if ( data.hasOwnProperty( 'wp-nwr-queue-count' ) ) {
                set_counter(data['wp-nwr-queue-count']);
            }
        });
    }(jQuery));
    
    // ----- END Queue Count Update ----- //
    
        
    // ----- START Admin Page: Queue Approve ----- //
    
    (function($){    
        'use strict';
        var $form = $('.post-type-wp_nswr_queue_item #posts-filter'),
            $bulk_actions = $form.find('.bulkactions'),
            $action = $bulk_actions.find('select[name="action2"], select[name="action"]'),
            $apply_button = $bulk_actions.find('#doaction2, #doaction');
            
            
        $('<option/>', {
            value: 'wpnwr_approve'
        }).appendTo($action).text(WP_Newswire_Data.approve_text);
            
        $form.on('submit', function(e){
            if($action.val() == 'wpnwr_approve'){
                e.preventDefault();
                var $edit_posts = $form.find('input[name="post[]"]:checked');
                if($edit_posts.length < 1){
                    return;
                } // no posts to approve
                
                $apply_button.val('Approving...').attr('disabled', 'disabled');
                var ids = [];
                $edit_posts.each(function(i, val){
                    ids.push($(this).val());
                });
                
                $.post(WP_Newswire_Data.ajax_url, {
                    action: 'wpnwr_approve_queued_posts',
                    ids: ids
                }, function(response){
                    var current_url = new String(window.location.href);
                    if(response.status){
                        var url = current_url.replace('&wpnwr_status=success&updated=1', '');
                        url = url.replace('&wpnwr_status=error&updated=1', '');
                        url = url + '&wpnwr_status='+response.status+'&updated=1';
                        window.location.replace(url);
                    }
                }, 'json');
            }
        });
        
    }(jQuery));
    
    // ----- END Admin Page: Queue Approve ----- //
});