/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;
import jode.GlobalOptions;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CombineableOperator;
import jode.expr.ConstOperator;
import jode.expr.MatchableOperator;
import jode.expr.Operator;
import jode.expr.UnaryOperator;
import jode.type.Type;

public abstract class Expression {
    public static Expression EMPTYSTRING = new ConstOperator("");
    protected Type type;
    Operator parent = null;

    public void setType(Type type) {
        Type type2 = type.intersection(this.type);
        if (this.type.equals(type2)) {
            return;
        }
        if (type2 == Type.tError && type != Type.tError) {
            GlobalOptions.err.println("setType: Type error in " + this + ": merging " + this.type + " and " + type);
            if (this.parent != null) {
                GlobalOptions.err.println("\tparent is " + this.parent);
            }
            if ((GlobalOptions.debuggingFlags & 4) != 0) {
                Thread.dumpStack();
            }
        }
        this.type = type2;
        if (this.type != Type.tError) {
            this.updateSubTypes();
        }
    }

    public void updateParentType(Type type) {
        this.setType(type);
        if (this.parent != null) {
            this.parent.updateType();
        }
    }

    public abstract void updateType();

    public abstract void updateSubTypes();

    public Type getType() {
        return this.type;
    }

    public Operator getParent() {
        return this.parent;
    }

    public abstract int getPriority();

    public int getBreakPenalty() {
        return 0;
    }

    public abstract int getFreeOperandCount();

    public abstract Expression addOperand(Expression var1);

    public Expression negate() {
        UnaryOperator unaryOperator = new UnaryOperator(Type.tBoolean, 34);
        unaryOperator.addOperand(this);
        return unaryOperator;
    }

    public boolean hasSideEffects(Expression expression) {
        return false;
    }

    public int canCombine(CombineableOperator combineableOperator) {
        return 0;
    }

    public boolean containsMatchingLoad(CombineableOperator combineableOperator) {
        return false;
    }

    public boolean containsConflictingLoad(MatchableOperator matchableOperator) {
        return false;
    }

    public Expression combine(CombineableOperator combineableOperator) {
        return null;
    }

    public Expression removeOnetimeLocals() {
        return this;
    }

    public Expression simplify() {
        return this;
    }

    public Expression simplifyString() {
        return this;
    }

    public Expression simplifyStringBuffer() {
        return null;
    }

    public void makeInitializer(Type type) {
    }

    public boolean isConstant() {
        return true;
    }

    public void fillInGenSet(Collection collection, Collection collection2) {
    }

    public void fillDeclarables(Collection collection) {
    }

    public void makeDeclaration(Set set) {
    }

    public abstract void dumpExpression(TabbedPrintWriter var1) throws IOException;

    public void dumpExpression(int n, TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.startOp(n, this.getBreakPenalty());
        this.dumpExpression(tabbedPrintWriter);
        tabbedPrintWriter.endOp();
    }

    public void dumpExpression(TabbedPrintWriter tabbedPrintWriter, int n) throws IOException {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if (this.type == Type.tError) {
            string = "/*TYPE_ERROR*/";
        } else if ((GlobalOptions.debuggingFlags & 4) != 0) {
            string = "(TYPE " + this.type + ")";
        }
        if (string != "") {
            if (n > 700) {
                bl = true;
                bl3 = true;
                tabbedPrintWriter.print("(");
                tabbedPrintWriter.startOp(0, 0);
            } else if (n < 700) {
                bl3 = true;
                tabbedPrintWriter.startOp(2, 1);
            }
            tabbedPrintWriter.print(string);
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(" ");
            n = 700;
        }
        if ((n2 = this.getPriority()) < n) {
            bl2 = true;
            bl4 = true;
            tabbedPrintWriter.print("(");
            tabbedPrintWriter.startOp(0, this.getBreakPenalty());
        } else if (n2 != n) {
            bl4 = true;
            if (this.getType() == Type.tVoid) {
                tabbedPrintWriter.startOp(1, this.getBreakPenalty());
            } else {
                tabbedPrintWriter.startOp(2, 1 + this.getBreakPenalty());
            }
        }
        try {
            this.dumpExpression(tabbedPrintWriter);
        }
        catch (RuntimeException runtimeException) {
            tabbedPrintWriter.print("(RUNTIME ERROR IN EXPRESSION)");
            runtimeException.printStackTrace(GlobalOptions.err);
        }
        if (bl4) {
            tabbedPrintWriter.endOp();
            if (bl2) {
                tabbedPrintWriter.print(")");
            }
        }
        if (bl3) {
            tabbedPrintWriter.endOp();
            if (bl) {
                tabbedPrintWriter.print(")");
            }
        }
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            TabbedPrintWriter tabbedPrintWriter = new TabbedPrintWriter(stringWriter);
            this.dumpExpression(tabbedPrintWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return "/*IOException*/" + super.toString();
        }
        catch (RuntimeException runtimeException) {
            return "/*RuntimeException*/" + super.toString();
        }
    }

    public boolean isVoid() {
        return this.getType() == Type.tVoid;
    }

    public Expression(Type type) {
        this.type = type;
    }
}

