/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.util.Enumeration;
import java.util.Vector;
import jode.GlobalOptions;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.LocalInfo;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.OuterValueListener;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.expr.OuterLocalOperator;
import jode.expr.ThisOperator;
import jode.type.Type;

public class OuterValues {
    private ClassAnalyzer clazzAnalyzer;
    private Expression[] head;
    private Vector ovListeners;
    private boolean jikesAnonymousInner;
    private boolean implicitOuterClass;
    private int headCount;
    private int headMinCount;

    public Expression getValue(int n) {
        return this.head[n];
    }

    public int getCount() {
        return this.headCount;
    }

    private int getNumberBySlot(int n) {
        --n;
        int n2 = 0;
        while (n >= 0 && n2 < this.headCount) {
            if (n == 0) {
                return n2;
            }
            n -= this.head[n2].getType().stackSize();
            ++n2;
        }
        return -1;
    }

    public Expression getValueBySlot(int n) {
        --n;
        int n2 = 0;
        while (n2 < this.headCount) {
            if (n == 0) {
                Expression expression = this.head[n2];
                if (n2 >= this.headMinCount) {
                    this.headMinCount = n2;
                }
                return expression;
            }
            n -= this.head[n2].getType().stackSize();
            ++n2;
        }
        return null;
    }

    private Expression liftOuterValue(LocalInfo localInfo, int n) {
        MethodAnalyzer methodAnalyzer = localInfo.getMethodAnalyzer();
        if (!methodAnalyzer.isConstructor() || methodAnalyzer.isStatic()) {
            return null;
        }
        OuterValues outerValues = methodAnalyzer.getClassAnalyzer().getOuterValues();
        if (outerValues == null) {
            return null;
        }
        int n2 = outerValues.getNumberBySlot(localInfo.getSlot());
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("  ovNr " + n2 + "," + outerValues);
        }
        if (n2 < 0 && outerValues.getCount() >= 1 && outerValues.isJikesAnonymousInner()) {
            Type[] typeArray = methodAnalyzer.getType().getParameterTypes();
            int n3 = 1;
            int n4 = 0;
            while (n4 < typeArray.length - 1) {
                n3 += typeArray[n4].stackSize();
                ++n4;
            }
            if (localInfo.getSlot() == n3) {
                n2 = 0;
            }
        }
        if (n2 < 0) {
            return null;
        }
        if (outerValues != this || n2 > n) {
            int n5 = n2;
            OuterValues outerValues2 = this;
            if (outerValues2 == null) {
                throw null;
            }
            outerValues.addOuterValueListener(new OuterValueListener(outerValues2, n5, n){
                private final /* synthetic */ OuterValues this$0;
                private final /* synthetic */ int val$limit;
                private final /* synthetic */ int val$nr;

                public void shrinkingOuterValues(OuterValues outerValues, int n) {
                    if (n <= this.val$limit) {
                        this.this$0.setCount(this.val$nr);
                    }
                }
                {
                    this.val$limit = n;
                    this.val$nr = n2;
                    this.this$0 = outerValues;
                    this.constructor$0(outerValues);
                }

                private final void constructor$0(OuterValues outerValues) {
                }
            });
        }
        return outerValues.head[n2];
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean unifyOuterValues(int n, Expression expression) {
        LocalInfo localInfo;
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("unifyOuterValues: " + this + "," + n + "," + expression);
        }
        Expression expression2 = expression;
        Expression expression3 = this.head[n];
        if (expression2 instanceof ThisOperator) {
            localInfo = null;
        } else if (expression2 instanceof OuterLocalOperator) {
            localInfo = ((OuterLocalOperator)expression2).getLocalInfo();
        } else {
            if (!(expression2 instanceof LocalLoadOperator)) {
                return false;
            }
            localInfo = ((LocalLoadOperator)expression2).getLocalInfo();
        }
        while (localInfo != null && !localInfo.getMethodAnalyzer().isMoreOuterThan(this.clazzAnalyzer)) {
            expression2 = this.liftOuterValue(localInfo, n);
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("  lift1 " + localInfo + " in " + localInfo.getMethodAnalyzer() + "  to " + expression2);
            }
            if (expression2 instanceof ThisOperator) {
                localInfo = null;
                continue;
            }
            if (!(expression2 instanceof OuterLocalOperator)) {
                return false;
            }
            localInfo = ((OuterLocalOperator)expression2).getLocalInfo();
        }
        while (!expression2.equals(expression3)) {
            if (!(expression3 instanceof OuterLocalOperator)) {
                return false;
            }
            LocalInfo localInfo2 = ((OuterLocalOperator)expression3).getLocalInfo();
            if (localInfo2.equals(localInfo)) break;
            expression3 = this.liftOuterValue(localInfo2, n);
            if ((GlobalOptions.debuggingFlags & 0x200) == 0) continue;
            GlobalOptions.err.println("  lift2 " + localInfo2 + " in " + localInfo2.getMethodAnalyzer() + "  to " + expression3);
        }
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("unifyOuterValues succeeded.");
        }
        return true;
    }

    public boolean isJikesAnonymousInner() {
        return this.jikesAnonymousInner;
    }

    public boolean isImplicitOuterClass() {
        return this.implicitOuterClass;
    }

    public void addOuterValueListener(OuterValueListener outerValueListener) {
        if (this.ovListeners == null) {
            this.ovListeners = new Vector();
        }
        this.ovListeners.addElement(outerValueListener);
    }

    public void setJikesAnonymousInner(boolean bl) {
        this.jikesAnonymousInner = bl;
    }

    public void setImplicitOuterClass(boolean bl) {
        this.implicitOuterClass = bl;
    }

    private static int countSlots(Expression[] expressionArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += expressionArray[n3].getType().stackSize();
            ++n3;
        }
        return n2;
    }

    public void setMinCount(int n) {
        if (this.headCount < n) {
            GlobalOptions.err.println("WARNING: something got wrong with scoped class " + this.clazzAnalyzer.getClazz() + ": " + n + "," + this.headCount);
            new Throwable().printStackTrace(GlobalOptions.err);
            this.headMinCount = this.headCount;
        } else if (n > this.headMinCount) {
            this.headMinCount = n;
        }
    }

    public void setCount(int n) {
        if (n >= this.headCount) {
            return;
        }
        this.headCount = n;
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("setCount: " + this + "," + n);
            new Throwable().printStackTrace(GlobalOptions.err);
        }
        if (n < this.headMinCount) {
            GlobalOptions.err.println("WARNING: something got wrong with scoped class " + this.clazzAnalyzer.getClazz() + ": " + this.headMinCount + "," + this.headCount);
            new Throwable().printStackTrace(GlobalOptions.err);
            this.headMinCount = n;
        }
        if (this.ovListeners != null) {
            Enumeration enumeration = this.ovListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((OuterValueListener)enumeration.nextElement()).shrinkingOuterValues(this, n);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.clazzAnalyzer.getClazz()).append(".OuterValues[");
        String string = "";
        int n = 1;
        int n2 = 0;
        while (n2 < this.headCount) {
            if (n2 == this.headMinCount) {
                stringBuffer.append("<-");
            }
            stringBuffer.append(string).append(n).append(":").append(this.head[n2]);
            n += this.head[n2].getType().stackSize();
            string = ",";
            ++n2;
        }
        if (this.jikesAnonymousInner) {
            stringBuffer.append("!jikesAnonymousInner");
        }
        if (this.implicitOuterClass) {
            stringBuffer.append("!implicitOuterClass");
        }
        return stringBuffer.append("]").toString();
    }

    public OuterValues(ClassAnalyzer classAnalyzer, Expression[] expressionArray) {
        this.clazzAnalyzer = classAnalyzer;
        this.head = expressionArray;
        this.headMinCount = 0;
        this.headCount = expressionArray.length;
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("Created OuterValues: " + this);
        }
    }
}

