
#include "mixr/graphics/readouts/OctalReadout.hpp"

#include "mixr/base/util/str_utils.hpp"

#include "ReformatScanner.hpp"

#include <cstdio>
#include <cstdlib>
#include <cstring>

namespace mixr {
namespace graphics {

IMPLEMENT_SUBCLASS(OctalReadout, "OctalReadout")
EMPTY_SLOTTABLE(OctalReadout)
EMPTY_COPYDATA(OctalReadout)
EMPTY_DELETEDATA(OctalReadout)

OctalReadout::OctalReadout()
{
   STANDARD_CONSTRUCTOR()
   base::utStrcpy(format, FORMAT_LENGTH, "%o");
}

//------------------------------------------------------------------------------
// input mode function --
//   filterInputEvent() -- Filter input events using a template character (tc)
//------------------------------------------------------------------------------
char OctalReadout::filterInputEvent(const int event, const char x)
{
   const char tc = static_cast<int>(x);
   if (tc == '0' || tc == '#') {
      // Default numeric keys
      if ( event >= '0' && event <= '7' ) {
         return static_cast<char>(event);
      } else {
         return '\0';
      }
   } else {
      return BaseClass::filterInputEvent(event,tc);
   }
}

//------------------------------------------------------------------------------
// getInputValue() -- returns the readout as a numeric value
//------------------------------------------------------------------------------
double OctalReadout::getInputValue() const
{
   int value {};

   // copy string to buffer with correct sign character
   const std::size_t CBUFLOCAL_LEN {100};
   char cbuf[CBUFLOCAL_LEN] {};
   const char* p {this->str.c_str()};
   base::utStrcpy(cbuf, CBUFLOCAL_LEN, p);
   if (cbuf[0] == plusChar)  cbuf[0] = '+';
   if (cbuf[0] == minusChar) cbuf[0] = '-';

   std::sscanf(cbuf, format, &value);
   return static_cast<double>(value);
}

//------------------------------------------------------------------------------
//  makeText() -- make the text string use the current value and formats
//------------------------------------------------------------------------------
void OctalReadout::makeText()
{
   std::sprintf(cbuf, format, getInt());
}

//------------------------------------------------------------------------------
// reformat() -- convert the numerical value into an ascii character string
//------------------------------------------------------------------------------
void OctalReadout::reformat(const char* const example)
{
   if (reformatter->convertOctal(example) != ReformatScanner::DataType::invalid) {
      setExample(example);
      base::utStrcpy(format, FORMAT_LENGTH, reformatter->getFormat());
      postSign = reformatter->isPostSign();
      redisplay();
   }
}

}
}
