
#include "mixr/base/ubf/IBehavior.hpp"

#include "mixr/base/numeric/Integer.hpp"
#include <iostream>

namespace mixr {
namespace base {
namespace ubf {

IMPLEMENT_ABSTRACT_SUBCLASS(IBehavior, "IBehavior")
EMPTY_DELETEDATA(IBehavior)
EMPTY_COPYDATA(IBehavior)

BEGIN_SLOTTABLE(IBehavior)
   "vote"            //  1) default vote/weight value for actions generated by this behavior
END_SLOTTABLE(IBehavior)

BEGIN_SLOT_MAP(IBehavior)
   ON_SLOT(1, setSlotVote, base::Integer)
END_SLOT_MAP()

IBehavior::IBehavior()
{
   STANDARD_CONSTRUCTOR()
}

// [ 1 .. 65535 ]
bool IBehavior::setSlotVote(const base::Integer* const x)
{
   bool ok{};
   const int vote{x->asInt()};
   if (vote > 0 && vote <= 65535) {
      setVote(vote);
      ok = true;
   }
   return ok;
}

}
}
}

