
#include "TableRow.hpp"

#include "mixr/base/Pair.hpp"
#include "mixr/base/IPairStream.hpp"

using namespace mixr;

IMPLEMENT_SUBCLASS(TableRow, "TableRow")
EMPTY_SLOTTABLE(TableRow)

TableRow::TableRow()
{
   STANDARD_CONSTRUCTOR()
}

void TableRow::copyData(const TableRow& org, const bool)
{
   BaseClass::copyData(org);
}

void TableRow::deleteData()
{
}

int TableRow::line() const
{
   return BaseClass::line();
}

void TableRow::line(const int ll)
{
   BaseClass::line(ll);
   position();
   return;
}

int TableRow::column() const
{
   return BaseClass::column();
}

void TableRow::column(const int cc)
{
   BaseClass::column(cc);
   position();
   return;
}

void  TableRow::put(base::Pair* pp)
{
   base::IPairStream* subcomponents{getComponents()};
   BaseClass::processComponents(subcomponents, typeid(graphics::IReadout), pp);
   if (subcomponents != nullptr) subcomponents->unref();
}

void TableRow::position()
{
   // position the fields in this table item
   base::IPairStream* subcomponents{getComponents()};
   if (subcomponents != nullptr) {

      int ln{line()};
      int cp{column()};

      base::IList::Item* item{subcomponents->getFirstItem()};
      while (item != nullptr) {
         const auto pair = static_cast<base::Pair*>(item->getValue());
         const auto ti = static_cast<graphics::IReadout*>(pair->object());

         ti->line(ln);
         ti->column(cp);
         cp += static_cast<int>(ti->width());

         item = item->getNext();
      }
      subcomponents->unref();
      subcomponents = nullptr;
   }
}
