
#ifndef __NavaidTests_HPP__
#define __NavaidTests_HPP__

#include <string>

namespace mixr {
namespace dafif { class NavaidLoader; } 
}

class NavaidTests final
{
public:
   NavaidTests(
      const std::string& country,
      const std::string& file = "FILE2",
      const std::string& path = "../../mixr-data/DAFIF/FULLALL/"
   );
   ~NavaidTests();

   void dump();      // dump raw DAFIF records
   void func20();    // print all records
   void func21(const double acLat, const double acLon, const double acElev, const bool printData);    // print selected record
   void func22(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByIdent()
   void func23();    // print freq list sorting
   void func24(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByFreq()
   void func25(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByRange()
   void func26(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByKey()
   void func27();    // print channel list sorting
   void func28(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByChannel()
   void func29(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByType()
   void func2A();    // print ICAO sorted listing
   void func2B(const double acLat, const double acLon, const double acElev, const bool printData);    // test queryByIcao()

private:
   mixr::dafif::NavaidLoader* db{};
};

#endif
