/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.util.FileUtil;

@ThreadSafe
public final class LinuxNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxNetworkIF.class);
    private int ifType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;

    public LinuxNetworkIF(NetworkInterface netint) throws InstantiationException {
        super(netint);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        ArrayList<LinuxNetworkIF> ifList = new ArrayList<LinuxNetworkIF>();
        for (NetworkInterface ni : LinuxNetworkIF.getNetworkInterfaces(includeLocalInterfaces)) {
            try {
                ifList.add(new LinuxNetworkIF(ni));
            }
            catch (InstantiationException e2) {
                LOG.debug("Network Interface Instantiation failed: {}", (Object)e2.getMessage());
            }
        }
        return Collections.unmodifiableList(ifList);
    }

    @Override
    public int getIfType() {
        return this.ifType;
    }

    @Override
    public boolean isConnectorPresent() {
        return this.connectorPresent;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        try {
            File ifDir = new File(String.format("/sys/class/net/%s/statistics", this.getName()));
            if (!ifDir.isDirectory()) {
                return false;
            }
        }
        catch (SecurityException e2) {
            return false;
        }
        String ifTypePath = String.format("/sys/class/net/%s/type", this.getName());
        String carrierPath = String.format("/sys/class/net/%s/carrier", this.getName());
        String txBytesPath = String.format("/sys/class/net/%s/statistics/tx_bytes", this.getName());
        String rxBytesPath = String.format("/sys/class/net/%s/statistics/rx_bytes", this.getName());
        String txPacketsPath = String.format("/sys/class/net/%s/statistics/tx_packets", this.getName());
        String rxPacketsPath = String.format("/sys/class/net/%s/statistics/rx_packets", this.getName());
        String txErrorsPath = String.format("/sys/class/net/%s/statistics/tx_errors", this.getName());
        String rxErrorsPath = String.format("/sys/class/net/%s/statistics/rx_errors", this.getName());
        String collisionsPath = String.format("/sys/class/net/%s/statistics/collisions", this.getName());
        String rxDropsPath = String.format("/sys/class/net/%s/statistics/rx_dropped", this.getName());
        String ifSpeed = String.format("/sys/class/net/%s/speed", this.getName());
        this.timeStamp = System.currentTimeMillis();
        this.ifType = FileUtil.getIntFromFile(ifTypePath);
        this.connectorPresent = FileUtil.getIntFromFile(carrierPath) > 0;
        this.bytesSent = FileUtil.getUnsignedLongFromFile(txBytesPath);
        this.bytesRecv = FileUtil.getUnsignedLongFromFile(rxBytesPath);
        this.packetsSent = FileUtil.getUnsignedLongFromFile(txPacketsPath);
        this.packetsRecv = FileUtil.getUnsignedLongFromFile(rxPacketsPath);
        this.outErrors = FileUtil.getUnsignedLongFromFile(txErrorsPath);
        this.inErrors = FileUtil.getUnsignedLongFromFile(rxErrorsPath);
        this.collisions = FileUtil.getUnsignedLongFromFile(collisionsPath);
        this.inDrops = FileUtil.getUnsignedLongFromFile(rxDropsPath);
        long speedMiB = FileUtil.getUnsignedLongFromFile(ifSpeed);
        this.speed = speedMiB < 0L ? 0L : speedMiB << 20;
        return true;
    }
}

