/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Wtsapi32;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.Win32Process;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
public final class ProcessWtsData {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWtsData.class);
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();

    private ProcessWtsData() {
    }

    public static Map<Integer, WtsInfo> queryProcessWtsMap(Collection<Integer> pids) {
        if (IS_WINDOWS7_OR_GREATER) {
            return ProcessWtsData.queryProcessWtsMapFromWTS(pids);
        }
        return ProcessWtsData.queryProcessWtsMapFromPerfMon(pids);
    }

    private static Map<Integer, WtsInfo> queryProcessWtsMapFromWTS(Collection<Integer> pids) {
        HashMap<Integer, WtsInfo> wtsMap = new HashMap<Integer, WtsInfo>();
        PointerByReference ppProcessInfo = new PointerByReference();
        IntByReference pCount = new IntByReference(0);
        if (!Wtsapi32.INSTANCE.WTSEnumerateProcessesEx(Wtsapi32.WTS_CURRENT_SERVER_HANDLE, new IntByReference(1), -2, ppProcessInfo, pCount)) {
            LOG.error("Failed to enumerate Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return wtsMap;
        }
        Pointer pProcessInfo = ppProcessInfo.getValue();
        Wtsapi32.WTS_PROCESS_INFO_EX processInfoRef = new Wtsapi32.WTS_PROCESS_INFO_EX(pProcessInfo);
        Wtsapi32.WTS_PROCESS_INFO_EX[] processInfo = (Wtsapi32.WTS_PROCESS_INFO_EX[])processInfoRef.toArray(pCount.getValue());
        for (int i2 = 0; i2 < processInfo.length; ++i2) {
            if (pids != null && !pids.contains(processInfo[i2].ProcessId)) continue;
            wtsMap.put(processInfo[i2].ProcessId, new WtsInfo(processInfo[i2].pProcessName, "", processInfo[i2].NumberOfThreads, (long)processInfo[i2].PagefileUsage & 0xFFFFFFFFL, processInfo[i2].KernelTime.getValue() / 10000L, processInfo[i2].UserTime.getValue() / 10000L, processInfo[i2].HandleCount));
        }
        if (!Wtsapi32.INSTANCE.WTSFreeMemoryEx(1, pProcessInfo, pCount.getValue())) {
            LOG.warn("Failed to Free Memory for Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
        }
        return wtsMap;
    }

    private static Map<Integer, WtsInfo> queryProcessWtsMapFromPerfMon(Collection<Integer> pids) {
        HashMap<Integer, WtsInfo> wtsMap = new HashMap<Integer, WtsInfo>();
        WbemcliUtil.WmiResult<Win32Process.ProcessXPProperty> processWmiResult = Win32Process.queryProcesses(pids);
        for (int i2 = 0; i2 < processWmiResult.getResultCount(); ++i2) {
            wtsMap.put(WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.PROCESSID, i2), new WtsInfo(WmiUtil.getString(processWmiResult, Win32Process.ProcessXPProperty.NAME, i2), WmiUtil.getString(processWmiResult, Win32Process.ProcessXPProperty.EXECUTABLEPATH, i2), WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.THREADCOUNT, i2), 1024L * ((long)WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.PAGEFILEUSAGE, i2) & 0xFFFFFFFFL), WmiUtil.getUint64(processWmiResult, Win32Process.ProcessXPProperty.KERNELMODETIME, i2) / 10000L, WmiUtil.getUint64(processWmiResult, Win32Process.ProcessXPProperty.USERMODETIME, i2) / 10000L, WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.HANDLECOUNT, i2)));
        }
        return wtsMap;
    }

    @Immutable
    public static class WtsInfo {
        private final String name;
        private final String path;
        private final int threadCount;
        private final long virtualSize;
        private final long kernelTime;
        private final long userTime;
        private final long openFiles;

        public WtsInfo(String name, String path, int threadCount, long virtualSize, long kernelTime, long userTime, long openFiles) {
            this.name = name;
            this.path = path;
            this.threadCount = threadCount;
            this.virtualSize = virtualSize;
            this.kernelTime = kernelTime;
            this.userTime = userTime;
            this.openFiles = openFiles;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public long getVirtualSize() {
            return this.virtualSize;
        }

        public long getKernelTime() {
            return this.kernelTime;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public long getOpenFiles() {
            return this.openFiles;
        }
    }
}

