/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util.internal;

import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.internal.SourceStreamIOException;

public class PgBufferedOutputStream
extends FilterOutputStream {
    protected final byte[] buf;
    protected int count;

    public PgBufferedOutputStream(OutputStream out, int bufferSize) {
        super(out);
        this.buf = new byte[bufferSize];
    }

    protected void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public void writeInt2(int val) throws IOException {
        byte[] buf = this.buf;
        if (buf.length - this.count < 2) {
            this.flushBuffer();
        }
        int count = this.count;
        ByteConverter.int2(buf, count, val);
        this.count = count + 2;
    }

    public void writeInt4(int val) throws IOException {
        byte[] buf = this.buf;
        if (buf.length - this.count < 4) {
            this.flushBuffer();
        }
        int count = this.count;
        ByteConverter.int4(buf, count, val);
        this.count = count + 4;
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b2;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.count > 0) {
            int avail = this.buf.length - this.count;
            if (avail + this.buf.length <= len) {
                this.flushBuffer();
                this.out.write(b2, off, len);
                return;
            }
            int prefixLength = Math.min(len, avail);
            System.arraycopy(b2, off, this.buf, this.count, prefixLength);
            this.count += prefixLength;
            off += prefixLength;
            len -= prefixLength;
            if (this.count == this.buf.length) {
                this.flushBuffer();
            }
            if (len == 0) {
                return;
            }
        }
        if (len >= this.buf.length) {
            this.out.write(b2, off, len);
            return;
        }
        System.arraycopy(b2, off, this.buf, 0, len);
        this.count = len;
    }

    public void write(InputStream inStream, int remaining) throws IOException {
        int expectedLength = remaining;
        byte[] buf = this.buf;
        while (remaining > 0) {
            int readCount;
            int readSize = Math.min(remaining, buf.length - this.count);
            try {
                readCount = inStream.read(buf, this.count, readSize);
            }
            catch (IOException e2) {
                throw new SourceStreamIOException(remaining, e2);
            }
            if (readCount < 0) {
                throw new SourceStreamIOException(remaining, new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", expectedLength, expectedLength - remaining)));
            }
            this.count += readCount;
            remaining -= readCount;
            if (this.count != buf.length) continue;
            this.flushBuffer();
        }
    }

    public void writeZeros(int len) throws IOException {
        int startPos = this.count;
        if (this.count > 0) {
            int avail = this.buf.length - this.count;
            int prefixLength = Math.min(len, avail);
            Arrays.fill(this.buf, this.count, this.count + prefixLength, (byte)0);
            this.count += prefixLength;
            len -= prefixLength;
            if (this.count == this.buf.length) {
                this.flushBuffer();
            }
            if (len == 0) {
                return;
            }
        }
        Arrays.fill(this.buf, 0, Math.min(startPos, len), (byte)0);
        while (len >= this.buf.length) {
            this.count = this.buf.length;
            this.flushBuffer();
            len -= this.buf.length;
        }
        this.count = len;
    }
}

