/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.postgresql.shaded.com.ongres.scram.common.StringWritable;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

final class StringWritableCsv {
    private StringWritableCsv() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    static StringBuilder writeTo(@NotNull StringBuilder sb, StringWritable ... values) {
        Preconditions.checkNotNull(sb, "sb");
        if (null == values || values.length == 0) {
            return sb;
        }
        if (null != values[0]) {
            Preconditions.castNonNull(values[0]).writeTo(sb);
        }
        for (int i2 = 1; i2 < values.length; ++i2) {
            sb.append(',');
            if (null == values[i2]) continue;
            Preconditions.castNonNull(values[i2]).writeTo(sb);
        }
        return sb;
    }

    @NotNull
    static @NotNull String @NotNull [] parseFrom(@NotNull String value, int n2, int offset) {
        Preconditions.checkNotNull(value, "value");
        if (n2 < 0 || offset < 0) {
            throw new IllegalArgumentException("Limit and offset have to be >= 0");
        }
        if (value.isEmpty()) {
            return new String[0];
        }
        String[] split = value.split(",", -1);
        if (split.length < offset) {
            throw new IllegalArgumentException("Not enough items for the given offset");
        }
        return Arrays.copyOfRange(split, offset, (n2 == 0 ? split.length : n2) + offset);
    }

    @NotNull
    static @NotNull String @NotNull [] parseFrom(@NotNull String value, int n2) {
        return StringWritableCsv.parseFrom(value, n2, 0);
    }

    @NotNull
    static @NotNull String @NotNull [] parseFrom(@NotNull String value) {
        return StringWritableCsv.parseFrom(value, 0, 0);
    }
}

