/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.postgresql.shaded.com.ongres.saslprep.SASLprep;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import org.postgresql.shaded.com.ongres.stringprep.Profile;

final class ScramStringFormatting {
    static final Profile SASL_PREP = new SASLprep();

    private ScramStringFormatting() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    static String toSaslName(@NotNull String value) {
        if (value.isEmpty()) {
            return value;
        }
        char[] originalChars = SASL_PREP.prepareQuery(value.toCharArray());
        int comma = 0;
        int equal = 0;
        for (char c2 : originalChars) {
            if (',' == c2) {
                ++comma;
                continue;
            }
            if ('=' != c2) continue;
            ++equal;
        }
        if (comma == 0 && equal == 0) {
            return new String(originalChars);
        }
        char[] saslChars = new char[originalChars.length + comma * 2 + equal * 2];
        int i2 = 0;
        for (char c3 : originalChars) {
            if (',' == c3) {
                saslChars[i2++] = 61;
                saslChars[i2++] = 50;
                saslChars[i2++] = 67;
                continue;
            }
            if ('=' == c3) {
                saslChars[i2++] = 61;
                saslChars[i2++] = 51;
                saslChars[i2++] = 68;
                continue;
            }
            saslChars[i2++] = c3;
        }
        return new String(saslChars);
    }

    @Nullable
    static String fromSaslName(@Nullable String value) {
        if (null == value || value.isEmpty()) {
            return value;
        }
        int equal = 0;
        char[] orig = value.toCharArray();
        for (int i2 = 0; i2 < orig.length; ++i2) {
            if (orig[i2] == ',') {
                throw new IllegalArgumentException("Invalid ',' character present in saslName");
            }
            if (orig[i2] != '=') continue;
            ++equal;
            if (i2 + 2 > orig.length - 1) {
                throw new IllegalArgumentException("Invalid '=' character present in saslName");
            }
            if (orig[i2 + 1] == '2' && orig[i2 + 2] == 'C' || orig[i2 + 1] == '3' && orig[i2 + 2] == 'D') continue;
            throw new IllegalArgumentException("Invalid char '=" + orig[i2 + 1] + orig[i2 + 2] + "' found in saslName");
        }
        if (equal == 0) {
            return value;
        }
        char[] replaced = new char[orig.length - equal * 2];
        int o2 = 0;
        for (int r2 = 0; r2 < replaced.length; ++r2) {
            if ('=' == orig[o2]) {
                if (orig[o2 + 1] == '2' && orig[o2 + 2] == 'C') {
                    replaced[r2] = 44;
                } else if (orig[o2 + 1] == '3' && orig[o2 + 2] == 'D') {
                    replaced[r2] = 61;
                }
                o2 += 3;
                continue;
            }
            replaced[r2] = orig[o2];
            ++o2;
        }
        return new String(replaced);
    }

    @NotNull
    static String base64Encode(byte @NotNull [] value) {
        Preconditions.checkNotNull(value, "value");
        return new String(Base64.getEncoder().encode(value), StandardCharsets.UTF_8);
    }

    static byte @NotNull [] base64Decode(@NotNull String value) {
        Preconditions.checkNotEmpty(value, "value");
        return Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
    }
}

