/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.postgresql.shaded.com.ongres.scram.common.AbstractScramMessage;
import org.postgresql.shaded.com.ongres.scram.common.Gs2CbindFlag;
import org.postgresql.shaded.com.ongres.scram.common.Gs2Header;
import org.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import org.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import org.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import org.postgresql.shaded.com.ongres.scram.common.StringWritableCsv;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

public final class ClientFirstMessage
extends AbstractScramMessage {
    @NotNull
    private final Gs2Header gs2Header;
    @NotNull
    private final String username;
    @NotNull
    private final String clientNonce;

    public ClientFirstMessage(@NotNull Gs2Header gs2Header, @NotNull String username, @NotNull String clientNonce) {
        this.gs2Header = Preconditions.checkNotNull(gs2Header, "gs2Header");
        this.username = ScramStringFormatting.toSaslName(Preconditions.checkNotEmpty(username, "username"));
        this.clientNonce = Preconditions.checkNotEmpty(clientNonce, "clientNonce");
    }

    public ClientFirstMessage(@NotNull Gs2CbindFlag gs2CbindFlag, @Nullable String cbindName, @Nullable String authzid, @NotNull String username, @NotNull String clientNonce) {
        this(new Gs2Header(gs2CbindFlag, cbindName, authzid), username, clientNonce);
    }

    public ClientFirstMessage(@NotNull String username, @NotNull String clientNonce) {
        this(new Gs2Header(Gs2CbindFlag.CLIENT_NOT), username, clientNonce);
    }

    public boolean isChannelBindingRequired() {
        return this.gs2Header.getChannelBindingFlag() == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED;
    }

    @NotNull
    public Gs2Header getGs2Header() {
        return this.gs2Header;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public String getClientNonce() {
        return this.clientNonce;
    }

    @NotNull
    StringBuilder clientFirstMessageBare(@NotNull StringBuilder sb) {
        return StringWritableCsv.writeTo(sb, new ScramAttributeValue(ScramAttributes.USERNAME, this.username), new ScramAttributeValue(ScramAttributes.NONCE, this.clientNonce));
    }

    @NotNull
    public static ClientFirstMessage parseFrom(@NotNull String clientFirstMessage) throws ScramParseException {
        String[] userNonceString;
        Preconditions.checkNotEmpty(clientFirstMessage, "clientFirstMessage");
        try {
            userNonceString = StringWritableCsv.parseFrom(clientFirstMessage, 2, 2);
        }
        catch (IllegalArgumentException e2) {
            throw new ScramParseException("Illegal series of attributes in client-first-message", e2);
        }
        ScramAttributeValue user = ScramAttributeValue.parse(userNonceString[0]);
        if (ScramAttributes.USERNAME.getChar() != user.getChar()) {
            throw new ScramParseException("user must be the 3rd element of the client-first-message");
        }
        ScramAttributeValue nonce = ScramAttributeValue.parse(userNonceString[1]);
        if (ScramAttributes.NONCE.getChar() != nonce.getChar()) {
            throw new ScramParseException("nonce must be the 4th element of the client-first-message");
        }
        Gs2Header gs2Header = Gs2Header.parseFrom(clientFirstMessage);
        return new ClientFirstMessage(gs2Header, user.getValue(), nonce.getValue());
    }

    @Override
    StringBuilder writeTo(StringBuilder sb) {
        StringWritableCsv.writeTo(sb, this.gs2Header, null);
        return this.clientFirstMessageBare(sb);
    }
}

