/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.PGProperty;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolVersion;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.SocketFactoryFactory;
import org.postgresql.core.Tuple;
import org.postgresql.core.Utils;
import org.postgresql.core.Version;
import org.postgresql.core.v3.AuthenticationPluginManager;
import org.postgresql.core.v3.ChannelBindingOption;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.core.v3.ScramAuthenticator;
import org.postgresql.gss.MakeGSS;
import org.postgresql.hostchooser.CandidateHost;
import org.postgresql.hostchooser.GlobalHostStatusTracker;
import org.postgresql.hostchooser.HostChooser;
import org.postgresql.hostchooser.HostChooserFactory;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.jdbc.GSSEncMode;
import org.postgresql.jdbc.SslMode;
import org.postgresql.jdbc.SslNegotiation;
import org.postgresql.plugin.AuthenticationRequestType;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.sspi.ISSPIClient;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.internal.Nullness;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;
    private static final String IN_HOT_STANDBY = "in_hot_standby";

    private static ISSPIClient createSSPI(PGStream pgStream, @Nullable String spnServiceClass, boolean enableNegotiate) {
        try {
            Class<?> c2 = Class.forName("org.postgresql.sspi.SSPIClient");
            return (ISSPIClient)c2.getDeclaredConstructor(PGStream.class, String.class, Boolean.TYPE).newInstance(pgStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception e2) {
            throw new IllegalStateException("Unable to load org.postgresql.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", e2);
        }
    }

    private PGStream tryConnect(Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode, GSSEncMode gssEncMode) throws SQLException, IOException {
        int connectTimeout = PGProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        String user = PGProperty.USER.getOrDefault(info);
        String database = PGProperty.PG_DBNAME.getOrDefault(info);
        SslNegotiation sslNegotiation = SslNegotiation.of(Nullness.castNonNull(PGProperty.SSL_NEGOTIATION.getOrDefault(info)));
        if (user == null) {
            throw new PSQLException(GT.tr("User cannot be null", new Object[0]), PSQLState.INVALID_NAME);
        }
        if (database == null) {
            throw new PSQLException(GT.tr("Database cannot be null", new Object[0]), PSQLState.INVALID_NAME);
        }
        int maxSendBufferSize = PGProperty.MAX_SEND_BUFFER_SIZE.getInt(info);
        PGStream newStream = new PGStream(socketFactory, hostSpec, connectTimeout, maxSendBufferSize);
        try {
            int sendBufferSize;
            int socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info);
            if (socketTimeout > 0) {
                newStream.setNetworkTimeout(socketTimeout * 1000);
            }
            String maxResultBuffer = PGProperty.MAX_RESULT_BUFFER.getOrDefault(info);
            newStream.setMaxResultBuffer(maxResultBuffer);
            boolean requireTCPKeepAlive = PGProperty.TCP_KEEP_ALIVE.getBoolean(info);
            newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
            boolean requireTCPNoDelay = PGProperty.TCP_NO_DELAY.getBoolean(info);
            newStream.getSocket().setTcpNoDelay(requireTCPNoDelay);
            int receiveBufferSize = PGProperty.RECEIVE_BUFFER_SIZE.getInt(info);
            if (receiveBufferSize > -1) {
                if (receiveBufferSize > 0) {
                    newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
                } else {
                    LOGGER.log(Level.WARNING, "Ignore invalid value for receiveBufferSize: {0}", receiveBufferSize);
                }
            }
            if ((sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
                if (sendBufferSize > 0) {
                    newStream.getSocket().setSendBufferSize(sendBufferSize);
                } else {
                    LOGGER.log(Level.WARNING, "Ignore invalid value for sendBufferSize: {0}", sendBufferSize);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Receive Buffer Size is {0}", newStream.getSocket().getReceiveBufferSize());
                LOGGER.log(Level.FINE, "Send Buffer Size is {0}", newStream.getSocket().getSendBufferSize());
            }
            if (sslNegotiation != SslNegotiation.DIRECT) {
                newStream = ConnectionFactoryImpl.enableGSSEncrypted(newStream, gssEncMode, hostSpec.getHost(), info, connectTimeout);
            }
            if (!newStream.isGssEncrypted()) {
                newStream = ConnectionFactoryImpl.enableSSL(newStream, sslMode, info, connectTimeout);
            }
            if (socketTimeout > 0) {
                newStream.setNetworkTimeout(socketTimeout * 1000);
            }
            List<StartupParam> paramList = ConnectionFactoryImpl.getParametersForStartup(user, database, info);
            String protocolVersion = PGProperty.PROTOCOL_VERSION.getOrDefault(info);
            int protocolMajor = 3;
            int protocolMinor = 0;
            if (protocolVersion != null) {
                int decimal = protocolVersion.indexOf(46);
                if (decimal == -1) {
                    protocolMinor = Integer.parseInt(protocolVersion);
                    protocolMinor = 0;
                } else {
                    protocolMinor = Integer.parseInt(protocolVersion.substring(decimal + 1));
                    protocolMajor = Integer.parseInt(protocolVersion.substring(0, decimal));
                }
            }
            ConnectionFactoryImpl.sendStartupPacket(newStream, ProtocolVersion.fromMajorMinor(protocolMajor, protocolMinor), paramList);
            ConnectionFactoryImpl.doAuthentication(newStream, hostSpec.getHost(), user, info);
            return newStream;
        }
        catch (Exception e2) {
            this.closeStream(newStream);
            throw e2;
        }
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, Properties info) throws SQLException {
        HostRequirement targetServerType;
        SslMode sslMode = SslMode.of(info);
        GSSEncMode gssEncMode = GSSEncMode.of(info);
        String targetServerTypeStr = Nullness.castNonNull(PGProperty.TARGET_SERVER_TYPE.getOrDefault(info));
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new PSQLException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext()) {
            CandidateHost candidateHost = hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            LOGGER.log(Level.FINE, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            HostStatus knownStatus = (HostStatus)((Object)knownStates.get(hostSpec));
            if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, knownStatus, candidateHost.targetServerType});
                continue;
            }
            PGStream newStream = null;
            try {
                try {
                    newStream = this.tryConnect(info, socketFactory, hostSpec, sslMode, gssEncMode);
                }
                catch (SQLException e2) {
                    Exception ex;
                    if (sslMode == SslMode.PREFER && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e2.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(info, socketFactory, hostSpec, SslMode.DISABLE, gssEncMode);
                            LOGGER.log(Level.FINE, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                        }
                        catch (IOException | SQLException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            ConnectionFactoryImpl.log(Level.FINE, "sslMode==PREFER, however non-SSL connection failed as well", ex, new Object[0]);
                            e2.addSuppressed(ex);
                            throw e2;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e2.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(info, socketFactory, hostSpec, SslMode.REQUIRE, gssEncMode);
                            LOGGER.log(Level.FINE, "Upgraded to encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            ConnectionFactoryImpl.log(Level.FINE, "sslMode==ALLOW, however SSL connection failed as well", ex, new Object[0]);
                            e2.addSuppressed(ex);
                            throw e2;
                        }
                    }
                    throw e2;
                }
                int cancelSignalTimeout = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                Nullness.castNonNull(newStream);
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, cancelSignalTimeout, info);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus = ConnectionFactoryImpl.isPrimary(queryExecutor) ? HostStatus.Primary : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    queryExecutor.close();
                    continue;
                }
                ConnectionFactoryImpl.runInitialQueries(queryExecutor, info);
                return queryExecutor;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "ConnectException occurred while connecting to {0}", cex, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "IOException occurred while connecting to {0}", ioe, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "SQLException occurred while connecting to {0}", se, hostSpec);
                    continue;
                }
                throw se;
            }
        }
        throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private static List<StartupParam> getParametersForStartup(String user, String database, Properties info) {
        String options;
        String currentSchema;
        String replication;
        ArrayList<StartupParam> paramList = new ArrayList<StartupParam>();
        paramList.add(new StartupParam("user", user));
        paramList.add(new StartupParam("database", database));
        paramList.add(new StartupParam("client_encoding", "UTF8"));
        paramList.add(new StartupParam("DateStyle", "ISO"));
        paramList.add(new StartupParam("TimeZone", ConnectionFactoryImpl.createPostgresTimeZone()));
        Version assumeVersion = ServerVersion.from(PGProperty.ASSUME_MIN_SERVER_VERSION.getOrDefault(info));
        String appName = PGProperty.APPLICATION_NAME.getOrDefault(info);
        if (appName != null && assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add(new StartupParam("application_name", appName));
        }
        if ((replication = PGProperty.REPLICATION.getOrDefault(info)) != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            paramList.add(new StartupParam("replication", replication));
        }
        if ((currentSchema = PGProperty.CURRENT_SCHEMA.getOrDefault(info)) != null) {
            paramList.add(new StartupParam("search_path", currentSchema));
        }
        if ((options = PGProperty.OPTIONS.getOrDefault(info)) != null) {
            paramList.add(new StartupParam("options", options));
        }
        return paramList;
    }

    private static void log(Level level, String msg, Throwable thrown, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(LOGGER.getName());
        rec.setParameters(params);
        rec.setThrown(thrown);
        LOGGER.log(rec);
    }

    private static String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private static PGStream enableGSSEncrypted(PGStream pgStream, GSSEncMode gssEncMode, String host, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (gssEncMode == GSSEncMode.DISABLE) {
            return pgStream;
        }
        if (gssEncMode == GSSEncMode.ALLOW) {
            return pgStream;
        }
        String user = PGProperty.USER.getOrDefault(info);
        if (user == null) {
            throw new PSQLException("GSSAPI encryption required but was impossible user is null", PSQLState.CONNECTION_REJECTED);
        }
        LOGGER.log(Level.FINEST, " FE=> GSSENCRequest");
        int gssTimeout = PGProperty.SSL_RESPONSE_TIMEOUT.getInt(info);
        int currentTimeout = pgStream.getNetworkTimeout();
        if (currentTimeout > 0 && currentTimeout < gssTimeout) {
            gssTimeout = currentTimeout;
        }
        pgStream.setNetworkTimeout(gssTimeout);
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5680);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        pgStream.setNetworkTimeout(currentTimeout);
        switch (beresp) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncrypted Error");
                if (gssEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support GSS Encoding.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                int maxSendBufferSize = PGProperty.MAX_SEND_BUFFER_SIZE.getInt(info);
                return new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout, maxSendBufferSize);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncrypted Refused");
                if (gssEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support GSS Encryption.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 71: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncryptedOk");
                try {
                    AuthenticationPluginManager.withPassword(AuthenticationRequestType.GSS, info, password -> {
                        MakeGSS.authenticate(true, pgStream, host, user, password, PGProperty.JAAS_APPLICATION_NAME.getOrDefault(info), PGProperty.KERBEROS_SERVER_NAME.getOrDefault(info), false, PGProperty.JAAS_LOGIN.getBoolean(info), PGProperty.GSS_USE_DEFAULT_CREDS.getBoolean(info), PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        return Void.TYPE;
                    });
                    return pgStream;
                }
                catch (PSQLException ex) {
                    if (gssEncMode != GSSEncMode.PREFER) break;
                    return new PGStream(pgStream, connectTimeout);
                }
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the GSS Encoded connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private static PGStream enableSSL(PGStream pgStream, SslMode sslMode, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (sslMode == SslMode.DISABLE) {
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return pgStream;
        }
        SslNegotiation sslNegotiation = SslNegotiation.of(Nullness.castNonNull(PGProperty.SSL_NEGOTIATION.getOrDefault(info)));
        LOGGER.log(Level.FINEST, () -> String.format(" FE=> SSLRequest %s", sslNegotiation.value()));
        int sslTimeout = PGProperty.SSL_RESPONSE_TIMEOUT.getInt(info);
        int currentTimeout = pgStream.getNetworkTimeout();
        if (currentTimeout > 0 && currentTimeout < sslTimeout) {
            sslTimeout = currentTimeout;
        }
        pgStream.setNetworkTimeout(sslTimeout);
        if (sslNegotiation == SslNegotiation.DIRECT) {
            MakeSSL.convert(pgStream, info);
            return pgStream;
        }
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        pgStream.setNetworkTimeout(currentTimeout);
        switch (beresp) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE SSLError");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return new PGStream(pgStream, connectTimeout);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE SSLRefused");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                LOGGER.log(Level.FINEST, " <=BE SSLOk");
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the SSL connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private static void sendStartupPacket(PGStream pgStream, ProtocolVersion protocolVersion, List<StartupParam> params) throws SQLException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i2 = 0; i2 < params.size(); ++i2) {
                if (i2 != 0) {
                    details.append(", ");
                }
                details.append(params.get(i2).toString());
            }
            LOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i3 = 0; i3 < params.size(); ++i3) {
            encodedParams[i3 * 2] = params.get(i3).getEncodedKey();
            encodedParams[i3 * 2 + 1] = params.get(i3).getEncodedValue();
            length += encodedParams[i3 * 2].length + 1 + encodedParams[i3 * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(protocolVersion.getMajor());
        pgStream.sendInteger2(protocolVersion.getMinor());
        for (byte[] encodedParam : encodedParams) {
            pgStream.send(encodedParam);
            pgStream.sendChar(0);
        }
        pgStream.sendChar(0);
        pgStream.setProtocolVersion(protocolVersion);
        pgStream.flush();
    }

    private static String getAuthenticationMethodName(int authReq) {
        switch (authReq) {
            case 0: {
                return "none";
            }
            case 3: {
                return "password";
            }
            case 5: {
                return "md5";
            }
            case 7: {
                return "gss";
            }
            case 9: {
                return "sspi";
            }
            case 10: {
                return "sasl";
            }
            case 11: {
                return "sasl-continue";
            }
            case 12: {
                return "sasl-final";
            }
        }
        return String.valueOf(authReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAuthentication(PGStream pgStream, String host, String user, Properties info) throws IOException, SQLException {
        block44: {
            ISSPIClient sspiClient = null;
            ScramAuthenticator scramAuthenticator = null;
            int protocol = 196608;
            boolean saslHandshakeCompleted = false;
            try {
                while (true) {
                    int beresp = pgStream.receiveChar();
                    block4 : switch (beresp) {
                        case 118: {
                            pgStream.receiveInteger4();
                            protocol = pgStream.receiveInteger4();
                            int numOptionsNotRecognized = pgStream.receiveInteger4();
                            if (numOptionsNotRecognized > 0) {
                                String errorMessage = "Protocol error, received invalid options: ";
                                for (int i2 = 0; i2 < numOptionsNotRecognized; ++i2) {
                                    errorMessage = errorMessage + (i2 > 0 ? "" : "," + pgStream.receiveString());
                                }
                                LOGGER.log(Level.FINEST, errorMessage);
                                throw new PSQLException(errorMessage, PSQLState.PROTOCOL_VIOLATION);
                            }
                            int major = protocol >> 16 & 0xFF;
                            int minor = protocol & 0xFF;
                            pgStream.setProtocolVersion(ProtocolVersion.fromMajorMinor(major, minor));
                            break;
                        }
                        case 69: {
                            int elen = pgStream.receiveInteger4();
                            ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(elen - 4));
                            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", errorMsg);
                            throw new PSQLException(errorMsg, PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        }
                        case 82: {
                            int msgLen = pgStream.receiveInteger4();
                            int areq = pgStream.receiveInteger4();
                            if (ChannelBindingOption.of(info) == ChannelBindingOption.REQUIRE) {
                                if (areq == 0) {
                                    if (!saslHandshakeCompleted) {
                                        throw new PSQLException(GT.tr("Channel binding is required, but server skipped authentication. Channel binding is only supported with SCRAM authentication over encrypted connections.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                } else if (areq != 10 && areq != 11 && areq != 12) {
                                    throw new PSQLException(GT.tr("Channel binding is required, but server requested ''{0}'' authentication. Channel binding is only supported with SCRAM authentication over encrypted connections.", ConnectionFactoryImpl.getAuthenticationMethodName(areq)), PSQLState.CONNECTION_REJECTED);
                                }
                            }
                            switch (areq) {
                                case 5: {
                                    byte[] md5Salt = pgStream.receive(4);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                                    }
                                    byte[] digest = AuthenticationPluginManager.withEncodedPassword(AuthenticationRequestType.MD5_PASSWORD, info, encodedPassword -> MD5Digest.encode(user.getBytes(StandardCharsets.UTF_8), encodedPassword, md5Salt));
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, StandardCharsets.US_ASCII));
                                    }
                                    try {
                                        pgStream.sendChar(112);
                                        pgStream.sendInteger4(4 + digest.length + 1);
                                        pgStream.send(digest);
                                    }
                                    finally {
                                        Arrays.fill(digest, (byte)0);
                                    }
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block4;
                                }
                                case 3: {
                                    LOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword");
                                    LOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)");
                                    AuthenticationPluginManager.withEncodedPassword(AuthenticationRequestType.CLEARTEXT_PASSWORD, info, encodedPassword -> {
                                        pgStream.sendChar(112);
                                        pgStream.sendInteger4(4 + ((byte[])encodedPassword).length + 1);
                                        pgStream.send((byte[])encodedPassword);
                                        return Void.TYPE;
                                    });
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block4;
                                }
                                case 7: 
                                case 9: {
                                    String gsslib = PGProperty.GSS_LIB.getOrDefault(info);
                                    boolean usespnego = PGProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPI = false;
                                    if ("gssapi".equals(gsslib)) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, param gsslib=gssapi");
                                    } else if (areq == 7 && !"sspi".equals(gsslib)) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced");
                                    } else {
                                        sspiClient = ConnectionFactoryImpl.createSSPI(pgStream, PGProperty.SSPI_SERVICE_CLASS.getOrDefault(info), areq == 9 || areq == 7 && usespnego);
                                        useSSPI = sspiClient.isSSPISupported();
                                        LOGGER.log(Level.FINE, "SSPI support detected: {0}", useSSPI);
                                        if (!useSSPI) {
                                            sspiClient = null;
                                            if ("sspi".equals(gsslib)) {
                                                throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", new Object[]{useSSPI, gsslib});
                                        }
                                    }
                                    if (useSSPI) {
                                        Nullness.castNonNull(sspiClient).startSSPI();
                                        break block4;
                                    }
                                    AuthenticationPluginManager.withPassword(AuthenticationRequestType.GSS, info, password -> {
                                        MakeGSS.authenticate(false, pgStream, host, user, password, PGProperty.JAAS_APPLICATION_NAME.getOrDefault(info), PGProperty.KERBEROS_SERVER_NAME.getOrDefault(info), usespnego, PGProperty.JAAS_LOGIN.getBoolean(info), PGProperty.GSS_USE_DEFAULT_CREDS.getBoolean(info), PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                                        return Void.TYPE;
                                    });
                                    break block4;
                                }
                                case 8: {
                                    Nullness.castNonNull(sspiClient).continueSSPI(msgLen - 8);
                                    break block4;
                                }
                                case 10: {
                                    scramAuthenticator = AuthenticationPluginManager.withPassword(AuthenticationRequestType.SASL, info, password -> {
                                        if (password == null) {
                                            throw new PSQLException(GT.tr("The server requested SCRAM-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                        }
                                        if (((char[])password).length == 0) {
                                            throw new PSQLException(GT.tr("The server requested SCRAM-based authentication, but the password is an empty string.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                        }
                                        return new ScramAuthenticator((char[])password, pgStream, info);
                                    });
                                    scramAuthenticator.handleAuthenticationSASL();
                                    break block4;
                                }
                                case 11: {
                                    ((ScramAuthenticator)Nullness.castNonNull(scramAuthenticator)).handleAuthenticationSASLContinue(msgLen - 4 - 4);
                                    break block4;
                                }
                                case 12: {
                                    ((ScramAuthenticator)Nullness.castNonNull(scramAuthenticator)).handleAuthenticationSASLFinal(msgLen - 4 - 4);
                                    saslHandshakeCompleted = true;
                                    break block4;
                                }
                                case 0: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationOk");
                                    break block44;
                                }
                                default: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), PSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            finally {
                if (sspiClient != null) {
                    try {
                        sspiClient.dispose();
                    }
                    catch (RuntimeException ex) {
                        LOGGER.log(Level.FINE, "Unexpected error during SSPI context disposal", ex);
                    }
                }
            }
        }
    }

    private static void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        boolean sendExtraFloatDigits;
        Version assumeVersion = ServerVersion.from(PGProperty.ASSUME_MIN_SERVER_VERSION.getOrDefault(info));
        int dbVersion = queryExecutor.getServerVersionNum();
        StringBuilder sb = new StringBuilder();
        String appName = PGProperty.APPLICATION_NAME.getOrDefault(info);
        boolean sendApplicationName = appName != null && assumeVersion.getVersionNum() < ServerVersion.v9_0.getVersionNum() && dbVersion >= ServerVersion.v9_0.getVersionNum();
        boolean bl = sendExtraFloatDigits = dbVersion < ServerVersion.v12.getVersionNum();
        if (sendApplicationName || sendExtraFloatDigits) {
            if (sendExtraFloatDigits) {
                if (dbVersion < ServerVersion.v9_0.getVersionNum()) {
                    sb.append("SET extra_float_digits = 2");
                } else {
                    sb.append("SET extra_float_digits = 3");
                }
            }
            if (sendApplicationName) {
                if (sendExtraFloatDigits) {
                    sb.append(';');
                }
                sb.append("SET application_name = '");
                Utils.escapeLiteral(sb, Nullness.castNonNull(appName), queryExecutor.getStandardConformingStrings());
                sb.append("'");
            }
            SetupQueryRunner.run(queryExecutor, sb.toString(), false);
        }
    }

    private static boolean isPrimary(QueryExecutor queryExecutor) throws SQLException, IOException {
        String inHotStandby = queryExecutor.getParameterStatus(IN_HOT_STANDBY);
        if ("on".equalsIgnoreCase(inHotStandby)) {
            return false;
        }
        Tuple results = SetupQueryRunner.run(queryExecutor, "show transaction_read_only", true);
        Tuple nonNullResults = Nullness.castNonNull(results);
        String queriedTransactionReadonly = queryExecutor.getEncoding().decode(Nullness.castNonNull(nonNullResults.get(0)));
        return "off".equalsIgnoreCase(queriedTransactionReadonly);
    }

    private static class StartupParam {
        private final String key;
        private final String value;

        StartupParam(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public byte[] getEncodedKey() {
            return this.key.getBytes(StandardCharsets.UTF_8);
        }

        public byte[] getEncodedValue() {
            return this.value.getBytes(StandardCharsets.UTF_8);
        }
    }
}

