/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.visitors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.visitors.TraversalCheckingVisitor;

public class MethodCallingVisitor
extends TraversalCheckingVisitor
implements Serializable {
    private transient Method method;
    private final Object[] arguments;
    private final Class<?> type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;

    public MethodCallingVisitor(Method method, Class<?> ofType, Object[] arguments, boolean visitInInstantiationOrder) {
        if (method == null) {
            throw new NullPointerException();
        }
        this.method = method;
        this.arguments = arguments;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList();
    }

    public MethodCallingVisitor(Method method, Class ofType, Object[] arguments) {
        this(method, ofType, arguments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            for (Object componentInstance : this.componentInstances) {
                this.invoke(componentInstance);
            }
        }
        finally {
            this.componentInstances.clear();
        }
        return Void.TYPE;
    }

    @Override
    public boolean visitContainer(PicoContainer pico) {
        super.visitContainer(pico);
        this.componentInstances.addAll(pico.getComponents(this.type));
        return true;
    }

    protected Method getMethod() {
        return this.method;
    }

    protected Object[] getArguments() {
        return this.arguments;
    }

    protected void invoke(Object[] targets) {
        for (Object target : targets) {
            this.invoke(target);
        }
    }

    protected Class<Void> invoke(Object target) {
        Method method = this.getMethod();
        try {
            method.invoke(target, this.getArguments());
        }
        catch (IllegalArgumentException e2) {
            throw new PicoCompositionException("Can't call " + method.getName() + " on " + target, e2);
        }
        catch (IllegalAccessException e3) {
            throw new PicoCompositionException("Can't call " + method.getName() + " on " + target, e3);
        }
        catch (InvocationTargetException e4) {
            throw new PicoCompositionException("Failed when calling " + method.getName() + " on " + target, e4.getTargetException());
        }
        return Void.TYPE;
    }
}

