/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.security;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Map;

public class CustomPermissionsURLClassLoader
extends URLClassLoader {
    private final Map<URL, Permissions> permissionsMap;

    public CustomPermissionsURLClassLoader(URL[] urls, Map<URL, Permissions> permissionsMap, ClassLoader parent) {
        super(urls, parent);
        this.permissionsMap = permissionsMap;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e2) {
            throw this.decorateException(name, e2);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e2) {
            throw this.decorateException(name, e2);
        }
    }

    private ClassNotFoundException decorateException(String name, ClassNotFoundException e2) {
        if (name.startsWith("class ")) {
            return new ClassNotFoundException("Class '" + name + "' is not a classInstance.getName(). It's a classInstance.toString(). The clue is that it starts with 'class ', no classname contains a space.");
        }
        ClassLoader classLoader = this;
        StringBuffer sb = new StringBuffer("'").append(name).append("' classloader stack [");
        while (classLoader != null) {
            sb.append(((Object)classLoader).toString()).append("\n");
            final CustomPermissionsURLClassLoader cl = classLoader;
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return cl.getParent();
                }
            });
        }
        return new ClassNotFoundException(sb.append("]").toString(), e2);
    }

    public String toString() {
        URL[] urls;
        String result = CustomPermissionsURLClassLoader.class.getName() + " " + System.identityHashCode(this) + ":";
        for (URL url : urls = this.getURLs()) {
            result = result + "\n\t" + url.toString();
        }
        return result;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionsMap.get(codeSource.getLocation());
    }
}

