/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.paranamer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.picocontainer.paranamer.ParameterNamesNotFoundException;
import org.picocontainer.paranamer.Paranamer;

public class LegacyParanamer
implements Paranamer {
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    public static final String __PARANAMER_DATA = "v1.0 \nlookupParameterNames java.lang.AccessibleObject methodOrConstructor \nlookupParameterNames java.lang.AccessibleObject,boolean methodOrCtor,throwExceptionIfMissing \ngetParameterTypeName java.lang.Class cls\n";

    @Override
    public String[] lookupParameterNames(Executable methodOrConstructor) {
        return this.lookupParameterNames(methodOrConstructor, true);
    }

    @Override
    public String[] lookupParameterNames(Executable methodOrCtor, boolean throwExceptionIfMissing) {
        String name;
        Executable executable = methodOrCtor;
        Class<?>[] types = executable.getParameterTypes();
        Class<?> declaringClass = executable.getDeclaringClass();
        String string = name = executable instanceof Constructor ? "<init>" : executable.getName();
        if (types.length == 0) {
            return EMPTY_NAMES;
        }
        String parameterTypeNames = LegacyParanamer.getParameterTypeNamesCSV(types);
        String[] names = LegacyParanamer.getParameterNames(declaringClass, parameterTypeNames, name + SPACE);
        if (names == null) {
            if (throwExceptionIfMissing) {
                throw new ParameterNamesNotFoundException("No parameter names found for class '" + declaringClass + "', methodOrCtor " + name + " and parameter types " + parameterTypeNames);
            }
            return Paranamer.EMPTY_NAMES;
        }
        return names;
    }

    private static String[] getParameterNames(Class<?> declaringClass, String parameterTypes, String prefix) {
        String data = LegacyParanamer.getParameterListResource(declaringClass);
        String line = LegacyParanamer.findFirstMatchingLine(data, prefix + parameterTypes + SPACE);
        String[] parts = line.split(SPACE);
        if (parts.length == 3 && parts[1].equals(parameterTypes)) {
            String parameterNames = parts[2];
            return parameterNames.split(COMMA);
        }
        return Paranamer.EMPTY_NAMES;
    }

    static String getParameterTypeNamesCSV(Class<?>[] parameterTypes) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            sb.append(LegacyParanamer.getParameterTypeName(parameterTypes[i2]));
            if (i2 >= parameterTypes.length - 1) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private static String getParameterListResource(Class<?> declaringClass) {
        try {
            Field field = declaringClass.getDeclaredField("__PARANAMER_DATA");
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(String.class)) {
                return null;
            }
            return (String)field.get(null);
        }
        catch (NoSuchFieldException e2) {
            return null;
        }
        catch (IllegalAccessException e3) {
            return null;
        }
    }

    private static String findFirstMatchingLine(String data, String prefix) {
        int iy;
        if (data == null) {
            return "";
        }
        int ix = data.indexOf(prefix);
        if (ix >= 0 && (iy = data.indexOf("\n", ix)) > 0) {
            return data.substring(ix, iy);
        }
        return "";
    }

    private static String getParameterTypeName(Class<?> cls) {
        String parameterTypeNameName = cls.getName();
        parameterTypeNameName = parameterTypeNameName.replace("[J", "[Xlong").replace("[I", "[Xint").replace("[Z", "[Xboolean").replace("[S", "[Xshort").replace("[F", "[Xfloat").replace("[D", "[Xdouble").replace("[B", "[Xbyte").replace("[C", "[Xchar");
        int arrayNestingDepth = 0;
        int ix = parameterTypeNameName.indexOf("[");
        while (ix > -1) {
            ++arrayNestingDepth;
            parameterTypeNameName = parameterTypeNameName.replaceFirst("(\\[\\w)|(\\[)", "");
            ix = parameterTypeNameName.indexOf("[");
        }
        parameterTypeNameName = parameterTypeNameName.replaceFirst(";", "");
        for (int k2 = 0; k2 < arrayNestingDepth; ++k2) {
            parameterTypeNameName = parameterTypeNameName + "[]";
        }
        return parameterTypeNameName;
    }
}

