/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.paranamer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.paranamer.ParameterNamesNotFoundException;
import org.picocontainer.paranamer.Paranamer;

public class BytecodeReadingParanamer
implements Paranamer {
    private static final Map<String, String> primitives = new HashMap<String, String>(){
        {
            this.put("int", "I");
            this.put("boolean", "Z");
            this.put("byte", "B");
            this.put("char", "C");
            this.put("short", "S");
            this.put("float", "F");
            this.put("long", "J");
            this.put("double", "D");
        }
    };
    public static final String __PARANAMER_DATA = "lookupParameterNames java.lang.reflect.Executable methodOrConstructor \nlookupParameterNames java.lang.reflect.Executable,boolean methodOrCtor,throwExceptionIfMissing \n";

    @Override
    public String[] lookupParameterNames(Executable methodOrConstructor) {
        return this.lookupParameterNames(methodOrConstructor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] lookupParameterNames(Executable methodOrCtor, boolean throwExceptionIfMissing) {
        String name;
        Executable executable = methodOrCtor;
        Class[] types = executable.getParameterTypes();
        Class<?> declaringClass = executable.getDeclaringClass();
        String string = name = executable instanceof Constructor ? "<init>" : executable.getName();
        if (types.length == 0) {
            return EMPTY_NAMES;
        }
        InputStream byteCodeStream = this.getClassAsStream(declaringClass);
        if (byteCodeStream == null) {
            if (throwExceptionIfMissing) {
                throw new ParameterNamesNotFoundException("Unable to get class bytes");
            }
            return Paranamer.EMPTY_NAMES;
        }
        try {
            String[] parameterNamesForMethod;
            ClassReader reader = new ClassReader(byteCodeStream);
            TypeCollector visitor = new TypeCollector(name, types, throwExceptionIfMissing);
            reader.accept(visitor);
            String[] stringArray = parameterNamesForMethod = visitor.getParameterNamesForMethod();
            return stringArray;
        }
        catch (IOException e2) {
            if (throwExceptionIfMissing) {
                throw new ParameterNamesNotFoundException("IoException while reading class bytes", e2);
            }
            String[] stringArray = Paranamer.EMPTY_NAMES;
            return stringArray;
        }
        finally {
            try {
                byteCodeStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private InputStream getClassAsStream(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return this.getClassAsStream(classLoader, clazz.getName());
    }

    private InputStream getClassAsStream(ClassLoader classLoader, String className) {
        String name = className.replace('.', '/') + ".class";
        InputStream asStream = classLoader.getResourceAsStream(name);
        if (asStream == null) {
            asStream = BytecodeReadingParanamer.class.getResourceAsStream(name);
        }
        return asStream;
    }

    private static class Type {
        private static final int VOID = 0;
        private static final int BOOLEAN = 1;
        private static final int CHAR = 2;
        private static final int BYTE = 3;
        private static final int SHORT = 4;
        private static final int INT = 5;
        private static final int FLOAT = 6;
        private static final int LONG = 7;
        private static final int DOUBLE = 8;
        private static final int ARRAY = 9;
        private static final int OBJECT = 10;
        private static final Type VOID_TYPE = new Type(0, null, 0x56050000, 1);
        private static final Type BOOLEAN_TYPE = new Type(1, null, 1509950721, 1);
        private static final Type CHAR_TYPE = new Type(2, null, 1124075009, 1);
        private static final Type BYTE_TYPE = new Type(3, null, 1107297537, 1);
        private static final Type SHORT_TYPE = new Type(4, null, 1392510721, 1);
        private static final Type INT_TYPE = new Type(5, null, 1224736769, 1);
        private static final Type FLOAT_TYPE = new Type(6, null, 1174536705, 1);
        private static final Type LONG_TYPE = new Type(7, null, 1241579778, 1);
        private static final Type DOUBLE_TYPE = new Type(8, null, 1141048066, 1);
        private final int sort;
        private char[] buf;
        private int off;
        private final int len;
        public static final String __PARANAMER_DATA = "";

        private Type(int sort) {
            this.sort = sort;
            this.len = 1;
        }

        private Type(int sort, char[] buf, int off, int len) {
            this.sort = sort;
            this.buf = buf;
            this.off = off;
            this.len = len;
        }

        private static Type[] getArgumentTypes(String methodDescriptor) {
            char car;
            char[] buf = methodDescriptor.toCharArray();
            int off = 1;
            int size = 0;
            while ((car = buf[off++]) != ')') {
                if (car == 'L') {
                    while (buf[off++] != ';') {
                    }
                    ++size;
                    continue;
                }
                if (car == '[') continue;
                ++size;
            }
            Type[] args = new Type[size];
            off = 1;
            size = 0;
            while (buf[off] != ')') {
                args[size] = Type.getType(buf, off);
                off += args[size].len + (args[size].sort == 10 ? 2 : 0);
                ++size;
            }
            return args;
        }

        private static Type getType(char[] buf, int off) {
            switch (buf[off]) {
                case 'V': {
                    return VOID_TYPE;
                }
                case 'Z': {
                    return BOOLEAN_TYPE;
                }
                case 'C': {
                    return CHAR_TYPE;
                }
                case 'B': {
                    return BYTE_TYPE;
                }
                case 'S': {
                    return SHORT_TYPE;
                }
                case 'I': {
                    return INT_TYPE;
                }
                case 'F': {
                    return FLOAT_TYPE;
                }
                case 'J': {
                    return LONG_TYPE;
                }
                case 'D': {
                    return DOUBLE_TYPE;
                }
                case '[': {
                    int len = 1;
                    while (buf[off + len] == '[') {
                        ++len;
                    }
                    if (buf[off + len] == 'L') {
                        ++len;
                        while (buf[off + len] != ';') {
                            ++len;
                        }
                    }
                    return new Type(9, buf, off, len + 1);
                }
            }
            int len = 1;
            while (buf[off + len] != ';') {
                ++len;
            }
            return new Type(10, buf, off + 1, len - 1);
        }

        private int getDimensions() {
            int i2 = 1;
            while (this.buf[this.off + i2] == '[') {
                ++i2;
            }
            return i2;
        }

        private Type getElementType() {
            return Type.getType(this.buf, this.off + this.getDimensions());
        }

        private String getClassName() {
            switch (this.sort) {
                case 0: {
                    return "void";
                }
                case 1: {
                    return "boolean";
                }
                case 2: {
                    return "char";
                }
                case 3: {
                    return "byte";
                }
                case 4: {
                    return "short";
                }
                case 5: {
                    return "int";
                }
                case 6: {
                    return "float";
                }
                case 7: {
                    return "long";
                }
                case 8: {
                    return "double";
                }
                case 9: {
                    StringBuffer b2 = new StringBuffer(this.getElementType().getClassName());
                    for (int i2 = this.getDimensions(); i2 > 0; --i2) {
                        b2.append("[]");
                    }
                    return b2.toString();
                }
            }
            return new String(this.buf, this.off, this.len).replace('/', '.');
        }
    }

    private static class ClassReader {
        public final byte[] b;
        private final int[] items;
        private final String[] strings;
        private final int maxStringLength;
        public final int header;
        static final int FIELD = 9;
        static final int METH = 10;
        static final int IMETH = 11;
        static final int INT = 3;
        static final int FLOAT = 4;
        static final int LONG = 5;
        static final int DOUBLE = 6;
        static final int NAME_TYPE = 12;
        static final int MHANDLE = 15;
        static final int INVOKEDYN = 18;
        static final int UTF8 = 1;
        public static final String __PARANAMER_DATA = "";

        private ClassReader(byte[] b2) {
            this(b2, 0);
        }

        private ClassReader(byte[] b2, int off) {
            this.b = b2;
            this.items = new int[this.readUnsignedShort(off + 8)];
            int n2 = this.items.length;
            this.strings = new String[n2];
            int max = 0;
            int index = off + 10;
            for (int i2 = 1; i2 < n2; ++i2) {
                int size;
                this.items[i2] = index + 1;
                switch (b2[index]) {
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        size = 5;
                        break;
                    }
                    case 5: 
                    case 6: {
                        size = 9;
                        ++i2;
                        break;
                    }
                    case 15: {
                        size = 4;
                        break;
                    }
                    case 1: {
                        size = 3 + this.readUnsignedShort(index + 1);
                        if (size <= max) break;
                        max = size;
                        break;
                    }
                    default: {
                        size = 3;
                    }
                }
                index += size;
            }
            this.maxStringLength = max;
            this.header = index;
        }

        private ClassReader(InputStream is) throws IOException {
            this(ClassReader.readClass(is));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static byte[] readClass(InputStream is) throws IOException {
            if (is == null) {
                throw new IOException("Class not found");
            }
            try {
                byte[] b2 = new byte[is.available()];
                int len = 0;
                while (true) {
                    int n2;
                    if ((n2 = is.read(b2, len, b2.length - len)) == -1) {
                        byte[] c2;
                        if (len < b2.length) {
                            c2 = new byte[len];
                            System.arraycopy(b2, 0, c2, 0, len);
                            b2 = c2;
                        }
                        c2 = b2;
                        return c2;
                    }
                    if ((len += n2) != b2.length) continue;
                    int last = is.read();
                    if (last < 0) {
                        byte[] byArray = b2;
                        return byArray;
                    }
                    byte[] c3 = new byte[b2.length + 1000];
                    System.arraycopy(b2, 0, c3, 0, len);
                    c3[len++] = (byte)last;
                    b2 = c3;
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void accept(TypeCollector classVisitor) {
            int j2;
            int i2;
            char[] c2 = new char[this.maxStringLength];
            boolean anns = false;
            boolean ianns = false;
            int u2 = this.header;
            int v2 = this.items[this.readUnsignedShort(u2 + 4)];
            int len = this.readUnsignedShort(u2 + 6);
            boolean w2 = false;
            u2 += 8;
            for (i2 = 0; i2 < len; ++i2) {
                u2 += 2;
            }
            v2 = u2;
            i2 = this.readUnsignedShort(v2);
            v2 += 2;
            while (i2 > 0) {
                j2 = this.readUnsignedShort(v2 + 6);
                v2 += 8;
                while (j2 > 0) {
                    v2 += 6 + this.readInt(v2 + 2);
                    --j2;
                }
                --i2;
            }
            i2 = this.readUnsignedShort(v2);
            v2 += 2;
            while (i2 > 0) {
                j2 = this.readUnsignedShort(v2 + 6);
                v2 += 8;
                while (j2 > 0) {
                    v2 += 6 + this.readInt(v2 + 2);
                    --j2;
                }
                --i2;
            }
            i2 = this.readUnsignedShort(v2);
            v2 += 2;
            while (i2 > 0) {
                v2 += 6 + this.readInt(v2 + 2);
                --i2;
            }
            i2 = this.readUnsignedShort(u2);
            u2 += 2;
            while (i2 > 0) {
                j2 = this.readUnsignedShort(u2 + 6);
                u2 += 8;
                while (j2 > 0) {
                    u2 += 6 + this.readInt(u2 + 2);
                    --j2;
                }
                --i2;
            }
            i2 = this.readUnsignedShort(u2);
            u2 += 2;
            while (i2 > 0) {
                u2 = this.readMethod(classVisitor, c2, u2);
                --i2;
            }
        }

        private int readMethod(TypeCollector classVisitor, char[] c2, int u2) {
            String attrName;
            int access = this.readUnsignedShort(u2);
            String name = this.readUTF8(u2 + 2, c2);
            String desc = this.readUTF8(u2 + 4, c2);
            int v2 = 0;
            int w2 = 0;
            int j2 = this.readUnsignedShort(u2 + 6);
            u2 += 8;
            while (j2 > 0) {
                attrName = this.readUTF8(u2, c2);
                int attrSize = this.readInt(u2 + 2);
                u2 += 6;
                if (attrName.equals("Code")) {
                    v2 = u2;
                }
                u2 += attrSize;
                --j2;
            }
            if (w2 != 0) {
                w2 += 2;
                for (j2 = 0; j2 < this.readUnsignedShort(w2); ++j2) {
                    w2 += 2;
                }
            }
            MethodCollector mv = classVisitor.visitMethod(access, name, desc);
            if (mv != null && v2 != 0) {
                int codeEnd;
                int codeLength = this.readInt(v2 + 4);
                int codeStart = v2 += 8;
                v2 = codeEnd = v2 + codeLength;
                j2 = this.readUnsignedShort(v2);
                v2 += 2;
                while (j2 > 0) {
                    v2 += 8;
                    --j2;
                }
                int varTable = 0;
                int varTypeTable = 0;
                j2 = this.readUnsignedShort(v2);
                v2 += 2;
                while (j2 > 0) {
                    attrName = this.readUTF8(v2, c2);
                    if (attrName.equals("LocalVariableTable")) {
                        varTable = v2 + 6;
                    } else if (attrName.equals("LocalVariableTypeTable")) {
                        varTypeTable = v2 + 6;
                    }
                    v2 += 6 + this.readInt(v2 + 2);
                    --j2;
                }
                v2 = codeStart;
                if (varTable != 0) {
                    int k2;
                    if (varTypeTable != 0) {
                        k2 = this.readUnsignedShort(varTypeTable) * 3;
                        w2 = varTypeTable + 2;
                        int[] typeTable = new int[k2];
                        while (k2 > 0) {
                            typeTable[--k2] = w2 + 6;
                            typeTable[--k2] = this.readUnsignedShort(w2 + 8);
                            typeTable[--k2] = this.readUnsignedShort(w2);
                            w2 += 10;
                        }
                    }
                    w2 = varTable + 2;
                    for (k2 = this.readUnsignedShort(varTable); k2 > 0; --k2) {
                        int index = this.readUnsignedShort(w2 + 8);
                        mv.visitLocalVariable(this.readUTF8(w2 + 4, c2), index);
                        w2 += 10;
                    }
                }
            }
            return u2;
        }

        private int readUnsignedShort(int index) {
            byte[] b2 = this.b;
            return (b2[index] & 0xFF) << 8 | b2[index + 1] & 0xFF;
        }

        private int readInt(int index) {
            byte[] b2 = this.b;
            return (b2[index] & 0xFF) << 24 | (b2[index + 1] & 0xFF) << 16 | (b2[index + 2] & 0xFF) << 8 | b2[index + 3] & 0xFF;
        }

        private String readUTF8(int index, char[] buf) {
            int item = this.readUnsignedShort(index);
            String s2 = this.strings[item];
            if (s2 != null) {
                return s2;
            }
            index = this.items[item];
            this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
            return this.strings[item];
        }

        private String readUTF(int index, int utfLen, char[] buf) {
            int endIndex = index + utfLen;
            byte[] b2 = this.b;
            int strLen = 0;
            int st = 0;
            int cc = 0;
            while (index < endIndex) {
                int c2 = b2[index++];
                switch (st) {
                    case 0: {
                        if ((c2 &= 0xFF) < 128) {
                            buf[strLen++] = (char)c2;
                            break;
                        }
                        if (c2 < 224 && c2 > 191) {
                            cc = (char)(c2 & 0x1F);
                            st = 1;
                            break;
                        }
                        cc = (char)(c2 & 0xF);
                        st = 2;
                        break;
                    }
                    case 1: {
                        buf[strLen++] = (char)(cc << 6 | c2 & 0x3F);
                        st = 0;
                        break;
                    }
                    case 2: {
                        cc = (char)(cc << 6 | c2 & 0x3F);
                        st = 1;
                    }
                }
            }
            return new String(buf, 0, strLen);
        }
    }

    private static class MethodCollector {
        private final int paramCount;
        private final int ignoreCount;
        private int currentParameter;
        private final StringBuffer result;
        private boolean debugInfoPresent;
        public static final String __PARANAMER_DATA = "";

        private MethodCollector(int ignoreCount, int paramCount) {
            this.ignoreCount = ignoreCount;
            this.paramCount = paramCount;
            this.result = new StringBuffer();
            this.currentParameter = 0;
            this.debugInfoPresent = paramCount == 0;
        }

        private void visitLocalVariable(String name, int index) {
            if (index >= this.ignoreCount && index < this.ignoreCount + this.paramCount) {
                if (!name.equals("arg" + this.currentParameter)) {
                    this.debugInfoPresent = true;
                }
                this.result.append(',');
                this.result.append(name);
                ++this.currentParameter;
            }
        }

        private String getResult() {
            return this.result.length() != 0 ? this.result.substring(1) : __PARANAMER_DATA;
        }

        private boolean isDebugInfoPresent() {
            return this.debugInfoPresent;
        }
    }

    private static class TypeCollector {
        private static final String COMMA = ",";
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private final boolean throwExceptionIfMissing;
        private MethodCollector collector;
        public static final String __PARANAMER_DATA = "";

        private TypeCollector(String methodName, Class<?>[] parameterTypes, boolean throwExceptionIfMissing) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.throwExceptionIfMissing = throwExceptionIfMissing;
            this.collector = null;
        }

        private MethodCollector visitMethod(int access, String name, String desc) {
            if (this.collector != null) {
                return null;
            }
            if (!name.equals(this.methodName)) {
                return null;
            }
            Type[] argumentTypes = Type.getArgumentTypes(desc);
            int longOrDoubleQuantity = 0;
            for (Type t2 : argumentTypes) {
                if (!t2.getClassName().equals("long") && !t2.getClassName().equals("double")) continue;
                ++longOrDoubleQuantity;
            }
            int paramCount = argumentTypes.length;
            if (paramCount != this.parameterTypes.length) {
                return null;
            }
            for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                if (this.correctTypeName(argumentTypes, i2).equals(this.parameterTypes[i2].getName())) continue;
                return null;
            }
            this.collector = new MethodCollector(Modifier.isStatic(access) ? 0 : 1, argumentTypes.length + longOrDoubleQuantity);
            return this.collector;
        }

        private String correctTypeName(Type[] argumentTypes, int i2) {
            String s2 = argumentTypes[i2].getClassName();
            String braces = __PARANAMER_DATA;
            while (s2.endsWith("[]")) {
                braces = braces + "[";
                s2 = s2.substring(0, s2.length() - 2);
            }
            if (!braces.equals(__PARANAMER_DATA)) {
                s2 = primitives.containsKey(s2) ? braces + (String)primitives.get(s2) : braces + "L" + s2 + ";";
            }
            return s2;
        }

        private String[] getParameterNamesForMethod() {
            if (this.collector == null) {
                return Paranamer.EMPTY_NAMES;
            }
            if (!this.collector.isDebugInfoPresent()) {
                if (this.throwExceptionIfMissing) {
                    throw new ParameterNamesNotFoundException("Parameter names not found for " + this.methodName);
                }
                return Paranamer.EMPTY_NAMES;
            }
            return this.collector.getResult().split(COMMA);
        }
    }
}

