/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.injectors.SingleMemberInjector;

public abstract class MethodInjector<T>
extends SingleMemberInjector<T> {
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard instantiationGuard;
    private final String methodName;

    public MethodInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, String methodName, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
        this.methodName = methodName;
    }

    protected abstract Method getInjectorMethod();

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object instance) {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Object inst = null;
                    ComponentMonitor componentMonitor = MethodInjector.this.currentMonitor();
                    try {
                        componentMonitor.instantiating(container, MethodInjector.this, null);
                        long startTime = System.currentTimeMillis();
                        Object[] methodParameters = null;
                        inst = MethodInjector.this.getComponentImplementation().newInstance();
                        if (method != null) {
                            methodParameters = MethodInjector.this.getMemberArguments(this.guardedContainer, method);
                            MethodInjector.this.invokeMethod(method, methodParameters, inst, container);
                        }
                        componentMonitor.instantiated(container, MethodInjector.this, null, inst, methodParameters, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InstantiationException e2) {
                        return MethodInjector.this.caughtInstantiationException(componentMonitor, null, e2, container);
                    }
                    catch (IllegalAccessException e3) {
                        return MethodInjector.this.caughtIllegalAccessException(componentMonitor, method, inst, e3);
                    }
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation(), null);
    }

    protected Object[] getMemberArguments(PicoContainer container, Method method) {
        return super.getMemberArguments(container, method, method.getParameterTypes(), this.getBindings(method.getParameterAnnotations()));
    }

    @Override
    public Object decorateComponentInstance(final PicoContainer container, Type into, T instance) {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object inst) {
                    Method method = MethodInjector.this.getInjectorMethod();
                    if (method != null && method.getDeclaringClass().isAssignableFrom(inst.getClass())) {
                        Object[] methodParameters = MethodInjector.this.getMemberArguments(this.guardedContainer, method);
                        return MethodInjector.this.invokeMethod(method, methodParameters, inst, container);
                    }
                    return null;
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        Object o2 = this.instantiationGuard.observe(this.getComponentImplementation(), instance);
        return o2;
    }

    private Object invokeMethod(Method method, Object[] methodParameters, T instance, PicoContainer container) {
        try {
            Object rv = this.currentMonitor().invoking(container, this, method, instance, methodParameters);
            if (rv == ComponentMonitor.KEEP) {
                long str = System.currentTimeMillis();
                rv = method.invoke(instance, methodParameters);
                this.currentMonitor().invoked(container, this, method, instance, System.currentTimeMillis() - str, methodParameters, rv);
            }
            return rv;
        }
        catch (IllegalAccessException e2) {
            return this.caughtIllegalAccessException(this.currentMonitor(), method, instance, e2);
        }
        catch (InvocationTargetException e3) {
            this.currentMonitor().invocationFailed(method, instance, e3);
            if (e3.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e3.getTargetException();
            }
            if (e3.getTargetException() instanceof Error) {
                throw (Error)e3.getTargetException();
            }
            throw new PicoCompositionException(e3);
        }
    }

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object instance) {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Parameter[] currentParameters = MethodInjector.this.parameters != null ? MethodInjector.this.parameters : MethodInjector.this.createDefaultParameters(parameterTypes.length);
                    for (int i2 = 0; i2 < currentParameters.length; ++i2) {
                        currentParameters[i2].verify(container, MethodInjector.this, parameterTypes[i2], new ParameterNameBinding(MethodInjector.this.getParanamer(), method, i2), MethodInjector.this.useNames(), MethodInjector.this.getBindings(method.getParameterAnnotations())[i2]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation(), null);
    }

    @Override
    protected boolean isNullParamAllowed(AccessibleObject member, int i2) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ((Method)member).getParameterAnnotations()[i2]) {
            if (!(annotation instanceof Nullable)) continue;
            return true;
        }
        return false;
    }

    public static class ByMethodName
    extends MethodInjector {
        private Set<String> injectionMethodNames;

        public ByMethodName(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, Set<String> injectionMethodNames, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
            super(componentKey, componentImplementation, parameters, monitor, null, useNames);
            this.injectionMethodNames = injectionMethodNames;
        }

        @Override
        protected Method getInjectorMethod() {
            for (Method method : super.getComponentImplementation().getMethods()) {
                if (!this.injectionMethodNames.contains(method.getName())) continue;
                return method;
            }
            return null;
        }

        @Override
        public String getDescriptor() {
            return "MethodInjector.ByMethodName" + this.injectionMethodNames + "-";
        }
    }

    public static class ByReflectionMethod
    extends MethodInjector {
        private final Method injectionMethod;

        public ByReflectionMethod(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, Method injectionMethod, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
            super(componentKey, componentImplementation, parameters, monitor, null, useNames);
            this.injectionMethod = injectionMethod;
        }

        @Override
        protected Method getInjectorMethod() {
            return this.injectionMethod;
        }

        @Override
        public String getDescriptor() {
            return "MethodInjector.ByReflectionMethod[" + this.injectionMethod + "]-";
        }
    }
}

