/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.annotations.Bind;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.paranamer.AdaptiveParanamer;
import org.picocontainer.paranamer.AnnotationParanamer;
import org.picocontainer.paranamer.CachingParanamer;
import org.picocontainer.paranamer.Paranamer;

public abstract class IterativeInjector<T>
extends AbstractInjector<T> {
    private static final Object[] NONE = new Object[0];
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard instantiationGuard;
    protected transient List<AccessibleObject> injectionMembers;
    protected transient Type[] injectionTypes;
    protected transient Annotation[] bindings;
    private transient Paranamer paranamer;
    private volatile transient boolean initialized;

    public IterativeInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
    }

    protected Constructor getConstructor() {
        Object retVal = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return IterativeInjector.this.getComponentImplementation().getConstructor(null);
                }
                catch (NoSuchMethodException e2) {
                    return new PicoCompositionException(e2);
                }
                catch (SecurityException e3) {
                    return new PicoCompositionException(e3);
                }
            }
        });
        if (retVal instanceof Constructor) {
            return (Constructor)retVal;
        }
        throw (PicoCompositionException)retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Parameter[] getMatchingParameterListForSetters(PicoContainer container) throws PicoCompositionException {
        if (!this.initialized) {
            IterativeInjector iterativeInjector = this;
            synchronized (iterativeInjector) {
                if (!this.initialized) {
                    this.initializeInjectionMembersAndTypeLists();
                }
            }
        }
        ArrayList<Object> matchingParameterList = new ArrayList<Object>(Collections.nCopies(this.injectionMembers.size(), null));
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(this.injectionTypes.length);
        Set<Integer> nonMatchingParameterPositions = this.matchParameters(container, matchingParameterList, currentParameters);
        HashSet<Type> unsatisfiableDependencyTypes = new HashSet<Type>();
        ArrayList<AccessibleObject> unsatisfiableDependencyMembers = new ArrayList<AccessibleObject>();
        for (int i2 = 0; i2 < matchingParameterList.size(); ++i2) {
            if (matchingParameterList.get(i2) != null) continue;
            unsatisfiableDependencyTypes.add(this.injectionTypes[i2]);
            unsatisfiableDependencyMembers.add(this.injectionMembers.get(i2));
        }
        if (unsatisfiableDependencyTypes.size() > 0) {
            this.unsatisfiedDependencies(container, unsatisfiableDependencyTypes, unsatisfiableDependencyMembers);
        } else if (nonMatchingParameterPositions.size() > 0) {
            throw new PicoCompositionException("Following parameters do not match any of the injectionMembers for " + this.getComponentImplementation() + ": " + nonMatchingParameterPositions.toString());
        }
        return matchingParameterList.toArray(new Parameter[matchingParameterList.size()]);
    }

    private Set<Integer> matchParameters(PicoContainer container, List<Object> matchingParameterList, Parameter[] currentParameters) {
        HashSet<Integer> unmatchedParameters = new HashSet<Integer>();
        for (int i2 = 0; i2 < currentParameters.length; ++i2) {
            if (this.matchParameter(container, matchingParameterList, currentParameters[i2])) continue;
            unmatchedParameters.add(i2);
        }
        return unmatchedParameters;
    }

    private boolean matchParameter(PicoContainer container, List<Object> matchingParameterList, Parameter parameter) {
        for (int j2 = 0; j2 < this.injectionTypes.length; ++j2) {
            Object o2 = matchingParameterList.get(j2);
            try {
                if (o2 != null || !parameter.resolve(container, this, null, this.injectionTypes[j2], this.makeParameterNameImpl(this.injectionMembers.get(j2)), this.useNames(), this.bindings[j2]).isResolved()) continue;
                matchingParameterList.set(j2, parameter);
                return true;
            }
            catch (AbstractInjector.AmbiguousComponentResolutionException e2) {
                e2.setMember(this.injectionMembers.get(j2));
                throw e2;
            }
        }
        return false;
    }

    protected NameBinding makeParameterNameImpl(AccessibleObject member) {
        if (this.paranamer == null) {
            this.paranamer = new CachingParanamer(new AnnotationParanamer(new AdaptiveParanamer()));
        }
        return new ParameterNameBinding(this.paranamer, member, 0);
    }

    protected abstract void unsatisfiedDependencies(PicoContainer var1, Set<Type> var2, List<AccessibleObject> var3);

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        final Constructor constructor = this.getConstructor();
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object instance) {
                    Parameter[] matchingParameters = IterativeInjector.this.getMatchingParameterListForSetters(this.guardedContainer);
                    Object componentInstance = IterativeInjector.this.makeInstance(container, constructor, IterativeInjector.this.currentMonitor());
                    return IterativeInjector.this.decorateComponentInstance(matchingParameters, IterativeInjector.this.currentMonitor(), componentInstance, container, this.guardedContainer);
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation(), null);
    }

    private Object decorateComponentInstance(Parameter[] matchingParameters, ComponentMonitor componentMonitor, Object componentInstance, PicoContainer container, PicoContainer guardedContainer) {
        AccessibleObject member = null;
        Object[] injected = new Object[this.injectionMembers.size()];
        Object lastReturn = null;
        try {
            for (int i2 = 0; i2 < this.injectionMembers.size(); ++i2) {
                member = this.injectionMembers.get(i2);
                if (matchingParameters[i2] == null) continue;
                Object toInject = matchingParameters[i2].resolve(guardedContainer, this, null, this.injectionTypes[i2], this.makeParameterNameImpl(this.injectionMembers.get(i2)), this.useNames(), this.bindings[i2]).resolveInstance();
                Object rv = componentMonitor.invoking(container, this, (Member)((Object)member), componentInstance, new Object[]{toInject});
                if (rv == ComponentMonitor.KEEP) {
                    long str = System.currentTimeMillis();
                    lastReturn = this.injectIntoMember(member, componentInstance, toInject);
                    componentMonitor.invoked(container, this, (Member)((Object)member), componentInstance, System.currentTimeMillis() - str, new Object[]{toInject}, lastReturn);
                } else {
                    lastReturn = rv;
                }
                injected[i2] = toInject;
            }
            return this.memberInvocationReturn(lastReturn, member, componentInstance);
        }
        catch (InvocationTargetException e2) {
            return this.caughtInvocationTargetException(componentMonitor, (Member)((Object)member), componentInstance, e2);
        }
        catch (IllegalAccessException e3) {
            return this.caughtIllegalAccessException(componentMonitor, (Member)((Object)member), componentInstance, e3);
        }
    }

    protected abstract Object memberInvocationReturn(Object var1, AccessibleObject var2, Object var3);

    private Object makeInstance(PicoContainer container, Constructor constructor, ComponentMonitor componentMonitor) {
        Object componentInstance;
        long startTime = System.currentTimeMillis();
        Constructor constructorToUse = componentMonitor.instantiating(container, this, constructor);
        try {
            componentInstance = this.newInstance(constructorToUse, null);
        }
        catch (InvocationTargetException e2) {
            componentMonitor.instantiationFailed(container, this, constructorToUse, e2);
            if (e2.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e2.getTargetException();
            }
            if (e2.getTargetException() instanceof Error) {
                throw (Error)e2.getTargetException();
            }
            throw new PicoCompositionException(e2.getTargetException());
        }
        catch (InstantiationException e3) {
            return this.caughtInstantiationException(componentMonitor, constructor, e3, container);
        }
        catch (IllegalAccessException e4) {
            return this.caughtIllegalAccessException(componentMonitor, constructor, e4, container);
        }
        componentMonitor.instantiated(container, this, constructorToUse, componentInstance, NONE, System.currentTimeMillis() - startTime);
        return componentInstance;
    }

    @Override
    public Object decorateComponentInstance(final PicoContainer container, Type into, T instance) {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object inst) {
                    Parameter[] matchingParameters = IterativeInjector.this.getMatchingParameterListForSetters(this.guardedContainer);
                    return IterativeInjector.this.decorateComponentInstance(matchingParameters, IterativeInjector.this.currentMonitor(), inst, container, this.guardedContainer);
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation(), instance);
    }

    protected abstract Object injectIntoMember(AccessibleObject var1, Object var2, Object var3) throws IllegalAccessException, InvocationTargetException;

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object instance) {
                    Parameter[] currentParameters = IterativeInjector.this.getMatchingParameterListForSetters(this.guardedContainer);
                    for (int i2 = 0; i2 < currentParameters.length; ++i2) {
                        currentParameters[i2].verify(container, IterativeInjector.this, IterativeInjector.this.injectionTypes[i2], IterativeInjector.this.makeParameterNameImpl(IterativeInjector.this.injectionMembers.get(i2)), IterativeInjector.this.useNames(), IterativeInjector.this.bindings[i2]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation(), null);
    }

    protected void initializeInjectionMembersAndTypeLists() {
        Method[] methods;
        this.injectionMembers = new ArrayList<AccessibleObject>();
        HashSet<String> injectionMemberNames = new HashSet<String>();
        ArrayList<Annotation> bingingIds = new ArrayList<Annotation>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Method method : methods = this.getMethods()) {
            boolean isInjector;
            Type[] parameterTypes = method.getGenericParameterTypes();
            this.fixGenericParameterTypes(method, parameterTypes);
            String methodSignature = IterativeInjector.crudeMethodSignature(method);
            if (parameterTypes.length != 1 || !(isInjector = this.isInjectorMethod(method)) || injectionMemberNames.contains(methodSignature)) continue;
            this.injectionMembers.add(method);
            injectionMemberNames.add(methodSignature);
            nameList.add(this.getName(method));
            typeList.add(this.box(parameterTypes[0]));
            bingingIds.add(this.getBindings(method, 0));
        }
        this.injectionTypes = typeList.toArray(new Type[0]);
        this.bindings = bingingIds.toArray(new Annotation[0]);
        this.initialized = true;
    }

    public static String crudeMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName());
        sb.append(method.getName());
        for (Class<?> pType : method.getParameterTypes()) {
            sb.append(pType.getName());
        }
        return sb.toString();
    }

    protected String getName(Method method) {
        return null;
    }

    private void fixGenericParameterTypes(Method method, Type[] parameterTypes) {
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            Type parameterType = parameterTypes[i2];
            if (!(parameterType instanceof TypeVariable)) continue;
            parameterTypes[i2] = method.getParameterTypes()[i2];
        }
    }

    private Annotation getBindings(Method method, int i2) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length >= i2 + 1) {
            Annotation[] o2;
            for (Annotation annotation : o2 = parameterAnnotations[i2]) {
                if (annotation.annotationType().getAnnotation(Bind.class) == null) continue;
                return annotation;
            }
            return null;
        }
        if (parameterAnnotations != null) {
            // empty if block
        }
        return null;
    }

    protected boolean isInjectorMethod(Method method) {
        return false;
    }

    private Method[] getMethods() {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IterativeInjector.this.getComponentImplementation().getMethods();
            }
        });
    }
}

