/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.InjectionFactory;
import org.picocontainer.Injector;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.behaviors.AbstractBehaviorFactory;
import org.picocontainer.injectors.AbstractInjectionFactory;
import org.picocontainer.injectors.CompositeInjector;

public class CompositeInjection
extends AbstractInjectionFactory {
    private final InjectionFactory[] injectionFactories;

    public CompositeInjection(InjectionFactory ... injectionFactories) {
        this.injectionFactories = injectionFactories;
    }

    @Override
    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        Injector[] injectors = new Injector[this.injectionFactories.length];
        for (int i2 = 0; i2 < this.injectionFactories.length; ++i2) {
            InjectionFactory injectionFactory = this.injectionFactories[i2];
            ComponentAdapter<T> adapter = injectionFactory.createComponentAdapter(monitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
            injectors[i2] = (Injector)adapter;
        }
        boolean useNames = AbstractBehaviorFactory.arePropertiesPresent(componentProperties, Characteristics.USE_NAMES, true);
        return this.wrapLifeCycle(monitor.newInjector(new CompositeInjector(componentKey, componentImplementation, parameters, monitor, useNames, injectors)), lifecycleStrategy);
    }
}

