/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.parameters.ComponentParameter;

public abstract class AbstractInjector<T>
extends AbstractAdapter<T>
implements Injector<T> {
    protected transient ThreadLocalCyclicDependencyGuard verifyingGuard;
    protected transient Parameter[] parameters;
    private final boolean useNames;

    protected AbstractInjector(Object componentKey, Class<?> componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames) {
        super(componentKey, componentImplementation, monitor);
        this.useNames = useNames;
        this.checkConcrete();
        if (parameters != null) {
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                if (parameters[i2] != null) continue;
                throw new NullPointerException("Parameter " + i2 + " is null");
            }
        }
        this.parameters = parameters;
    }

    public boolean useNames() {
        return this.useNames;
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(int length) {
        Parameter[] componentParameters = new Parameter[length];
        for (int i2 = 0; i2 < length; ++i2) {
            componentParameters[i2] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public abstract T getComponentInstance(PicoContainer var1, Type var2) throws PicoCompositionException;

    @Override
    public Object decorateComponentInstance(PicoContainer container, Type into, T instance) {
        return null;
    }

    @Override
    public void accept(PicoVisitor visitor) {
        super.accept(visitor);
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                parameter.accept(visitor);
            }
        }
    }

    @Override
    public String getDescriptor() {
        return "Asbtract Injector";
    }

    protected T newInstance(Constructor<T> constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(parameters);
    }

    protected T caughtInstantiationException(ComponentMonitor componentMonitor, Constructor<T> constructor, InstantiationException e2, PicoContainer container) {
        componentMonitor.instantiationFailed(container, this, constructor, e2);
        throw new PicoCompositionException("Should never get here");
    }

    protected T caughtIllegalAccessException(ComponentMonitor componentMonitor, Constructor<T> constructor, IllegalAccessException e2, PicoContainer container) {
        componentMonitor.instantiationFailed(container, this, constructor, e2);
        throw new PicoCompositionException(e2);
    }

    protected T caughtInvocationTargetException(ComponentMonitor componentMonitor, Member member, Object componentInstance, InvocationTargetException e2) {
        componentMonitor.invocationFailed(member, componentInstance, e2);
        if (e2.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e2.getTargetException();
        }
        if (e2.getTargetException() instanceof Error) {
            throw (Error)e2.getTargetException();
        }
        throw new PicoCompositionException(e2.getTargetException());
    }

    protected Object caughtIllegalAccessException(ComponentMonitor componentMonitor, Member member, Object componentInstance, IllegalAccessException e2) {
        componentMonitor.invocationFailed(member, componentInstance, e2);
        throw new PicoCompositionException(e2);
    }

    protected Type box(Type parameterType) {
        if (parameterType instanceof Class && ((Class)parameterType).isPrimitive()) {
            String parameterTypeName = ((Class)parameterType).getName();
            if (parameterTypeName == "int") {
                return Integer.class;
            }
            if (parameterTypeName == "boolean") {
                return Boolean.class;
            }
            if (parameterTypeName == "long") {
                return Long.class;
            }
            if (parameterTypeName == "float") {
                return Float.class;
            }
            if (parameterTypeName == "double") {
                return Double.class;
            }
            if (parameterTypeName == "char") {
                return Character.class;
            }
            if (parameterTypeName == "byte") {
                return Byte.class;
            }
            if (parameterTypeName == "short") {
                return Short.class;
            }
        }
        return parameterType;
    }

    public static class NotConcreteRegistrationException
    extends PicoCompositionException {
        private final Class<?> componentImplementation;

        public NotConcreteRegistrationException(Class<?> componentImplementation) {
            super("Bad Access: '" + componentImplementation.getName() + "' is not instantiable");
            this.componentImplementation = componentImplementation;
        }

        public Class<?> getComponentImplementation() {
            return this.componentImplementation;
        }
    }

    public static class UnsatisfiableDependenciesException
    extends PicoCompositionException {
        public UnsatisfiableDependenciesException(String message) {
            super(message);
        }
    }

    public static final class AmbiguousComponentResolutionException
    extends PicoCompositionException {
        private String component;
        private final Class<?> ambiguousDependency;
        private final String[] ambiguousComponentKeys;
        private AccessibleObject accessibleObject;

        public AmbiguousComponentResolutionException(Class<?> ambiguousDependency, String[] componentKeys) {
            super("");
            this.ambiguousDependency = ambiguousDependency;
            this.ambiguousComponentKeys = componentKeys;
        }

        @Override
        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append(this.component != null ? this.component : "<no-component>");
            msg.append(" needs a '");
            msg.append(this.ambiguousDependency.getName());
            msg.append("' injected via '");
            msg.append(this.accessibleObject != null ? this.accessibleObject : "<unknown>");
            msg.append("', but there are too many choices to inject. These:");
            msg.append(Arrays.asList(this.getAmbiguousComponentKeys()));
            msg.append(", refer http://picocontainer.org/ambiguous-injectable-help.html");
            return msg.toString();
        }

        public String[] getAmbiguousComponentKeys() {
            return this.ambiguousComponentKeys;
        }

        public void setComponent(String component) {
            if (this.component == null) {
                this.component = component;
            }
        }

        public void setMember(AccessibleObject accessibleObject) {
            if (this.accessibleObject == null) {
                this.accessibleObject = accessibleObject;
            }
        }
    }

    public static class CyclicDependencyException
    extends PicoCompositionException {
        private final List<Class> stack = new LinkedList<Class>();

        public CyclicDependencyException(Class<?> element) {
            super((Throwable)null);
            this.push(element);
        }

        public void push(Class<?> element) {
            this.stack.add(element);
        }

        public Class[] getDependencies() {
            return this.stack.toArray(new Class[this.stack.size()]);
        }

        @Override
        public String getMessage() {
            return "Cyclic dependency: " + this.stack.toString();
        }
    }

    static abstract class ThreadLocalCyclicDependencyGuard<T>
    extends ThreadLocal<Boolean> {
        protected PicoContainer guardedContainer;

        ThreadLocalCyclicDependencyGuard() {
        }

        public abstract T run(Object var1);

        public final T observe(Class<?> stackFrame, Object instance) {
            if (Boolean.TRUE.equals(this.get())) {
                throw new CyclicDependencyException(stackFrame);
            }
            T result = null;
            try {
                this.set(Boolean.TRUE);
                result = this.run(instance);
            }
            catch (CyclicDependencyException e2) {
                e2.push(stackFrame);
                throw e2;
            }
            finally {
                this.set(null);
            }
            return result;
        }

        public void setGuardedContainer(PicoContainer container) {
            this.guardedContainer = container;
        }
    }
}

