/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.HiddenImplementation;

public class Intercepted<T>
extends HiddenImplementation {
    private final Map<Class, Object> pres = new HashMap<Class, Object>();
    private final Map<Class, Object> posts = new HashMap<Class, Object>();
    private Controller controller = new ControllerWrapper(new InterceptorThreadLocal());

    public Intercepted(ComponentAdapter delegate) {
        super(delegate);
    }

    public void addPreInvocation(Class type, Object interceptor) {
        this.pres.put(type, interceptor);
    }

    public void addPostInvocation(Class type, Object interceptor) {
        this.posts.put(type, interceptor);
    }

    @Override
    protected Object invokeMethod(Object componentInstance, Method method, Object[] args, PicoContainer container) throws Throwable {
        try {
            this.controller.clear();
            this.controller.instance(componentInstance);
            Object pre = this.pres.get(method.getDeclaringClass());
            if (pre != null) {
                Object rv = method.invoke(pre, args);
                if (this.controller.isVetoed()) {
                    return rv;
                }
            }
            Object result = method.invoke(componentInstance, args);
            this.controller.setOriginalRetVal(result);
            Object post = this.posts.get(method.getDeclaringClass());
            if (post != null) {
                Object rv = method.invoke(post, args);
                if (this.controller.isOverridden()) {
                    return rv;
                }
            }
            return result;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public String getDescriptor() {
        return "Intercepted";
    }

    public class ControllerWrapper
    implements Controller {
        private final ThreadLocal<Controller> threadLocal;

        public ControllerWrapper(ThreadLocal<Controller> threadLocal) {
            this.threadLocal = threadLocal;
        }

        @Override
        public void veto() {
            this.threadLocal.get().veto();
        }

        @Override
        public void clear() {
            this.threadLocal.get().clear();
        }

        @Override
        public boolean isVetoed() {
            return this.threadLocal.get().isVetoed();
        }

        @Override
        public void setOriginalRetVal(Object retVal) {
            this.threadLocal.get().setOriginalRetVal(retVal);
        }

        @Override
        public Object getOriginalRetVal() {
            return this.threadLocal.get().getOriginalRetVal();
        }

        @Override
        public boolean isOverridden() {
            return this.threadLocal.get().isOverridden();
        }

        @Override
        public void instance(Object instance) {
            this.threadLocal.get().instance(instance);
        }

        @Override
        public Object getInstance() {
            return this.threadLocal.get().getInstance();
        }

        @Override
        public void override() {
            this.threadLocal.get().override();
        }
    }

    public static class ControllerImpl
    implements Controller {
        private boolean vetoed;
        private Object retVal;
        private boolean overridden;
        private Object instance;

        @Override
        public void veto() {
            this.vetoed = true;
        }

        @Override
        public void clear() {
            this.vetoed = false;
            this.overridden = false;
            this.retVal = null;
            this.instance = null;
        }

        @Override
        public boolean isVetoed() {
            return this.vetoed;
        }

        @Override
        public void setOriginalRetVal(Object retVal) {
            this.retVal = retVal;
        }

        @Override
        public Object getOriginalRetVal() {
            return this.retVal;
        }

        @Override
        public boolean isOverridden() {
            return this.overridden;
        }

        @Override
        public void instance(Object instance) {
            this.instance = instance;
        }

        @Override
        public Object getInstance() {
            return this.instance;
        }

        @Override
        public void override() {
            this.overridden = true;
        }
    }

    public static interface Controller {
        public void veto();

        public void clear();

        public boolean isVetoed();

        public void setOriginalRetVal(Object var1);

        public boolean isOverridden();

        public void instance(Object var1);

        public Object getInstance();

        public Object getOriginalRetVal();

        public void override();
    }

    public static class InterceptorThreadLocal
    extends ThreadLocal
    implements Serializable {
        protected Object initialValue() {
            return new ControllerImpl();
        }
    }
}

