/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.type;

import java.util.Arrays;
import org.mariadb.jdbc.type.Geometry;
import org.mariadb.jdbc.type.LineString;
import org.mariadb.jdbc.type.Point;
import org.mariadb.jdbc.type.Polygon;

public class MultiPolygon
implements Geometry {
    private final Polygon[] polygons;

    public MultiPolygon(Polygon[] polygons) {
        this.polygons = polygons;
    }

    public Polygon[] getPolygons() {
        return this.polygons;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MULTIPOLYGON(");
        int indexpoly = 0;
        for (Polygon poly : this.polygons) {
            if (indexpoly++ > 0) {
                sb.append(",");
            }
            sb.append("(");
            int indexLine = 0;
            for (LineString ls : poly.getLines()) {
                if (indexLine++ > 0) {
                    sb.append(",");
                }
                sb.append("(");
                int index = 0;
                for (Point pt : ls.getPoints()) {
                    if (index++ > 0) {
                        sb.append(",");
                    }
                    sb.append(pt.getX()).append(" ").append(pt.getY());
                }
                sb.append(")");
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !(o2 instanceof MultiPolygon)) {
            return false;
        }
        return this.toString().equals(o2.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.polygons);
    }
}

