/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.type;

import java.util.Arrays;
import java.util.Objects;
import org.mariadb.jdbc.type.Geometry;
import org.mariadb.jdbc.type.Point;

public class LineString
implements Geometry {
    private final Point[] points;
    private final boolean open;

    public LineString(Point[] points, boolean open) {
        this.points = points;
        this.open = open;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LINESTRING(");
        int index = 0;
        for (Point pt : this.points) {
            if (index++ > 0) {
                sb.append(",");
            }
            sb.append(pt.getX()).append(" ").append(pt.getY());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !(o2 instanceof LineString)) {
            return false;
        }
        return this.open == ((LineString)o2).isOpen() && this.toString().equals(o2.toString());
    }

    public int hashCode() {
        int result = Objects.hash(this.open);
        result = 31 * result + Arrays.hashCode(this.points);
        return result;
    }
}

