/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.credential.aws;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.plugin.Credential;
import org.mariadb.jdbc.plugin.CredentialPlugin;
import org.mariadb.jdbc.plugin.credential.aws.AwsCredentialGenerator;

public class AwsIamCredentialPlugin
implements CredentialPlugin {
    private static final int TOKEN_TTL = 10;
    private static final Map<KeyCache, IdentityExpire> cache = new ConcurrentHashMap<KeyCache, IdentityExpire>();
    private AwsCredentialGenerator generator;
    private KeyCache key;

    @Override
    public String type() {
        return "AWS-IAM";
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) throws SQLException {
        try {
            Class.forName("software.amazon.awssdk.auth.credentials.AwsBasicCredentials");
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Identity plugin 'AWS-IAM' is used without having AWS SDK in classpath. Please add 'software.amazon.awssdk:rds' to classpath");
        }
        this.generator = new AwsCredentialGenerator(conf.nonMappedOptions(), conf.user(), hostAddress);
        this.key = new KeyCache(conf, conf.user(), hostAddress);
        return this;
    }

    @Override
    public Credential get() {
        IdentityExpire val = cache.get(this.key);
        if (val != null && val.isValid()) {
            return val.getCredential();
        }
        Credential credential = this.generator.getToken();
        cache.put(this.key, new IdentityExpire(credential));
        return credential;
    }

    private static class KeyCache {
        private final Configuration conf;
        private final String userName;
        private final HostAddress hostAddress;

        public KeyCache(Configuration conf, String userName, HostAddress hostAddress) {
            this.conf = conf;
            this.userName = userName;
            this.hostAddress = hostAddress;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            KeyCache keyCache = (KeyCache)o2;
            return this.conf.equals(keyCache.conf) && Objects.equals(this.userName, keyCache.userName) && this.hostAddress.equals(keyCache.hostAddress);
        }

        public int hashCode() {
            return Objects.hash(this.conf, this.userName, this.hostAddress);
        }
    }

    private static class IdentityExpire {
        private final LocalDateTime expiration;
        private final Credential credential;

        public IdentityExpire(Credential credential) {
            this.credential = credential;
            this.expiration = LocalDateTime.now().plusMinutes(10L);
        }

        public boolean isValid() {
            return this.expiration.isAfter(LocalDateTime.now());
        }

        public Credential getCredential() {
            return this.credential;
        }
    }
}

