/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.ZonedDateTimeCodec;

public class LocalDateTimeCodec
implements Codec<LocalDateTime> {
    public static final LocalDateTimeCodec INSTANCE = new LocalDateTimeCodec();
    public static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final DateTimeFormatter TIMESTAMP_FORMAT_NO_FRACTIONAL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MARIADB_LOCAL_DATE_TIME;
    private static final EnumSet<DataType> COMPATIBLE_TYPES;

    public static int[] parseTextTimestamp(ReadableByteBuf buf, MutableInt length) {
        int pos = buf.pos();
        int nanoBegin = -1;
        int[] parts = new int[7];
        int partIdx = 0;
        for (int begin = 0; begin < length.get(); ++begin) {
            byte b2 = buf.readByte();
            if (LocalDateTimeCodec.isDelimiter(b2)) {
                ++partIdx;
                if (b2 != 46) continue;
                nanoBegin = begin;
                continue;
            }
            if (!LocalDateTimeCodec.isDigit(b2)) {
                buf.pos(pos);
                throw new IllegalArgumentException("Invalid character in timestamp");
            }
            parts[partIdx] = parts[partIdx] * 10 + (b2 - 48);
        }
        if (nanoBegin > 0) {
            LocalDateTimeCodec.adjustNanoPrecision(parts, length.get() - nanoBegin - 1);
        }
        if (partIdx < 2) {
            buf.pos(pos);
            throw new IllegalArgumentException("Wrong timestamp format");
        }
        return parts;
    }

    private static boolean isDelimiter(byte b2) {
        return b2 == 45 || b2 == 32 || b2 == 58 || b2 == 46;
    }

    private static boolean isDigit(byte b2) {
        return b2 >= 48 && b2 <= 57;
    }

    private static void adjustNanoPrecision(int[] parts, int nanoLength) {
        for (int i2 = 0; i2 < 9 - nanoLength; ++i2) {
            parts[6] = parts[6] * 10;
        }
    }

    public static boolean isZeroTimestamp(int[] parts) {
        for (int part : parts) {
            if (part == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public String className() {
        return LocalDateTime.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(LocalDateTime.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalDateTime;
    }

    @Override
    public LocalDateTime decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        ZonedDateTime zdt = ZonedDateTimeCodec.INSTANCE.decodeText(buf, length, column, cal, context);
        if (zdt == null) {
            return null;
        }
        return zdt.toLocalDateTime();
    }

    @Override
    public LocalDateTime decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        ZonedDateTime zdt = ZonedDateTimeCodec.INSTANCE.decodeBinary(buf, length, column, cal, context);
        if (zdt == null) {
            return null;
        }
        return zdt.toLocalDateTime();
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        LocalDateTime val = (LocalDateTime)value;
        encoder.writeByte(39);
        encoder.writeAscii(val.format(val.getNano() != 0 ? TIMESTAMP_FORMAT : TIMESTAMP_FORMAT_NO_FRACTIONAL));
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        LocalDateTime val = (LocalDateTime)value;
        int nano = val.getNano();
        if (nano > 0) {
            encoder.writeByte(11);
            encoder.writeShort((short)val.getYear());
            encoder.writeByte(val.getMonthValue());
            encoder.writeByte(val.getDayOfMonth());
            encoder.writeByte(val.getHour());
            encoder.writeByte(val.getMinute());
            encoder.writeByte(val.getSecond());
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(7);
            encoder.writeShort((short)val.getYear());
            encoder.writeByte(val.getMonthValue());
            encoder.writeByte(val.getDayOfMonth());
            encoder.writeByte(val.getHour());
            encoder.writeByte(val.getMinute());
            encoder.writeByte(val.getSecond());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }

    static {
        COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.TIME, DataType.YEAR, DataType.DATE, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});
        MARIADB_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    }
}

