/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.standard.ed25519.math;

import java.io.Serializable;
import java.util.Arrays;
import org.mariadb.jdbc.plugin.authentication.standard.ed25519.Utils;
import org.mariadb.jdbc.plugin.authentication.standard.ed25519.math.Curve;
import org.mariadb.jdbc.plugin.authentication.standard.ed25519.math.FieldElement;

public class GroupElement
implements Serializable {
    private static final long serialVersionUID = 2395879087349587L;
    final Curve curve;
    final Representation repr;
    final FieldElement X;
    final FieldElement Y;
    final FieldElement Z;
    final FieldElement T;
    final GroupElement[][] precmp;
    final GroupElement[] dblPrecmp;

    public GroupElement(Curve curve, Representation repr, FieldElement X, FieldElement Y, FieldElement Z, FieldElement T) {
        this(curve, repr, X, Y, Z, T, false);
    }

    public GroupElement(Curve curve, Representation repr, FieldElement X, FieldElement Y, FieldElement Z, FieldElement T, boolean precomputeDouble) {
        this.curve = curve;
        this.repr = repr;
        this.X = X;
        this.Y = Y;
        this.Z = Z;
        this.T = T;
        this.precmp = null;
        this.dblPrecmp = precomputeDouble ? this.precomputeDouble() : null;
    }

    public GroupElement(Curve curve, byte[] s2) {
        this(curve, s2, false);
    }

    public GroupElement(Curve curve, byte[] s2, boolean precomputeSingleAndDouble) {
        FieldElement y2 = curve.getField().fromByteArray(s2);
        FieldElement yy = y2.square();
        FieldElement u2 = yy.subtractOne();
        FieldElement v2 = yy.multiply(curve.getD()).addOne();
        FieldElement v3 = v2.square().multiply(v2);
        FieldElement x2 = v3.square().multiply(v2).multiply(u2);
        x2 = x2.pow22523();
        x2 = v3.multiply(u2).multiply(x2);
        FieldElement vxx = x2.square().multiply(v2);
        FieldElement check = vxx.subtract(u2);
        if (check.isNonZero()) {
            check = vxx.add(u2);
            if (check.isNonZero()) {
                throw new IllegalArgumentException("not a valid GroupElement");
            }
            x2 = x2.multiply(curve.getI());
        }
        if ((x2.isNegative() ? 1 : 0) != Utils.bit(s2, curve.getField().getb() - 1)) {
            x2 = x2.negate();
        }
        this.curve = curve;
        this.repr = Representation.P3;
        this.X = x2;
        this.Y = y2;
        this.Z = curve.getField().ONE;
        this.T = this.X.multiply(this.Y);
        if (precomputeSingleAndDouble) {
            this.precmp = this.precomputeSingle();
            this.dblPrecmp = this.precomputeDouble();
        } else {
            this.precmp = null;
            this.dblPrecmp = null;
        }
    }

    public static GroupElement p2(Curve curve, FieldElement X, FieldElement Y, FieldElement Z) {
        return new GroupElement(curve, Representation.P2, X, Y, Z, null);
    }

    public static GroupElement p3(Curve curve, FieldElement X, FieldElement Y, FieldElement Z, FieldElement T) {
        return GroupElement.p3(curve, X, Y, Z, T, false);
    }

    public static GroupElement p3(Curve curve, FieldElement X, FieldElement Y, FieldElement Z, FieldElement T, boolean precomputeDoubleOnly) {
        return new GroupElement(curve, Representation.P3, X, Y, Z, T, precomputeDoubleOnly);
    }

    public static GroupElement p1p1(Curve curve, FieldElement X, FieldElement Y, FieldElement Z, FieldElement T) {
        return new GroupElement(curve, Representation.P1P1, X, Y, Z, T);
    }

    public static GroupElement precomp(Curve curve, FieldElement ypx, FieldElement ymx, FieldElement xy2d) {
        return new GroupElement(curve, Representation.PRECOMP, ypx, ymx, xy2d, null);
    }

    public static GroupElement cached(Curve curve, FieldElement YpX, FieldElement YmX, FieldElement Z, FieldElement T2d) {
        return new GroupElement(curve, Representation.CACHED, YpX, YmX, Z, T2d);
    }

    static byte[] toRadix16(byte[] a2) {
        int i2;
        byte[] e2 = new byte[64];
        for (i2 = 0; i2 < 32; ++i2) {
            e2[2 * i2] = (byte)(a2[i2] & 0xF);
            e2[2 * i2 + 1] = (byte)(a2[i2] >> 4 & 0xF);
        }
        int carry = 0;
        i2 = 0;
        while (i2 < 63) {
            int n2 = i2;
            e2[n2] = (byte)(e2[n2] + (byte)carry);
            carry = e2[i2] + 8;
            int n3 = i2++;
            e2[n3] = (byte)(e2[n3] - (byte)((carry >>= 4) << 4));
        }
        e2[63] = (byte)(e2[63] + (byte)carry);
        return e2;
    }

    static byte[] slide(byte[] a2) {
        int i2;
        byte[] r2 = new byte[256];
        for (i2 = 0; i2 < 256; ++i2) {
            r2[i2] = (byte)(1 & a2[i2 >> 3] >> (i2 & 7));
        }
        block1: for (i2 = 0; i2 < 256; ++i2) {
            if (r2[i2] == 0) continue;
            block2: for (int b2 = 1; b2 <= 6 && i2 + b2 < 256; ++b2) {
                if (r2[i2 + b2] == 0) continue;
                if (r2[i2] + (r2[i2 + b2] << b2) <= 15) {
                    int n2 = i2;
                    r2[n2] = (byte)(r2[n2] + (byte)(r2[i2 + b2] << b2));
                    r2[i2 + b2] = 0;
                    continue;
                }
                if (r2[i2] - (r2[i2 + b2] << b2) < -15) continue block1;
                int n3 = i2;
                r2[n3] = (byte)(r2[n3] - (byte)(r2[i2 + b2] << b2));
                for (int k2 = i2 + b2; k2 < 256; ++k2) {
                    if (r2[k2] == 0) {
                        r2[k2] = 1;
                        continue block2;
                    }
                    r2[k2] = 0;
                }
            }
        }
        return r2;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Representation getRepresentation() {
        return this.repr;
    }

    public FieldElement getX() {
        return this.X;
    }

    public FieldElement getY() {
        return this.Y;
    }

    public FieldElement getZ() {
        return this.Z;
    }

    public FieldElement getT() {
        return this.T;
    }

    public byte[] toByteArray() {
        switch (this.repr.ordinal()) {
            case 0: 
            case 1: {
                FieldElement recip = this.Z.invert();
                FieldElement x2 = this.X.multiply(recip);
                FieldElement y2 = this.Y.multiply(recip);
                byte[] s2 = y2.toByteArray();
                int n2 = s2.length - 1;
                s2[n2] = (byte)(s2[n2] | (x2.isNegative() ? -128 : 0));
                return s2;
            }
        }
        return this.toP2().toByteArray();
    }

    public GroupElement toP2() {
        return this.toRep(Representation.P2);
    }

    public GroupElement toP3() {
        return this.toRep(Representation.P3);
    }

    public GroupElement toP3PrecomputeDouble() {
        return this.toRep(Representation.P3PrecomputedDouble);
    }

    public GroupElement toCached() {
        return this.toRep(Representation.CACHED);
    }

    private GroupElement toRep(Representation repr) {
        switch (this.repr.ordinal()) {
            case 0: {
                switch (repr.ordinal()) {
                    case 0: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                switch (repr.ordinal()) {
                    case 0: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                    case 1: {
                        return GroupElement.p3(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                    case 5: {
                        return GroupElement.cached(this.curve, this.Y.add(this.X), this.Y.subtract(this.X), this.Z, this.T.multiply(this.curve.get2D()));
                    }
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                switch (repr.ordinal()) {
                    case 0: {
                        return GroupElement.p2(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T));
                    }
                    case 1: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y), false);
                    }
                    case 2: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y), true);
                    }
                    case 3: {
                        return GroupElement.p1p1(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
            case 4: {
                switch (repr.ordinal()) {
                    case 4: {
                        return GroupElement.precomp(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case 5: {
                switch (repr.ordinal()) {
                    case 5: {
                        return GroupElement.cached(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement[][] precomputeSingle() {
        GroupElement[][] precmp = new GroupElement[32][8];
        GroupElement Bi = this;
        for (int i2 = 0; i2 < 32; ++i2) {
            GroupElement Bij = Bi;
            for (int j2 = 0; j2 < 8; ++j2) {
                FieldElement recip = Bij.Z.invert();
                FieldElement x2 = Bij.X.multiply(recip);
                FieldElement y2 = Bij.Y.multiply(recip);
                precmp[i2][j2] = GroupElement.precomp(this.curve, y2.add(x2), y2.subtract(x2), x2.multiply(y2).multiply(this.curve.get2D()));
                Bij = Bij.add(Bi.toCached()).toP3();
            }
            for (int k2 = 0; k2 < 8; ++k2) {
                Bi = Bi.add(Bi.toCached()).toP3();
            }
        }
        return precmp;
    }

    private GroupElement[] precomputeDouble() {
        GroupElement[] dblPrecmp = new GroupElement[8];
        GroupElement Bi = this;
        for (int i2 = 0; i2 < 8; ++i2) {
            FieldElement recip = Bi.Z.invert();
            FieldElement x2 = Bi.X.multiply(recip);
            FieldElement y2 = Bi.Y.multiply(recip);
            dblPrecmp[i2] = GroupElement.precomp(this.curve, y2.add(x2), y2.subtract(x2), x2.multiply(y2).multiply(this.curve.get2D()));
            Bi = this.add(this.add(Bi.toCached()).toP3().toCached()).toP3();
        }
        return dblPrecmp;
    }

    public GroupElement dbl() {
        switch (this.repr.ordinal()) {
            case 0: 
            case 1: {
                FieldElement XX = this.X.square();
                FieldElement YY = this.Y.square();
                FieldElement B = this.Z.squareAndDouble();
                FieldElement A = this.X.add(this.Y);
                FieldElement AA = A.square();
                FieldElement Yn = YY.add(XX);
                FieldElement Zn = YY.subtract(XX);
                return GroupElement.p1p1(this.curve, AA.subtract(Yn), Yn, Zn, B.subtract(Zn));
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement madd(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A = YpX.multiply(q2.X);
        FieldElement B = YmX.multiply(q2.Y);
        FieldElement C = q2.Z.multiply(this.T);
        FieldElement D = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, A.subtract(B), A.add(B), D.add(C), D.subtract(C));
    }

    private GroupElement msub(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A = YpX.multiply(q2.Y);
        FieldElement B = YmX.multiply(q2.X);
        FieldElement C = q2.Z.multiply(this.T);
        FieldElement D = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, A.subtract(B), A.add(B), D.subtract(C), D.add(C));
    }

    public GroupElement add(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A = YpX.multiply(q2.X);
        FieldElement B = YmX.multiply(q2.Y);
        FieldElement C = q2.T.multiply(this.T);
        FieldElement ZZ = this.Z.multiply(q2.Z);
        FieldElement D = ZZ.add(ZZ);
        return GroupElement.p1p1(this.curve, A.subtract(B), A.add(B), D.add(C), D.subtract(C));
    }

    public GroupElement sub(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A = YpX.multiply(q2.Y);
        FieldElement B = YmX.multiply(q2.X);
        FieldElement C = q2.T.multiply(this.T);
        FieldElement ZZ = this.Z.multiply(q2.Z);
        FieldElement D = ZZ.add(ZZ);
        return GroupElement.p1p1(this.curve, A.subtract(B), A.add(B), D.subtract(C), D.add(C));
    }

    public GroupElement negate() {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        return this.curve.getZero(Representation.P3).sub(this.toCached()).toP3PrecomputeDouble();
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupElement)) {
            return false;
        }
        GroupElement ge = (GroupElement)obj;
        if (!this.repr.equals((Object)ge.repr)) {
            try {
                ge = ge.toRep(this.repr);
            }
            catch (RuntimeException e2) {
                return false;
            }
        }
        switch (this.repr.ordinal()) {
            case 0: 
            case 1: {
                if (this.Z.equals(ge.Z)) {
                    return this.X.equals(ge.X) && this.Y.equals(ge.Y);
                }
                FieldElement x1 = this.X.multiply(ge.Z);
                FieldElement y1 = this.Y.multiply(ge.Z);
                FieldElement x2 = ge.X.multiply(this.Z);
                FieldElement y2 = ge.Y.multiply(this.Z);
                return x1.equals(x2) && y1.equals(y2);
            }
            case 3: {
                return this.toP2().equals(ge);
            }
            case 4: {
                return this.X.equals(ge.X) && this.Y.equals(ge.Y) && this.Z.equals(ge.Z);
            }
            case 5: {
                if (this.Z.equals(ge.Z)) {
                    return this.X.equals(ge.X) && this.Y.equals(ge.Y) && this.T.equals(ge.T);
                }
                FieldElement x3 = this.X.multiply(ge.Z);
                FieldElement y3 = this.Y.multiply(ge.Z);
                FieldElement t3 = this.T.multiply(ge.Z);
                FieldElement x4 = ge.X.multiply(this.Z);
                FieldElement y4 = ge.Y.multiply(this.Z);
                FieldElement t4 = ge.T.multiply(this.Z);
                return x3.equals(x4) && y3.equals(y4) && t3.equals(t4);
            }
        }
        return false;
    }

    GroupElement cmov(GroupElement u2, int b2) {
        return GroupElement.precomp(this.curve, this.X.cmov(u2.X, b2), this.Y.cmov(u2.Y, b2), this.Z.cmov(u2.Z, b2));
    }

    GroupElement select(int pos, int b2) {
        int bnegative = Utils.negative(b2);
        int babs = b2 - ((-bnegative & b2) << 1);
        GroupElement t2 = this.curve.getZero(Representation.PRECOMP).cmov(this.precmp[pos][0], Utils.equal(babs, 1)).cmov(this.precmp[pos][1], Utils.equal(babs, 2)).cmov(this.precmp[pos][2], Utils.equal(babs, 3)).cmov(this.precmp[pos][3], Utils.equal(babs, 4)).cmov(this.precmp[pos][4], Utils.equal(babs, 5)).cmov(this.precmp[pos][5], Utils.equal(babs, 6)).cmov(this.precmp[pos][6], Utils.equal(babs, 7)).cmov(this.precmp[pos][7], Utils.equal(babs, 8));
        GroupElement tminus = GroupElement.precomp(this.curve, t2.Y, t2.X, t2.Z.negate());
        return t2.cmov(tminus, bnegative);
    }

    public GroupElement scalarMultiply(byte[] a2) {
        GroupElement t2;
        int i2;
        byte[] e2 = GroupElement.toRadix16(a2);
        GroupElement h2 = this.curve.getZero(Representation.P3);
        for (i2 = 1; i2 < 64; i2 += 2) {
            t2 = this.select(i2 / 2, e2[i2]);
            h2 = h2.madd(t2).toP3();
        }
        h2 = h2.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
        for (i2 = 0; i2 < 64; i2 += 2) {
            t2 = this.select(i2 / 2, e2[i2]);
            h2 = h2.madd(t2).toP3();
        }
        return h2;
    }

    public GroupElement doubleScalarMultiplyVariableTime(GroupElement A, byte[] a2, byte[] b2) {
        int i2;
        byte[] aslide = GroupElement.slide(a2);
        byte[] bslide = GroupElement.slide(b2);
        GroupElement r2 = this.curve.getZero(Representation.P2);
        for (i2 = 255; i2 >= 0 && aslide[i2] == 0 && bslide[i2] == 0; --i2) {
        }
        while (i2 >= 0) {
            GroupElement t2 = r2.dbl();
            if (aslide[i2] > 0) {
                t2 = t2.toP3().madd(A.dblPrecmp[aslide[i2] / 2]);
            } else if (aslide[i2] < 0) {
                t2 = t2.toP3().msub(A.dblPrecmp[-aslide[i2] / 2]);
            }
            if (bslide[i2] > 0) {
                t2 = t2.toP3().madd(this.dblPrecmp[bslide[i2] / 2]);
            } else if (bslide[i2] < 0) {
                t2 = t2.toP3().msub(this.dblPrecmp[-bslide[i2] / 2]);
            }
            r2 = t2.toP2();
            --i2;
        }
        return r2;
    }

    public boolean isOnCurve() {
        return this.isOnCurve(this.curve);
    }

    public boolean isOnCurve(Curve curve) {
        switch (this.repr.ordinal()) {
            case 0: 
            case 1: {
                FieldElement recip = this.Z.invert();
                FieldElement x2 = this.X.multiply(recip);
                FieldElement y2 = this.Y.multiply(recip);
                FieldElement xx = x2.square();
                FieldElement yy = y2.square();
                FieldElement dxxyy = curve.getD().multiply(xx).multiply(yy);
                return curve.getField().ONE.add(dxxyy).add(xx).equals(yy);
            }
        }
        return this.toP2().isOnCurve(curve);
    }

    public String toString() {
        return "[GroupElement\nX=" + this.X + "\nY=" + this.Y + "\nZ=" + this.Z + "\nT=" + this.T + "\n]";
    }

    public static enum Representation {
        P2,
        P3,
        P3PrecomputedDouble,
        P1P1,
        PRECOMP,
        CACHED;

    }
}

