/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.mariadb.jdbc.BaseCallableStatement;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.client.util.Parameter;

public class ProcedureStatement
extends BaseCallableStatement
implements CallableStatement {
    public ProcedureStatement(Connection con, String sql, String databaseName, String procedureName, ClosableLock lock, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(sql, con, lock, databaseName, procedureName, resultSetType, resultSetConcurrency, 0);
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    protected void handleParameterOutput() throws SQLException {
        for (int i2 = 1; i2 <= Math.min(this.results.size(), 2); ++i2) {
            Completion compl = (Completion)this.results.get(this.results.size() - i2);
            if (!(compl instanceof Result) || !((Result)compl).isOutputParameter()) continue;
            this.outputResultFromRes(i2);
        }
        this.currResult = (Completion)this.results.remove(0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ProcedureStatement{sql:'" + this.sql + "'");
        sb.append(", parameters:[");
        for (int i2 = 0; i2 < this.parameters.size(); ++i2) {
            Parameter param = this.parameters.get(i2);
            if (this.outputParameters.contains(i2 + 1)) {
                sb.append("<OUT>");
            }
            if (param == null) {
                sb.append("null");
            } else {
                sb.append(param.bestEffortStringValue(this.con.getContext()));
            }
            if (i2 == this.parameters.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }
}

