/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.MariaDbPoolConnection;
import org.mariadb.jdbc.MariaDbXid;
import org.mariadb.jdbc.client.util.ClosableLock;

public class MariaDbPoolPinnedConnection
extends MariaDbPoolConnection {
    private static final Map<Xid, Connection> xidToConnection = new HashMap<Xid, Connection>();
    private Xid currentXid;

    public MariaDbPoolPinnedConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.currentXid != null) {
            xidToConnection.remove(this.currentXid);
        }
    }

    @Override
    public XAResource getXAResource() {
        return new MariaDbXAPinnedResource();
    }

    private class MariaDbXAPinnedResource
    implements XAResource {
        private MariaDbXAPinnedResource() {
        }

        private void execute(Xid xid, String command, boolean removeMappingAfterExecution) throws XAException {
            block12: {
                if (xid == null) {
                    throw new XAException();
                }
                try {
                    if (xid.equals(MariaDbPoolPinnedConnection.this.currentXid)) {
                        MariaDbPoolPinnedConnection.this.getConnection().createStatement().execute(command);
                        break block12;
                    }
                    Connection con = (Connection)xidToConnection.get(xid);
                    if (con == null) {
                        con = MariaDbPoolPinnedConnection.this.getConnection();
                        xidToConnection.putIfAbsent(xid, con);
                        MariaDbPoolPinnedConnection.this.currentXid = xid;
                    }
                    try (ClosableLock ignore = con.getLock().closeableLock();){
                        con.createStatement().execute(command);
                        MariaDbPoolPinnedConnection.this.currentXid = null;
                        if (removeMappingAfterExecution) {
                            xidToConnection.remove(xid);
                        }
                    }
                }
                catch (SQLException sqle) {
                    throw MariaDbPoolConnection.mapXaException(sqle);
                }
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            this.execute(xid, "XA COMMIT " + MariaDbPoolConnection.xidToString(xid) + (onePhase ? " ONE PHASE" : ""), true);
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (flags != 0x4000000 && flags != 0x2000000 && flags != 0x20000000) {
                throw new XAException(-5);
            }
            this.execute(xid, "XA END " + MariaDbPoolConnection.xidToString(xid) + " " + MariaDbPoolConnection.flagsToString(flags), false);
        }

        @Override
        public void forget(Xid xid) {
            xidToConnection.remove(xid);
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        public Configuration getConf() {
            return MariaDbPoolPinnedConnection.this.getConnection().getContext().getConf();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            if (xaResource instanceof MariaDbXAPinnedResource) {
                MariaDbXAPinnedResource other = (MariaDbXAPinnedResource)xaResource;
                return other.getConf().equals(this.getConf());
            }
            return false;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            this.execute(xid, "XA PREPARE " + MariaDbPoolConnection.xidToString(xid), false);
            return 0;
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            if ((flags & 0x1000000) == 0 && (flags & 0x800000) == 0 && flags != 0) {
                throw new XAException(-5);
            }
            if ((flags & 0x1000000) == 0) {
                return new MariaDbXid[0];
            }
            try {
                ResultSet rs = MariaDbPoolPinnedConnection.this.getConnection().createStatement().executeQuery("XA RECOVER");
                ArrayList<MariaDbXid> xidList = new ArrayList<MariaDbXid>();
                while (rs.next()) {
                    int formatId = rs.getInt(1);
                    int len1 = rs.getInt(2);
                    int len2 = rs.getInt(3);
                    byte[] arr = rs.getBytes(4);
                    byte[] globalTransactionId = new byte[len1];
                    byte[] branchQualifier = new byte[len2];
                    System.arraycopy(arr, 0, globalTransactionId, 0, len1);
                    System.arraycopy(arr, len1, branchQualifier, 0, len2);
                    xidList.add(new MariaDbXid(formatId, globalTransactionId, branchQualifier));
                }
                Xid[] xids = new Xid[xidList.size()];
                xidList.toArray(xids);
                return xids;
            }
            catch (SQLException sqle) {
                throw MariaDbPoolConnection.mapXaException(sqle);
            }
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.execute(xid, "XA ROLLBACK " + MariaDbPoolConnection.xidToString(xid), true);
        }

        @Override
        public boolean setTransactionTimeout(int i2) {
            return false;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            switch (flags) {
                case 0x200000: 
                case 0x8000000: {
                    this.execute(xid, "XA START " + MariaDbPoolConnection.xidToString(xid) + " RESUME", false);
                    break;
                }
                case 0: {
                    this.execute(xid, "XA START " + MariaDbPoolConnection.xidToString(xid), false);
                    break;
                }
                default: {
                    throw new XAException(-5);
                }
            }
        }
    }
}

