/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Component;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class GridSwing
extends AbstractTableModel {
    JTable jtable = null;
    Object[] headers = new Object[0];
    ArrayList<Object[]> rows = new ArrayList();

    @Override
    public String getColumnName(int n2) {
        return this.headers[n2].toString();
    }

    public Class getColumnClass(int n2) {
        Object object;
        if (this.rows.size() > 0 && (object = this.getValueAt(0, n2)) != null) {
            if (object instanceof Timestamp || object instanceof Time) {
                return Object.class;
            }
            return object.getClass();
        }
        return super.getColumnClass(n2);
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public Object[] getHead() {
        return this.headers;
    }

    public ArrayList<Object[]> getData() {
        return this.rows;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (n2 >= this.rows.size()) {
            return null;
        }
        Object[] objectArray = this.rows.get(n2);
        if (n3 >= objectArray.length) {
            return null;
        }
        return objectArray[n3];
    }

    public void setHead(Object[] objectArray) {
        this.headers = Arrays.copyOf(objectArray, objectArray.length);
    }

    public void addRow(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = objectArray[i2];
        }
        this.rows.add(objectArray2);
    }

    public void clear() {
        this.rows.clear();
    }

    public void setJTable(JTable jTable) {
        this.jtable = jTable;
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
        GridSwing.autoSizeTableColumns(this.jtable);
    }

    public static void autoSizeTableColumns(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i2 = 0; i2 < jTable.getColumnCount(); ++i2) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i2);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            int n2 = component.getPreferredSize().width + 10;
            int n3 = Integer.MIN_VALUE;
            for (int i3 = 0; i3 < Math.min(tableModel.getRowCount(), 30); ++i3) {
                TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i3, i2);
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(i3, i2), false, false, i3, i2);
                int n4 = component.getPreferredSize().width;
                if (n4 < n3) continue;
                n3 = n4;
            }
            tableColumn.setPreferredWidth(Math.max(n2, n3) + 10);
        }
    }
}

