/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

public class TimeData {
    final int zone;
    final int seconds;
    final int nanos;

    public TimeData(int n2, int n3, int n4) {
        while (n2 < 0) {
            n2 += 86400;
        }
        if (n2 > 86400) {
            n2 %= 86400;
        }
        this.zone = n4;
        this.seconds = n2;
        this.nanos = n3;
    }

    public TimeData(int n2, int n3) {
        this(n2, n3, 0);
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getZone() {
        return this.zone;
    }

    public long getMillis() {
        return (long)this.seconds * 1000L;
    }

    public boolean equals(Object object) {
        if (object instanceof TimeData) {
            return this.seconds == ((TimeData)object).seconds && this.nanos == ((TimeData)object).nanos && this.zone == ((TimeData)object).zone;
        }
        return false;
    }

    public int hashCode() {
        return this.seconds ^ this.nanos;
    }

    public int compareTo(TimeData timeData) {
        long l2 = this.seconds - timeData.seconds;
        if (l2 == 0L && (l2 = (long)(this.nanos - timeData.nanos)) == 0L) {
            return 0;
        }
        return l2 > 0L ? 1 : -1;
    }
}

