/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.ResultSet;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.types.Type;
import org.hsqldb.types.TypedComparator;

public class RowType
extends Type {
    final Type[] dataTypes;
    TypedComparator comparator;

    public RowType(Type[] typeArray) {
        super(19, 19, 0L, 0);
        this.dataTypes = typeArray;
    }

    @Override
    public int displaySize() {
        return 0;
    }

    @Override
    public int getJDBCTypeCode() {
        return 0;
    }

    @Override
    public Class getJDBCClass() {
        return ResultSet.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.ResultSet";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 19;
    }

    @Override
    public boolean isRowType() {
        return true;
    }

    @Override
    public int getDegree() {
        return this.dataTypes.length;
    }

    @Override
    public String getNameString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ROW");
        stringBuilder.append('(');
        for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.dataTypes[i2].getDefinition());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getDefinition() {
        return this.getNameString();
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Object[] objectArray = (Object[])object2;
        Object[] objectArray2 = (Object[])object;
        int n2 = objectArray2.length;
        if (objectArray.length < n2) {
            n2 = objectArray.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.dataTypes[i2].compare(session, objectArray2[i2], objectArray[i2]);
            if (n3 == 0) continue;
            return n3;
        }
        if (objectArray2.length > objectArray.length) {
            return 1;
        }
        if (objectArray2.length < objectArray.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = this.dataTypes[i2].convertToTypeLimits(sessionInterface, objectArray[i2]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type == null) {
            return object;
        }
        if (!type.isRowType()) {
            throw Error.error(5562);
        }
        Type[] typeArray = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray.length) {
            throw Error.error(5564);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = this.dataTypes[i2].convertToType(sessionInterface, objectArray[i2], typeArray[i2]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        return object;
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return this.convertToSQLString(object);
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        Object[] objectArray = (Object[])object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ROW");
        stringBuilder.append('(');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            String string = this.dataTypes[i2].convertToSQLString(objectArray[i2]);
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void convertToJSON(Object object, StringBuilder stringBuilder) {
        Object[] objectArray = (Object[])object;
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            this.dataTypes[i2].convertToJSON(objectArray[i2], stringBuilder);
        }
        stringBuilder.append('}');
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isRowType()) {
            return false;
        }
        Type[] typeArray = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
            if (this.dataTypes[i2].canConvertFrom(typeArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeAssignedFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isRowType()) {
            return false;
        }
        Type[] typeArray = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
            if (this.dataTypes[i2].canBeAssignedFrom(typeArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (type == this) {
            return this;
        }
        if (!type.isRowType()) {
            throw Error.error(5562);
        }
        Type[] typeArray = new Type[this.dataTypes.length];
        Type[] typeArray2 = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray2.length) {
            throw Error.error(5564);
        }
        for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
            typeArray[i2] = this.dataTypes[i2].getAggregateType(typeArray2[i2]);
        }
        return new RowType(typeArray);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        if (n2 != 36) {
            return this.getAggregateType(type);
        }
        if (type == null) {
            return this;
        }
        if (!type.isRowType()) {
            throw Error.error(5562);
        }
        Type[] typeArray = new Type[this.dataTypes.length];
        Type[] typeArray2 = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray2.length) {
            throw Error.error(5564);
        }
        for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
            typeArray[i2] = this.dataTypes[i2].getAggregateType(typeArray2[i2]);
        }
        return new RowType(typeArray);
    }

    public Type[] getTypesArray() {
        return this.dataTypes;
    }

    @Override
    public int compare(Session session, Object object, Object object2, SortAndSlice sortAndSlice) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        int n2 = sortAndSlice.columnCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = sortAndSlice.sortOrder[i2];
            object = objectArray[n4];
            object2 = objectArray2[n4];
            if (object == object2) continue;
            if (sortAndSlice.sortNullsLast[i2]) {
                if (object == null) {
                    return 1;
                }
                if (object2 == null) {
                    return -1;
                }
            }
            if ((n3 = this.dataTypes[n4].compare(session, object, object2)) == 0) continue;
            if (sortAndSlice.sortDescending[i2]) {
                return -n3;
            }
            return n3;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RowType && super.equals(object)) {
            Type[] typeArray = ((RowType)object).dataTypes;
            if (typeArray.length != this.dataTypes.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
                if (this.dataTypes[i2].equals(typeArray[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n2 = 0;
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < this.dataTypes.length && i2 < 4; ++i2) {
            n2 += this.dataTypes[i2].hashCode(objectArray[i2]);
        }
        return n2;
    }

    synchronized TypedComparator getComparator(Session session) {
        if (this.comparator == null) {
            TypedComparator typedComparator = new TypedComparator(session);
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.prepareMultiColumn(this.dataTypes.length);
            typedComparator.setType(this, sortAndSlice);
            this.comparator = typedComparator;
        }
        return this.comparator;
    }

    public static String convertToSQLString(Object[] objectArray, Type[] typeArray, int n2) {
        if (objectArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            String string = typeArray[i2].convertToSQLString(objectArray[i2]);
            if (n2 > 10 && string.length() > n2) {
                stringBuilder.append(string, 0, n2 - 4);
                stringBuilder.append(" ...");
                continue;
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

