/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.TimeZone;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class DateTimeType
extends DTIType {
    public static final long epochSeconds = HsqlDateTime.getDateSeconds("1-01-01");
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);
    public static final long epochLimitSeconds = HsqlDateTime.getDateSeconds("10000-01-01");
    public static final TimestampData epochLimitTimestamp = new TimestampData(epochLimitSeconds);
    public static final TimeZone systemTimeZone = TimeZone.getDefault();
    public static final HashSet zoneIDs = new HashSet(TimeZone.getAvailableIDs());
    public final boolean withTimeZone;
    private final String nameString;

    public DateTimeType(int n2, int n3, int n4) {
        super(n2, n3, 0L, n4);
        this.withTimeZone = n3 == 94 || n3 == 95;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 94: {
                return 2013;
            }
            case 95: {
                return 2014;
            }
        }
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 94: {
                return OffsetTime.class;
            }
            case 95: {
                return OffsetDateTime.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 94: {
                return "java.time.OffsetTime";
            }
            case 95: {
                return "java.time.OffsetDateTime";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    @Override
    public boolean canCompareDirect(Type type) {
        return this.typeCode == type.typeCode;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String string;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                string = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                string = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(string);
        stringBuilder.append('(');
        stringBuilder.append(this.scale);
        stringBuilder.append(')');
        if (this.withTimeZone) {
            stringBuilder.append(" WITH TIME ZONE");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateOrTimestampType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return true;
            }
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimestampType() {
        switch (this.typeCode) {
            case 93: 
            case 95: {
                return true;
            }
            case 91: 
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimeType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return false;
            }
            case 92: 
            case 94: {
                return true;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type type) {
        int n2;
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? this : type;
        }
        if (type.typeCode == 0) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        if (!type.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType dateTimeType = (DateTimeType)type;
        if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
            throw Error.error(5562);
        }
        int n3 = this.typeCode;
        int n4 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
        boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
        int n5 = n2 = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
        n3 = n2 == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
        return DateTimeType.getDateTimeType(n3, n4);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        switch (n2) {
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int n3;
                if (this.typeCode == type.typeCode) {
                    return this;
                }
                if (type.typeCode == 0) {
                    return this;
                }
                if (!type.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType dateTimeType = (DateTimeType)type;
                if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
                    throw Error.error(5562);
                }
                int n4 = this.typeCode;
                int n5 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
                boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
                int n6 = n3 = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
                n4 = n3 == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
                return DateTimeType.getDateTimeType(n4, n5);
            }
            case 32: 
            case 33: {
                if (type.isIntervalType()) {
                    if (this.typeCode != 91 && type.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, type.scale);
                    }
                    return this;
                }
                if (type.isDateTimeType()) {
                    if (n2 != 33 || type.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                }
                if (!type.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2 = ((TimeData)object).seconds - ((TimeData)object2).seconds;
                if (l2 == 0L) {
                    l2 = ((TimeData)object).nanos - ((TimeData)object2).nanos;
                }
                return l2 == 0L ? 0 : (l2 > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long l3 = ((TimestampData)object).seconds - ((TimestampData)object2).seconds;
                if (l3 == 0L) {
                    l3 = ((TimestampData)object).nanos - ((TimestampData)object2).nanos;
                }
                return l3 == 0L ? 0 : (l3 > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return object;
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n2 = timeData.nanos;
                int n3 = this.scaleNanos(n2);
                if (n3 == n2) {
                    return timeData;
                }
                return new TimeData(timeData.seconds, n3, timeData.zone);
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                int n4 = timestampData.nanos;
                int n5 = this.scaleNanos(n4);
                if (timestampData.seconds > epochLimitSeconds) {
                    throw Error.error(3408);
                }
                if (n5 == n4) {
                    return timestampData;
                }
                return new TimestampData(timestampData.seconds, n5, timestampData.zone);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int n2) {
        int n3 = nanoScaleFactors[this.scale];
        return n2 / n3 * n3;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        switch (type.typeCode) {
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        try {
                            return sessionInterface.getScanner().convertToDatetimeInterval(sessionInterface, (String)object, this);
                        }
                        catch (HsqlException hsqlException) {
                            return DateTimeType.convertToDatetimeSpecial(sessionInterface, (String)object, this);
                        }
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (type.typeCode) {
                    case 91: {
                        return object;
                    }
                    case 95: {
                        long l2 = ((TimestampData)object).seconds + (long)((TimestampData)object).zone;
                        l2 = DateTimeType.toDateSeconds(l2);
                        return new TimestampData(l2);
                    }
                    case 93: {
                        long l3 = ((TimestampData)object).seconds;
                        l3 = DateTimeType.toDateSeconds(l3);
                        return new TimestampData(l3);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (type.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        int n2 = sessionInterface.getZoneSeconds();
                        return new TimeData(timeData.seconds - n2, this.scaleNanos(timeData.nanos), n2);
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        int n3 = DateTimeType.toTimeSeconds(timestampData.seconds);
                        return new TimeData(n3, this.scaleNanos(timestampData.nanos), timestampData.zone);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        int n4 = sessionInterface.getZoneSeconds();
                        int n5 = DateTimeType.toTimeSeconds(timestampData.seconds - (long)n4);
                        return new TimeData(n5, this.scaleNanos(timestampData.nanos), n4);
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        int n6 = DateTimeType.toTimeSeconds(timeData.seconds + timeData.zone);
                        return new TimeData(n6, this.scaleNanos(timeData.nanos));
                    }
                    case 92: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        int n7 = DateTimeType.toTimeSeconds(timestampData.seconds + (long)timestampData.zone);
                        return new TimeData(n7, this.scaleNanos(timestampData.nanos));
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        int n8 = DateTimeType.toTimeSeconds(timestampData.seconds);
                        return new TimeData(n8, this.scaleNanos(timestampData.nanos));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (type.typeCode) {
                    case 92: 
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        return this.convertTimeToTimestamp(sessionInterface.getCalendar(), timeData.seconds + timeData.zone, this.scaleNanos(timeData.nanos));
                    }
                    case 95: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 91: 
                    case 93: {
                        if (!(object instanceof TimestampData)) {
                            throw Error.error(5561);
                        }
                        TimestampData timestampData = (TimestampData)object;
                        Calendar calendar = sessionInterface.getCalendar();
                        long l4 = HsqlDateTime.convertSecondsFromCalendar(sessionInterface.getCalendarGMT(), calendar, timestampData.seconds);
                        int n9 = DateTimeType.getZoneSeconds(l4, calendar.getTimeZone());
                        return new TimestampData(l4, this.scaleNanos(timestampData.nanos), n9);
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (type.typeCode) {
                    case 92: 
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        return this.convertTimeToTimestamp(sessionInterface.getCalendar(), timeData.seconds + timeData.zone, this.scaleNanos(timeData.nanos));
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l5 = timestampData.seconds + (long)timestampData.zone;
                        return new TimestampData(l5, this.scaleNanos(timestampData.nanos));
                    }
                    case 93: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 91: {
                        return object;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        DateTimeType dateTimeType = object instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        return this.convertToType(sessionInterface, object, dateTimeType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        return this.convertJavaToSQL(sessionInterface, object, null);
    }

    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object, Calendar calendar) {
        if (object == null) {
            return null;
        }
        if (calendar == null) {
            calendar = sessionInterface.getCalendar();
        }
        long l2 = 0L;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object instanceof java.util.Date) {
            long l3 = ((java.util.Date)object).getTime();
            if (object instanceof Time) {
                bl2 = true;
                n2 = (int)(l3 % 1000L * 1000000L);
            } else if (object instanceof Date) {
                bl3 = true;
            } else if (object instanceof Timestamp) {
                n2 = ((Timestamp)object).getNanos();
                l3 -= (long)n2 / 1000000L;
            } else {
                n2 = (int)(l3 % 1000L * 1000000L);
            }
            l2 = l3 / 1000L;
            n3 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            DateTimeType.setDateComponents(calendar, localDate);
            l2 = calendar.getTimeInMillis() / 1000L;
            n3 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
            n2 = 0;
            bl3 = true;
        } else if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            l2 = offsetDateTime.toEpochSecond();
            n3 = offsetDateTime.get(ChronoField.OFFSET_SECONDS);
            n2 = offsetDateTime.getNano();
            bl = true;
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            l2 = zonedDateTime.toEpochSecond();
            n3 = zonedDateTime.get(ChronoField.OFFSET_SECONDS);
            n2 = zonedDateTime.getNano();
            bl = true;
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            DateTimeType.setDateTimeComponents(calendar, localDateTime);
            l2 = calendar.getTimeInMillis() / 1000L;
            n3 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
            n2 = localDateTime.getNano();
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            l2 = instant.getEpochSecond();
            n3 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
            n2 = instant.getNano();
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            l2 = offsetTime.toLocalTime().toSecondOfDay();
            n3 = offsetTime.get(ChronoField.OFFSET_SECONDS);
            l2 -= (long)n3;
            n2 = offsetTime.getNano();
            bl2 = true;
            bl = true;
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            l2 = localTime.toSecondOfDay();
            n3 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
            n2 = localTime.getNano();
            bl2 = true;
        } else {
            throw Error.error(5561);
        }
        if (!this.withTimeZone) {
            l2 += (long)n3;
            n3 = 0;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (bl3) {
                    throw Error.error(5561);
                }
                n2 = DateTimeType.normaliseFraction(n2, this.scale);
                return new TimeData((int)l2, n2, n3);
            }
            case 91: {
                if (bl2) {
                    throw Error.error(5561);
                }
                l2 = DateTimeType.toDateSeconds(l2);
                return new TimestampData(l2);
            }
            case 93: 
            case 95: {
                if (bl2) {
                    return this.convertTimeToTimestamp(calendar, l2 + (long)n3, n2);
                }
                n2 = DateTimeType.normaliseFraction(n2, this.scale);
                return new TimestampData(l2, n2, n3);
            }
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJavaGMT(SessionInterface sessionInterface, Object object) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2 = (long)((TimeData)object).seconds * 1000L;
                return new Time(l2 += (long)((TimeData)object).nanos / 1000000L);
            }
            case 91: {
                long l3 = ((TimestampData)object).seconds * 1000L;
                return new Date(l3);
            }
            case 93: 
            case 95: {
                long l4 = ((TimestampData)object).seconds * 1000L;
                Timestamp timestamp = new Timestamp(l4);
                timestamp.setNanos(((TimestampData)object).nanos);
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        Calendar calendar = sessionInterface.getCalendar();
        return this.convertSQLToJava(sessionInterface, object, null);
    }

    public Object convertSQLToJava(SessionInterface sessionInterface, Object object, Calendar calendar) {
        if (object == null) {
            return null;
        }
        if (calendar == null) {
            calendar = sessionInterface.getCalendar();
        }
        switch (this.typeCode) {
            case 92: {
                TimeData timeData = (TimeData)object;
                DateTimeType.setTimeComponents(calendar, timeData.seconds);
                long l2 = calendar.getTimeInMillis() + (long)timeData.nanos / 1000000L;
                return new Time(l2);
            }
            case 94: {
                TimeData timeData = (TimeData)object;
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timeData.zone);
                int n2 = DateTimeType.toTimeSeconds(timeData.seconds + timeData.zone);
                long l3 = (long)n2 * 1000000000L;
                LocalTime localTime = LocalTime.ofNanoOfDay(l3 + (long)timeData.nanos);
                return OffsetTime.of(localTime, zoneOffset);
            }
            case 91: {
                Calendar calendar2 = sessionInterface.getCalendarGMT();
                long l4 = ((TimestampData)object).getMillis();
                HsqlDateTime.convertMillisFromCalendar(calendar2, calendar, l4);
                HsqlDateTime.zeroFromPart(calendar, 103);
                l4 = calendar.getTimeInMillis();
                return new Date(l4);
            }
            case 93: {
                Calendar calendar3 = sessionInterface.getCalendarGMT();
                long l5 = ((TimestampData)object).getMillis();
                l5 = HsqlDateTime.convertMillisFromCalendar(calendar3, calendar, l5);
                Timestamp timestamp = new Timestamp(l5);
                timestamp.setNanos(((TimestampData)object).nanos);
                return timestamp;
            }
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timestampData.zone);
                LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(timestampData.seconds, timestampData.nanos, zoneOffset);
                return OffsetDateTime.of(localDateTime, zoneOffset);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object object) {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)object).seconds);
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n2 = DateTimeType.toTimeSeconds(timeData.seconds + timeData.zone);
                Object object2 = this.intervalSecondToString(n2, timeData.nanos, false);
                if (!this.withTimeZone) {
                    return object2;
                }
                object2 = (String)object2 + Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(timeData.zone, 0, true);
                return object2;
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                Object object3 = HsqlDateTime.getTimestampString(timestampData.seconds + (long)timestampData.zone, timestampData.nanos, this.scale);
                if (this.withTimeZone) {
                    String string = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(timestampData.zone, 0, true);
                    object3 = (String)object3 + string;
                }
                return object3;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        switch (this.typeCode) {
            case 91: {
                stringBuilder.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                stringBuilder.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                stringBuilder.append("TIMESTAMP");
            }
        }
        stringBuilder.append(StringConverter.toQuotedString(this.convertToString(object), '\'', false));
        return stringBuilder.toString();
    }

    @Override
    public void convertToJSON(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('\"');
        stringBuilder.append(this.convertToString(object));
        stringBuilder.append('\"');
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        if (!type.isDateTimeType()) {
            return false;
        }
        if (type.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (type.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, ((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)object, ((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, ((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, -((IntervalSecondData)object2).units, -((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)object, -((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, -((IntervalSecondData)object2).units, -((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static double convertToDouble(Object object) {
        double d2;
        double d3;
        if (object instanceof TimeData) {
            d3 = ((TimeData)object).seconds;
            d2 = (double)((TimeData)object).nanos / 1.0E9;
        } else {
            d3 = ((TimestampData)object).seconds;
            d2 = (double)((TimestampData)object).nanos / 1.0E9;
        }
        return d3 + d2;
    }

    public TimestampData convertFromDouble(Session session, double d2) {
        long l2 = (long)d2;
        int n2 = (int)((d2 - (double)l2) * 1.0E9);
        return this.getDateTimeValue(session, l2, n2);
    }

    public Object truncate(Session session, Object object, int n2) {
        if (object == null) {
            return null;
        }
        long l2 = this.getTotalMillis(object);
        Calendar calendar = session.getCalendarGMT();
        l2 = HsqlDateTime.getTruncatedPart(calendar, l2, n2);
        l2 -= this.getZoneMillis(object);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                l2 = HsqlDateTime.getNormalisedTime(calendar, l2);
                return new TimeData((int)(l2 / 1000L), 0, ((TimeData)object).zone);
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l2 / 1000L, 0, ((TimestampData)object).zone);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Session session, Object object, int n2) {
        if (object == null) {
            return null;
        }
        long l2 = this.getTotalMillis(object);
        Calendar calendar = session.getCalendarGMT();
        l2 = HsqlDateTime.getRoundedPart(calendar, l2, n2);
        l2 -= this.getZoneMillis(object);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                l2 = HsqlDateTime.getNormalisedTime(l2);
                return new TimeData((int)(l2 / 1000L), 0, ((TimeData)object).zone);
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l2 / 1000L, 0, ((TimestampData)object).zone);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DateTimeType) {
            return super.equals(object) && ((DateTimeType)object).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object object, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 1;
        switch (n2) {
            case 101: {
                n3 = 1;
                break;
            }
            case 102: {
                n4 = 1;
                n3 = 2;
                break;
            }
            case 103: 
            case 124: {
                n3 = 5;
                break;
            }
            case 104: {
                n3 = 11;
                break;
            }
            case 105: {
                n3 = 12;
                break;
            }
            case 106: {
                n3 = 13;
                break;
            }
            case 123: {
                n3 = 7;
                break;
            }
            case 126: 
            case 136: {
                n3 = 3;
                break;
            }
            case 130: {
                long l2 = this.getTotalSeconds(object);
                return DateTimeType.toTimeSeconds(l2);
            }
            case 121: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).zone / 3600;
                }
                return ((TimeData)object).zone / 3600;
            }
            case 122: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).zone / 60 % 60;
                }
                return ((TimeData)object).zone / 60 % 60;
            }
            case 135: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).zone / 60;
                }
                return ((TimeData)object).zone / 60;
            }
            case 127: {
                n4 = 1;
                n5 = 3;
                n3 = 2;
                break;
            }
            case 125: {
                n3 = 6;
                break;
            }
            case 132: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).nanos / 1000000;
                }
                return ((TimeData)object).nanos / 1000000;
            }
            case 133: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).nanos / 1000;
                }
                return ((TimeData)object).nanos / 1000;
            }
            case 134: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).nanos;
                }
                return ((TimeData)object).nanos;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + n2);
            }
        }
        long l3 = this.getTotalMillis(object);
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(l3);
        return calendar.get(n3) / n5 + n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(Calendar calendar, long l2, int n2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l2);
            return calendar.get(n2);
        }
    }

    public Object addMonthsSpecial(Session session, Object object, int n2) {
        TimestampData timestampData = (TimestampData)object;
        Calendar calendar = session.getCalendarGMT();
        long l2 = (timestampData.seconds + (long)timestampData.zone) * 1000L;
        HsqlDateTime.setTimeInMillis(calendar, l2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        boolean bl = l2 == calendar.getTimeInMillis();
        HsqlDateTime.setTimeInMillis(calendar, l2);
        calendar.add(2, n2);
        if (bl) {
            calendar.set(5, 1);
            calendar.add(2, 1);
            calendar.add(5, -1);
        }
        l2 = calendar.getTimeInMillis();
        return new TimestampData(l2 / 1000L, 0, 0);
    }

    public Object getLastDayOfMonth(Session session, Object object) {
        TimestampData timestampData = (TimestampData)object;
        Calendar calendar = session.getCalendarGMT();
        long l2 = (timestampData.seconds + (long)timestampData.zone) * 1000L;
        HsqlDateTime.setTimeInMillis(calendar, l2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        l2 = calendar.getTimeInMillis();
        return new TimestampData(l2 / 1000L, 0, 0);
    }

    long getTotalMillis(Object object) {
        return this.getTotalSeconds(object) * 1000L;
    }

    long getTotalSeconds(Object object) {
        if (this.typeCode == 92 || this.typeCode == 94) {
            TimeData timeData = (TimeData)object;
            return timeData.seconds + timeData.zone;
        }
        TimestampData timestampData = (TimestampData)object;
        return timestampData.seconds + (long)timestampData.zone;
    }

    long getZoneMillis(Object object) {
        long l2 = object instanceof TimeData ? (long)((TimeData)object).zone * 1000L : (long)((TimestampData)object).zone * 1000L;
        return l2;
    }

    @Override
    public BigDecimal getSecondPart(Session session, Object object) {
        long l2 = this.getPart(session, object, 106);
        int n2 = 0;
        if (this.typeCode == 93 || this.typeCode == 95) {
            n2 = ((TimestampData)object).nanos;
        } else if (this.typeCode == 92 || this.typeCode == 94) {
            n2 = ((TimeData)object).nanos;
        }
        return this.getSecondPart(l2, n2);
    }

    public String getPartString(Session session, Object object, int n2) {
        String string = "";
        switch (n2) {
            case 128: {
                string = "EEEE";
                break;
            }
            case 129: {
                string = "MMMM";
            }
        }
        SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
        try {
            simpleDateFormat.applyPattern(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, object);
        return simpleDateFormat.format(date);
    }

    TimestampData convertTimeToTimestamp(Calendar calendar, long l2, int n2) {
        calendar.setTimeInMillis(System.currentTimeMillis());
        DateTimeType.setTimeComponentsOnly(calendar, (int)l2);
        l2 = calendar.getTimeInMillis() / 1000L;
        int n3 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
        if (!this.withTimeZone) {
            l2 += (long)n3;
            n3 = 0;
        }
        return new TimestampData(l2, n3, n2);
    }

    public static TimestampData toLocalTimestampValue(TimestampData timestampData) {
        return new TimestampData(timestampData.seconds + (long)timestampData.zone, timestampData.nanos);
    }

    public static TimestampData toCurrentDateValue(TimestampData timestampData) {
        long l2 = DateTimeType.toDateSeconds(timestampData.seconds + (long)timestampData.zone);
        return new TimestampData(l2);
    }

    public static TimeData toCurrentTimeValue(TimestampData timestampData) {
        int n2 = DateTimeType.toTimeSeconds(timestampData.seconds + (long)timestampData.zone);
        return new TimeData(n2, timestampData.nanos);
    }

    public static TimeData toCurrentTimeWithZoneValue(TimestampData timestampData) {
        int n2 = DateTimeType.toTimeSeconds(timestampData.seconds);
        return new TimeData(n2, timestampData.nanos, timestampData.zone);
    }

    public TimestampData getDateTimeValue(SessionInterface sessionInterface, long l2, int n2) {
        n2 = DateTimeType.normaliseFraction(n2, this.scale);
        switch (this.typeCode) {
            case 91: {
                l2 = DateTimeType.toDateSeconds(l2);
                return new TimestampData(l2);
            }
            case 93: {
                return new TimestampData(l2, n2);
            }
            case 95: {
                return new TimestampData(l2, n2, sessionInterface.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static DateTimeType getDateTimeType(int n2, int n3) {
        if (n3 > 9) {
            throw Error.error(5592);
        }
        switch (n2) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (n3 == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, n2, n3);
            }
            case 94: {
                if (n3 == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, n2, n3);
            }
            case 93: {
                if (n3 == 6) {
                    return SQL_TIMESTAMP;
                }
                if (n3 == 0) {
                    return SQL_TIMESTAMP_NO_FRACTION;
                }
                return new DateTimeType(93, n2, n3);
            }
            case 95: {
                if (n3 == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(93, n2, n3);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object changeZoneToUTC(Object object) {
        if (object instanceof TimestampData) {
            TimestampData timestampData = (TimestampData)object;
            if (timestampData.zone != 0) {
                return new TimestampData(timestampData.seconds, timestampData.nanos);
            }
        } else {
            TimeData timeData = (TimeData)object;
            if (timeData.zone != 0) {
                return new TimeData(timeData.seconds, timeData.nanos);
            }
        }
        return object;
    }

    public Object changeZone(Session session, Object object, String string) {
        TimestampData timestampData = (TimestampData)object;
        long l2 = timestampData.seconds + (long)timestampData.zone;
        Calendar calendar = session.getCalendar();
        TimeZone timeZone = TimeZone.getTimeZone(string);
        TimeZone timeZone2 = calendar.getTimeZone();
        calendar.setTimeZone(timeZone);
        l2 = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, l2);
        int n2 = timeZone.getOffset(l2 * 1000L) / 1000;
        calendar.setTimeZone(timeZone2);
        return new TimestampData(l2, timestampData.nanos, n2);
    }

    public Object changeZone(Session session, Object object, Type type, String string) {
        TimestampData timestampData = (TimestampData)object;
        long l2 = timestampData.seconds;
        Calendar calendar = session.getCalendar();
        if (!zoneIDs.contains(string)) {
            throw Error.error(3409, string);
        }
        if (!type.isDateTimeTypeWithZone()) {
            l2 = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, l2);
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        int n2 = DateTimeType.getZoneSeconds(l2, timeZone);
        return new TimestampData(l2, timestampData.nanos, n2);
    }

    public Object changeZone(Session session, Object object, Type type, int n2, boolean bl) {
        if (object == null) {
            return null;
        }
        if (n2 > 64800 || -n2 > 64800) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData timeData = (TimeData)object;
                if (bl) {
                    n2 = session.getZoneSeconds();
                }
                if (type.isDateTimeTypeWithZone()) {
                    if (timeData.zone == n2) {
                        return timeData;
                    }
                    return new TimeData(timeData.seconds, timeData.nanos, n2);
                }
                int n3 = session.getZoneSeconds();
                int n4 = timeData.seconds - n3;
                n4 = DateTimeType.toTimeSeconds(n4);
                return new TimeData(n4, timeData.nanos, n2);
            }
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                long l2 = timestampData.seconds;
                Calendar calendar = session.getCalendar();
                if (!type.isDateTimeTypeWithZone()) {
                    l2 = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, l2);
                }
                if (bl) {
                    n2 = DateTimeType.getZoneSeconds(l2, calendar.getTimeZone());
                }
                if (timestampData.seconds == l2 && timestampData.zone == n2) {
                    return timestampData;
                }
                return new TimestampData(l2, timestampData.nanos, n2);
            }
        }
        return object;
    }

    public boolean canAdd(IntervalType intervalType) {
        return intervalType.startPartIndex >= this.startPartIndex && intervalType.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Type normalizeInput(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2, boolean bl) {
        Object object;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            return null;
        }
        if (!bl && objectArray2[1] == null) {
            return null;
        }
        if (!typeArray[0].isDateTimeType() || !typeArray2[0].isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType dateTimeType = SQL_TIMESTAMP_WITH_TIME_ZONE;
        objectArray[0] = dateTimeType.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = dateTimeType.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? ((Type)dateTimeType).add(session, objectArray[0], objectArray[1], typeArray[1]) : dateTimeType.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? ((Type)dateTimeType).add(session, objectArray2[0], objectArray2[1], typeArray2[1]) : (bl ? objectArray2[0] : dateTimeType.castToType(session, objectArray2[1], typeArray2[1]));
        if (((Type)dateTimeType).compare(session, objectArray[0], objectArray[1]) >= 0) {
            object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
        }
        if (!bl && ((Type)dateTimeType).compare(session, objectArray2[0], objectArray2[1]) >= 0) {
            object = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = object;
        }
        return dateTimeType;
    }

    public static Type normalizeInputRelaxed(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Object object;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            objectArray[1] = objectArray[0];
        }
        if (objectArray2[1] == null) {
            objectArray2[1] = objectArray2[0];
        }
        Type type = typeArray[0].getCombinedType(session, typeArray2[0], 40);
        objectArray[0] = type.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = type.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? type.add(session, objectArray[0], objectArray[1], typeArray[1]) : type.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? type.add(session, objectArray2[0], objectArray2[1], typeArray2[1]) : type.castToType(session, objectArray2[1], typeArray2[1]);
        if (type.compare(session, objectArray[0], objectArray[1]) > 0) {
            object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
        }
        if (type.compare(session, objectArray2[0], objectArray2[1]) > 0) {
            object = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = object;
        }
        return type;
    }

    public static Boolean overlaps(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean overlapsRelaxed(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInputRelaxed(session, objectArray, typeArray, objectArray2, typeArray2);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean precedes(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelyPrecedes(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelySucceeds(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean succeeds(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[1]) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean equals(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) == 0 && type.compare(session, objectArray[1], objectArray2[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean contains(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2, boolean bl) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, bl);
        if (type == null) {
            return null;
        }
        int n2 = type.compare(session, objectArray[0], objectArray2[0]);
        int n3 = type.compare(session, objectArray[1], objectArray2[1]);
        if (n2 <= 0 && n3 >= 0) {
            if (bl && n3 == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal subtractMonthsSpecial(Session session, TimestampData timestampData, TimestampData timestampData2) {
        long l2 = (timestampData.seconds + (long)timestampData.zone) * 1000L;
        long l3 = (timestampData2.seconds + (long)timestampData2.zone) * 1000L;
        boolean bl = false;
        if (l2 < l3) {
            bl = true;
            long l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        Calendar calendar = session.getCalendarGMT();
        l2 = HsqlDateTime.getNormalisedDate(calendar, l2);
        l3 = HsqlDateTime.getNormalisedDate(calendar, l3);
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(2) + calendar.get(1) * 12;
        int n3 = calendar.get(5);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n4 = calendar.get(5);
        calendar.setTimeInMillis(l3);
        int n5 = calendar.get(2) + calendar.get(1) * 12;
        int n6 = calendar.get(5);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n7 = calendar.get(5);
        if (n3 == n6 || n3 == n4 && n6 == n7) {
            double d2 = n2 - n5;
            if (bl) {
                d2 = -d2;
            }
            return BigDecimal.valueOf(d2);
        }
        if (n6 > n3) {
            double d3 = n2 - n5 - 1;
            double d4 = n7 - n6 + n3;
            d3 += d4 / 31.0;
            if (bl) {
                d3 = -d3;
            }
            return BigDecimal.valueOf(d3);
        }
        double d5 = n2 - n5;
        double d6 = n3 - n6;
        d5 += d6 / 31.0;
        if (bl) {
            d5 = -d5;
        }
        return BigDecimal.valueOf(d5);
    }

    public static int subtractMonths(Session session, TimestampData timestampData, TimestampData timestampData2, boolean bl) {
        Calendar calendar = session.getCalendarGMT();
        boolean bl2 = false;
        if (timestampData2.seconds > timestampData.seconds) {
            bl2 = true;
            TimestampData timestampData3 = timestampData;
            timestampData = timestampData2;
            timestampData2 = timestampData3;
        }
        calendar.setTimeInMillis(timestampData.seconds * 1000L);
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        calendar.setTimeInMillis(timestampData2.seconds * 1000L);
        n2 -= calendar.get(2);
        n3 -= calendar.get(1);
        if (bl) {
            n2 = n3 * 12;
        } else {
            if (n2 < 0) {
                n2 += 12;
                --n3;
            }
            n2 += n3 * 12;
        }
        if (bl2) {
            n2 = -n2;
        }
        return n2;
    }

    public static TimeData addSeconds(TimeData timeData, long l2, int n2) {
        l2 += (long)((n2 += timeData.nanos) / 1000000000);
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --l2;
        }
        l2 += (long)timeData.seconds;
        return new TimeData((int)(l2 %= 86400L), n2, timeData.zone);
    }

    public static TimestampData addMonths(Session session, TimestampData timestampData, int n2) {
        int n3 = timestampData.nanos;
        Calendar calendar = session.getCalendarGMT();
        HsqlDateTime.setTimeInMillis(calendar, timestampData.seconds * 1000L);
        calendar.add(2, n2);
        return new TimestampData(calendar.getTimeInMillis() / 1000L, n3, timestampData.zone);
    }

    public static TimestampData addSeconds(TimestampData timestampData, long l2, int n2) {
        l2 += (long)((n2 += timestampData.nanos) / 1000000000);
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --l2;
        }
        long l3 = timestampData.seconds + l2;
        return new TimestampData(l3, n2, timestampData.zone);
    }

    public static TimestampData convertToDatetimeSpecial(SessionInterface sessionInterface, String string, DateTimeType dateTimeType) {
        switch (dateTimeType.typeCode) {
            case 93: {
                String string2;
                if (!(sessionInterface instanceof Session) || !((Session)sessionInterface).database.sqlSyntaxOra) break;
                switch (string.length()) {
                    case 8: 
                    case 9: {
                        string2 = "DD-MON-YY";
                        break;
                    }
                    case 10: 
                    case 11: {
                        string2 = "DD-MON-YYYY";
                        break;
                    }
                    case 19: 
                    case 20: {
                        string2 = "DD-MON-YYYY HH24:MI:SS";
                        break;
                    }
                    default: {
                        string2 = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                }
                SimpleDateFormat simpleDateFormat = sessionInterface.getSimpleDateFormatGMT();
                return HsqlDateTime.toDate(string, string2, simpleDateFormat, true);
            }
        }
        throw Error.error(3407);
    }

    public static TimestampData nextDayOfWeek(Session session, TimestampData timestampData, int n2) {
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(timestampData.getMillis());
        int n3 = calendar.get(7);
        if (n3 >= n2) {
            n2 += 7;
        }
        int n4 = n2 - n3;
        calendar.add(5, n4);
        long l2 = calendar.getTimeInMillis();
        l2 = HsqlDateTime.getNormalisedDate(calendar, l2);
        return new TimestampData(l2 / 1000L);
    }

    public static int getDayOfWeek(String string) {
        if (string.length() > 0) {
            char c2 = Character.toUpperCase(string.charAt(0));
            switch (c2) {
                case 'M': {
                    return 2;
                }
                case 'T': {
                    if (string.length() < 2) break;
                    if (Character.toUpperCase(string.charAt(1)) == 'U') {
                        return 3;
                    }
                    if (Character.toUpperCase(string.charAt(1)) != 'H') break;
                    return 5;
                }
                case 'W': {
                    return 4;
                }
                case 'F': {
                    return 6;
                }
                case 'S': {
                    if (string.length() < 2) break;
                    if (Character.toUpperCase(string.charAt(1)) == 'A') {
                        return 7;
                    }
                    if (Character.toUpperCase(string.charAt(1)) != 'U') break;
                    return 1;
                }
            }
        }
        throw Error.error(3407, string);
    }

    public static int toTimeSeconds(long l2) {
        int n2 = (int)(l2 % 86400L);
        if (n2 < 0) {
            n2 += 86400;
        }
        return n2;
    }

    static long toDateSeconds(long l2) {
        long l3 = l2 % 86400L;
        if (l3 < 0L) {
            l3 += 86400L;
        }
        return l2 - l3;
    }

    public static TimestampData newSysDateTimestamp() {
        long l2 = System.currentTimeMillis();
        long l3 = l2 / 1000L;
        int n2 = systemTimeZone.getOffset(l2) / 1000;
        return new TimestampData(l3 + (long)n2);
    }

    public static TimestampData newSystemTimestampWithZone() {
        return DateTimeType.newCurrentTimestamp(systemTimeZone);
    }

    public static int getZoneSeconds(long l2, TimeZone timeZone) {
        return timeZone.getOffset(l2 * 1000L) / 1000;
    }

    static void setTimeComponents(Calendar calendar, int n2) {
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        DateTimeType.setTimeComponentsOnly(calendar, n2 %= 86400);
    }

    static void setTimeComponentsOnly(Calendar calendar, int n2) {
        n2 = DateTimeType.toTimeSeconds(n2);
        calendar.set(11, n2 / 3600);
        calendar.set(12, n2 % 3600 / 60);
        calendar.set(13, n2 % 60);
    }

    public static TimestampData newCurrentTimestamp(TimeZone timeZone) {
        Instant instant = Instant.now();
        long l2 = instant.getEpochSecond();
        int n2 = instant.getNano() / 1000 * 1000;
        int n3 = timeZone.getOffset(l2 * 1000L) / 1000;
        return new TimestampData(l2, n2, n3);
    }

    public static TimestampData newSystemTimestampUTC() {
        Instant instant = Instant.now();
        long l2 = instant.getEpochSecond();
        int n2 = instant.getNano() / 1000 * 1000;
        return new TimestampData(l2, n2);
    }

    public static void setDateTimeComponents(Calendar calendar, LocalDateTime localDateTime) {
        calendar.clear();
        calendar.set(1, localDateTime.getYear());
        calendar.set(2, localDateTime.getMonthValue() - 1);
        calendar.set(5, localDateTime.getDayOfMonth());
        calendar.set(11, localDateTime.getHour());
        calendar.set(12, localDateTime.getMinute());
        calendar.set(13, localDateTime.getSecond());
    }

    public static void setDateComponents(Calendar calendar, LocalDate localDate) {
        calendar.clear();
        calendar.set(1, localDate.getYear());
        calendar.set(2, localDate.getMonthValue() - 1);
        calendar.set(5, localDate.getDayOfMonth());
    }

    public static void setTimeComponents(Calendar calendar, LocalTime localTime) {
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, localTime.getHour());
        calendar.set(12, localTime.getMinute());
        calendar.set(13, localTime.getSecond());
    }

    public Instant toInstant(SessionInterface sessionInterface, TimestampData timestampData) {
        long l2 = this.withTimeZone ? timestampData.seconds : HsqlDateTime.convertSecondsFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), timestampData.seconds);
        return Instant.ofEpochSecond(l2, timestampData.nanos);
    }

    public LocalDate toLocalDate(SessionInterface sessionInterface, TimestampData timestampData) {
        long l2 = (timestampData.seconds + (long)timestampData.zone) * 1000L;
        Calendar calendar = sessionInterface.getCalendarGMT();
        calendar.setTimeInMillis(l2);
        return LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public LocalDateTime toLocalDateTime(SessionInterface sessionInterface, TimestampData timestampData) {
        long l2 = (timestampData.seconds + (long)timestampData.zone) * 1000L;
        int n2 = timestampData.nanos;
        Calendar calendar = sessionInterface.getCalendarGMT();
        calendar.setTimeInMillis(l2);
        return LocalDateTime.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), n2);
    }

    public LocalTime toLocalTime(SessionInterface sessionInterface, TimeData timeData) {
        int n2 = DateTimeType.toTimeSeconds(timeData.seconds + timeData.zone);
        return LocalTime.ofNanoOfDay((long)n2 * 1000000000L + (long)timeData.nanos);
    }

    public LocalTime toLocalTime(SessionInterface sessionInterface, TimestampData timestampData) {
        int n2 = DateTimeType.toTimeSeconds(timestampData.getSeconds() + (long)timestampData.zone);
        return LocalTime.ofNanoOfDay((long)n2 * 1000000000L + (long)timestampData.nanos);
    }

    public OffsetTime toOffsetTime(SessionInterface sessionInterface, TimeData timeData) {
        int n2 = this.withTimeZone ? timeData.zone : sessionInterface.getZoneSeconds();
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n2);
        LocalTime localTime = this.toLocalTime(sessionInterface, timeData);
        return OffsetTime.of(localTime, zoneOffset);
    }

    public OffsetTime toOffsetTime(SessionInterface sessionInterface, TimestampData timestampData) {
        int n2 = this.withTimeZone ? timestampData.zone : sessionInterface.getZoneSeconds();
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n2);
        LocalTime localTime = this.toLocalTime(sessionInterface, timestampData);
        return OffsetTime.of(localTime, zoneOffset);
    }

    public OffsetDateTime toOffsetDateTime(SessionInterface sessionInterface, TimestampData timestampData) {
        int n2;
        if (this.withTimeZone) {
            n2 = timestampData.zone;
        } else {
            long l2 = HsqlDateTime.convertSecondsFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), timestampData.seconds);
            n2 = DateTimeType.getZoneSeconds(l2, sessionInterface.getCalendar().getTimeZone());
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n2);
        LocalDateTime localDateTime = this.toLocalDateTime(sessionInterface, timestampData);
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }
}

