/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public abstract class DTIType
extends Type {
    public static final int secondsInDay = 86400;
    public static final long millisInSecond = 1000L;
    public static final long nanosInMilli = 1000000L;
    public static final long nanosInSecond = 1000000000L;
    public static final byte[] yearToSecondSeparators = new byte[]{45, 45, 32, 58, 58, 46};
    public static final int[] yearToSecondFactors = new int[]{12, 1, 86400, 3600, 60, 1, 0};
    public static final int[] yearToSecondLimits = new int[]{0, 12, 0, 24, 60, 60, 1000000000};
    public static final int INTERVAL_MONTH_INDEX = 1;
    public static final int INTERVAL_SECOND_INDEX = 5;
    public static final int INTERVAL_FRACTION_PART_INDEX = 6;
    public static final long[] precisionLimits = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};
    static final int[] precisionFactors = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    static final int[] nanoScaleFactors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    public static final int timezoneSecondsLimit = 64800;
    static final int[] intervalParts = new int[]{101, 102, 103, 104, 105, 106};
    static final int[][] intervalTypes = new int[][]{{101, 107, 0, 0, 0, 0}, {0, 102, 0, 0, 0, 0}, {0, 0, 103, 108, 109, 110}, {0, 0, 0, 104, 111, 112}, {0, 0, 0, 0, 105, 113}, {0, 0, 0, 0, 0, 106}};
    static final IntKeyIntValueHashMap intervalIndexMap = new IntKeyIntValueHashMap();
    public final int startIntervalType;
    public final int endIntervalType;
    public final int startPartIndex;
    public final int endPartIndex;
    public static final int defaultTimeFractionPrecision = 0;
    public static final int defaultTimestampFractionPrecision = 6;
    public static final int defaultIntervalPrecision = 2;
    public static final int defaultIntervalFractionPrecision = 6;
    public static final int maxIntervalPrecision = 9;
    public static final int maxIntervalSecondPrecision = 12;
    public static final int maxFractionPrecision = 9;
    public static final int limitNanoseconds = 1000000000;

    protected DTIType(int n2, int n3, long l2, int n4, int n5, int n6) {
        super(n2, n3, l2, n4);
        this.startIntervalType = n5;
        this.endIntervalType = n6;
        this.startPartIndex = intervalIndexMap.get(n5);
        this.endPartIndex = intervalIndexMap.get(n6);
    }

    protected DTIType(int n2, int n3, long l2, int n4) {
        super(n2, n3, l2, n4);
        switch (n3) {
            case 91: {
                this.startIntervalType = 101;
                this.endIntervalType = 103;
                break;
            }
            case 92: 
            case 94: {
                this.startIntervalType = 104;
                this.endIntervalType = 106;
                break;
            }
            case 93: 
            case 95: {
                this.startIntervalType = 101;
                this.endIntervalType = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DTIType");
            }
        }
        this.startPartIndex = intervalIndexMap.get(this.startIntervalType);
        this.endPartIndex = intervalIndexMap.get(this.endIntervalType);
    }

    String intervalSecondToString(long l2, int n2, boolean bl) {
        int n3;
        int n4;
        StringBuilder stringBuilder = new StringBuilder(64);
        if (l2 < 0L) {
            l2 = -l2;
            stringBuilder.append('-');
        } else if (bl) {
            stringBuilder.append('+');
        }
        for (n4 = this.startPartIndex; n4 <= this.endPartIndex; ++n4) {
            n3 = yearToSecondFactors[n4];
            long l3 = l2 / (long)n3;
            if (n4 == this.startPartIndex) {
                int n5 = this.precision == 0L ? 2 : (int)this.precision;
                int n6 = n5 - DTIType.getPrecisionExponent(l3);
            } else if (l3 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3);
            l2 %= (long)n3;
            if (n4 >= this.endPartIndex) continue;
            stringBuilder.append((char)yearToSecondSeparators[n4]);
        }
        if (this.scale != 0) {
            stringBuilder.append((char)yearToSecondSeparators[5]);
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        for (n4 = 0; n4 < this.scale; ++n4) {
            n3 = n2 / precisionFactors[n4];
            n2 -= n3 * precisionFactors[n4];
            stringBuilder.append(n3);
        }
        return stringBuilder.toString();
    }

    public int getStartIntervalType() {
        return this.startIntervalType;
    }

    public int getEndIntervalType() {
        return this.endIntervalType;
    }

    public Type getExtractType(int n2) {
        switch (n2) {
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 136: {
                if (!this.isDateTimeType()) {
                    throw Error.error(5561);
                }
                if (n2 == 128 || n2 == 129) {
                    return Type.SQL_VARCHAR;
                }
                return Type.SQL_INTEGER;
            }
            case 106: {
                if (n2 == this.startIntervalType || n2 == this.endIntervalType) {
                    if (this.scale == 0) {
                        return Type.SQL_BIGINT;
                    }
                    return new NumberType(3, 12 + this.scale, this.scale);
                }
                throw Error.error(5561);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                if (n2 < this.startIntervalType || n2 > this.endIntervalType) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
            case 132: 
            case 133: 
            case 134: {
                return Type.SQL_BIGINT;
            }
            case 130: {
                if (!this.isDateTimeType() || this.endIntervalType < 106) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
            case 121: 
            case 122: 
            case 135: {
                if (this.typeCode != 95 && this.typeCode != 94) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static int normaliseFraction(int n2, int n3) {
        return n2 / nanoScaleFactors[n3] * nanoScaleFactors[n3];
    }

    public static int normaliseFraction(int n2, int n3, int n4) {
        return (n2 *= nanoScaleFactors[n3]) / nanoScaleFactors[n4] * nanoScaleFactors[n4];
    }

    static int getPrecisionExponent(long l2) {
        int n2;
        for (n2 = 1; n2 < precisionLimits.length && l2 >= precisionLimits[n2]; ++n2) {
        }
        return n2;
    }

    public static int getFieldNameTypeForToken(int n2) {
        switch (n2) {
            case 341: {
                return 101;
            }
            case 183: {
                return 102;
            }
            case 78: {
                return 103;
            }
            case 137: {
                return 104;
            }
            case 179: {
                return 105;
            }
            case 264: {
                return 106;
            }
            case 872: {
                return 132;
            }
            case 871: {
                return 133;
            }
            case 873: {
                return 134;
            }
            case 299: {
                return 121;
            }
            case 300: {
                return 122;
            }
            case 828: {
                return 135;
            }
            case 734: {
                return 128;
            }
            case 773: {
                return 129;
            }
            case 787: {
                return 127;
            }
            case 735: {
                return 124;
            }
            case 736: {
                return 123;
            }
            case 737: {
                return 125;
            }
            case 851: {
                return 126;
            }
            case 852: {
                return 136;
            }
            case 805: {
                return 130;
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static String getFieldNameTokenForType(int n2) {
        switch (n2) {
            case 101: {
                return "YEAR";
            }
            case 102: {
                return "MONTH";
            }
            case 103: {
                return "DAY";
            }
            case 104: {
                return "HOUR";
            }
            case 105: {
                return "MINUTE";
            }
            case 106: {
                return "SECOND";
            }
            case 121: {
                return "TIMEZONE_HOUR";
            }
            case 122: {
                return "TIMEZONE_MINUTE";
            }
            case 128: {
                return "DAY_NAME";
            }
            case 129: {
                return "MONTH_NAME";
            }
            case 127: {
                return "QUARTER";
            }
            case 124: {
                return "DAY_OF_MONTH";
            }
            case 123: {
                return "DAY_OF_WEEK";
            }
            case 125: {
                return "DAY_OF_YEAR";
            }
            case 126: {
                return "WEEK_OF_YEAR";
            }
            case 136: {
                return "ISO_WEEK_OF_YEAR";
            }
            case 130: {
                return "SECONDS_SINCE_MIDNIGHT";
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static boolean isValidDatetimeRange(Type type, Type type2) {
        if (!type.isDateTimeType()) {
            return false;
        }
        if (type2.isDateTimeType()) {
            return (type.typeCode != 92 || type2.typeCode != 91) && (type.typeCode != 91 || type2.typeCode != 92);
        }
        if (type2.isIntervalType()) {
            return ((DateTimeType)type).canAdd((IntervalType)type2);
        }
        return false;
    }

    public abstract int getPart(Session var1, Object var2, int var3);

    public abstract BigDecimal getSecondPart(Session var1, Object var2);

    BigDecimal getSecondPart(long l2, long l3) {
        l2 *= precisionLimits[this.scale];
        return BigDecimal.valueOf(l2 += l3 / (long)nanoScaleFactors[this.scale], this.scale);
    }

    static {
        intervalIndexMap.put(101, 0);
        intervalIndexMap.put(102, 1);
        intervalIndexMap.put(103, 2);
        intervalIndexMap.put(104, 3);
        intervalIndexMap.put(105, 4);
        intervalIndexMap.put(106, 5);
    }
}

