/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.Charset;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.LongPair;
import org.hsqldb.types.Type;

public class CharacterType
extends Type {
    static final int defaultCharPrecision = 256;
    static final int defaultVarcharPrecision = 32768;
    public static final long maxCharPrecision = Integer.MAX_VALUE;
    final Collation collation;
    final Charset charset;
    final String nameString;
    private static final int fixedTypesLength = 32;
    static CharacterType[] charArray = new CharacterType[32];

    public CharacterType(Collation collation, int n2, long l2) {
        super(12, n2, l2, 0);
        if (collation == null) {
            collation = Collation.getDefaultInstance();
        }
        this.collation = collation;
        this.charset = Charset.getDefaultInstance();
        this.nameString = this.getNameStringPrivate();
    }

    public CharacterType(int n2, long l2) {
        super(12, n2, l2, 0);
        this.collation = Collation.getDefaultInstance();
        this.charset = Charset.getDefaultInstance();
        this.nameString = this.getNameStringPrivate();
    }

    public CharacterType(String string, long l2) {
        super(12, 12, l2, 0);
        this.collation = Collation.getDefaultInstance();
        this.charset = Charset.getDefaultInstance();
        this.nameString = string;
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 1: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 40: {
                return 2005;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Class getJDBCClass() {
        return String.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.String";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode == 1 ? this.typeCode : 12;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "VARCHAR";
            }
            case 40: {
                return "CLOB";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "CHARACTER VARYING";
            }
            case 40: {
                return "CHARACTER LARGE OBJECT";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(this.getNameString());
        stringBuilder.append('(');
        stringBuilder.append(this.precision);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean isCharacterType() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 12;
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.typeCode == this.typeCode) {
            return 0;
        }
        if (!type.isCharacterType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 1: {
                return type.typeCode == 40 ? 4 : 2;
            }
            case 12: {
                return type.typeCode == 40 ? 4 : 2;
            }
            case 40: {
                return type.typeCode == 1 ? -4 : -2;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.precision >= type.precision ? this : type;
        }
        switch (type.typeCode) {
            case 1: {
                return this.precision >= type.precision ? this : CharacterType.getCharacterType(this.typeCode, type.precision, type.getCollation());
            }
            case 12: {
                if (this.typeCode == 40) {
                    return this.precision >= type.precision ? this : CharacterType.getCharacterType(this.typeCode, type.precision, type.getCollation());
                }
                return type.precision >= this.precision ? type : CharacterType.getCharacterType(type.typeCode, this.precision, type.getCollation());
            }
            case 40: {
                return type.precision >= this.precision ? type : CharacterType.getCharacterType(type.typeCode, this.precision, type.getCollation());
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: 
            case 1111: {
                throw Error.error(5562);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        Type type2;
        if (n2 != 36) {
            return this.getAggregateType(type);
        }
        long l2 = this.precision + type.precision;
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case 1: {
                type2 = this;
                break;
            }
            case 12: {
                type2 = this.typeCode == 40 ? this : type;
                break;
            }
            case 40: {
                type2 = type;
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (l2 > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                l2 = Integer.MAX_VALUE;
            } else if (this.typeCode == 1) {
                l2 = Integer.MAX_VALUE;
            } else if (this.typeCode == 12) {
                l2 = Integer.MAX_VALUE;
            }
        }
        return CharacterType.getCharacterType(type2.typeCode, l2, this.collation);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        return this.compare(session, object, object2, 40);
    }

    @Override
    public int compare(Session session, Object object, Object object2, int n2) {
        int n3;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object2 instanceof ClobData) {
            long l2 = ((ClobData)object).getId();
            return -session.database.lobManager.compare(this.collation, l2, (String)object);
        }
        String string = (String)object;
        String string2 = (String)object2;
        int n4 = string.length();
        if (n4 != (n3 = string2.length())) {
            if (n4 > n3) {
                if (this.collation.isPadSpace() && n2 != 42) {
                    string2 = CharacterType.padString(string2, n4);
                }
            } else if (this.collation.isPadSpace() && n2 != 42) {
                string = CharacterType.padString(string, n3);
            }
        }
        return this.collation.compare(string, string2);
    }

    public static String padString(String string, int n2) {
        char[] cArray = new char[n2];
        string.getChars(0, string.length(), cArray, 0);
        ArrayUtil.fillArray(cArray, string.length(), ' ');
        return String.valueOf(cArray);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (this.precision == 0L) {
            return object;
        }
        switch (this.typeCode) {
            case 1: 
            case 12: {
                int n2 = ((String)object).length();
                if ((long)n2 > this.precision) {
                    if (sessionInterface instanceof Session && !((Session)sessionInterface).database.sqlTruncateTrailing) {
                        throw Error.error(3401);
                    }
                    if ((long)CharacterType.getRightTrimSize((String)object, ' ') <= this.precision) {
                        return ((String)object).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                if (this.typeCode == 12) {
                    return object;
                }
                if ((long)n2 == this.precision) {
                    return object;
                }
                char[] cArray = new char[(int)this.precision];
                ((String)object).getChars(0, n2, cArray, 0);
                int n3 = n2;
                while ((long)n3 < this.precision) {
                    cArray[n3] = 32;
                    ++n3;
                }
                return new String(cArray);
            }
            case 40: {
                ClobData clobData = (ClobData)object;
                if (clobData.length(sessionInterface) > this.precision) {
                    throw Error.error(3401);
                }
                return object;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        return this.castOrConvertToType(sessionInterface, object, type, true);
    }

    public Object castOrConvertToType(SessionInterface sessionInterface, Object object, Type type, boolean bl) {
        switch (type.typeCode) {
            case 1: 
            case 12: {
                int n2 = ((String)object).length();
                if (this.precision != 0L && (long)n2 > this.precision) {
                    if ((long)StringUtil.rightTrimSize((String)object) > this.precision) {
                        if (!bl) {
                            throw Error.error(3401);
                        }
                        sessionInterface.addWarning(Error.error(1004));
                    }
                    object = ((String)object).substring(0, (int)this.precision);
                }
                switch (this.typeCode) {
                    case 1: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 12: {
                        return object;
                    }
                    case 40: {
                        ClobDataID clobDataID = sessionInterface.createClob(((String)object).length());
                        clobDataID.setString(sessionInterface, 0L, (String)object);
                        return clobDataID;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 40: {
                long l2 = ((ClobData)object).length(sessionInterface);
                if (this.precision != 0L && l2 > this.precision) {
                    if (!bl) {
                        throw Error.error(3401);
                    }
                    sessionInterface.addWarning(Error.error(1004));
                }
                switch (this.typeCode) {
                    case 1: 
                    case 12: {
                        if (l2 > Integer.MAX_VALUE) {
                            if (!bl) {
                                throw Error.error(3401);
                            }
                            l2 = Integer.MAX_VALUE;
                        }
                        object = ((ClobData)object).getSubString(sessionInterface, 0L, (int)l2);
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 40: {
                        if (this.precision != 0L && l2 > this.precision) {
                            return ((ClobData)object).getClob(sessionInterface, 0L, this.precision);
                        }
                        return object;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 1111: {
                throw Error.error(5561);
            }
            case 30: {
                long l3 = ((BlobData)object).length(sessionInterface);
                if (this.precision != 0L && l3 * 2L > this.precision) {
                    throw Error.error(3401);
                }
                byte[] byArray = ((BlobData)object).getBytes(sessionInterface, 0L, (int)l3);
                object = StringConverter.byteArrayToHexString(byArray);
                return this.convertToTypeLimits(sessionInterface, object);
            }
        }
        String string = type.convertToString(object);
        if (this.precision != 0L && (long)string.length() > this.precision) {
            throw Error.error(3401);
        }
        object = string;
        return this.convertToTypeLimits(sessionInterface, object);
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        return this.castOrConvertToType(sessionInterface, object, type, false);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        if (type.typeCode == 30) {
            throw Error.error(5561);
        }
        return this.convertToType(sessionInterface, object, type);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        String string;
        if (object == null) {
            return object;
        }
        if (object instanceof Boolean) {
            string = object.toString();
        } else if (object instanceof BigDecimal) {
            string = ((BigDecimal)object).toPlainString();
        } else if (object instanceof Number) {
            string = object.toString();
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Date) {
            string = object.toString();
        } else if (object instanceof Time) {
            string = object.toString();
        } else if (object instanceof Timestamp) {
            string = object.toString();
        } else if (object instanceof java.util.Date) {
            object = new Timestamp(((java.util.Date)object).getTime());
            string = object.toString();
        } else if (object instanceof UUID) {
            string = object.toString();
        } else {
            string = this.convertJavaDateTimeObject(object);
            if (string == null) {
                throw Error.error(5561);
            }
        }
        return string;
    }

    String convertJavaDateTimeObject(Object object) {
        switch (object.getClass().getName()) {
            case "java.time.LocalDate": 
            case "java.time.LocalTime": {
                return object.toString();
            }
            case "java.time.LocalDateTime": 
            case "java.time.OffsetDateTime": 
            case "java.time.OffsetTime": {
                return object.toString().replace('T', ' ');
            }
        }
        return null;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        return this.convertToDefaultType(sessionInterface, object);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 1: {
                int n2 = ((String)object).length();
                if (this.precision == 0L || (long)n2 == this.precision) {
                    return (String)object;
                }
                char[] cArray = new char[(int)this.precision];
                ((String)object).getChars(0, n2, cArray, 0);
                int n3 = n2;
                while ((long)n3 < this.precision) {
                    cArray[n3] = 32;
                    ++n3;
                }
                return new String(cArray);
            }
            case 12: {
                return (String)object;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        String string = this.convertToString(object);
        return StringConverter.toQuotedString(string, '\'', true);
    }

    @Override
    public void convertToJSON(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        StringConverter.toJSONString((String)object, stringBuilder);
    }

    @Override
    public boolean canConvertFrom(Type type) {
        return !type.isObjectType();
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        switch (this.typeCode) {
            case 12: {
                if (type.typeCode == this.typeCode) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                if (type.typeCode == 1) {
                    return this.precision >= type.precision ? 0 : -1;
                }
                return -1;
            }
            case 40: {
                if (type.typeCode == 40) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                return -1;
            }
            case 1: {
                return type.typeCode == 1 && this.precision == type.precision ? 0 : -1;
            }
        }
        return -1;
    }

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public Charset getCharacterSet() {
        return this.charset;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CharacterType) {
            return super.equals(object) && ((CharacterType)object).getCollation().equals(this.getCollation());
        }
        return false;
    }

    public long position(SessionInterface sessionInterface, Object object, Object object2, Type type, long l2) {
        if (object == null || object2 == null) {
            return -1L;
        }
        if (type.typeCode == 40) {
            long l3 = ((ClobData)object2).length(sessionInterface);
            if (l2 + l3 > (long)((String)object).length()) {
                return -1L;
            }
            if (l3 > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            String string = ((ClobData)object2).getSubString(sessionInterface, 0L, (int)l3);
            return ((String)object).indexOf(string, (int)l2);
        }
        if (type.isCharacterType()) {
            long l4 = ((String)object2).length();
            if (l2 + l4 > (long)((String)object).length()) {
                return -1L;
            }
            return ((String)object).indexOf((String)object2, (int)l2);
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public static LongPair substringParams(long l2, long l3, long l4, boolean bl) {
        long l5 = bl ? l3 + l4 : Math.max(l2, l3);
        if (l3 >= l2 || l5 < 0L) {
            l3 = 0L;
            l4 = 0L;
        } else {
            l3 = Math.max(l3, 0L);
            l5 = Math.min(l5, l2);
            l4 = l5 - l3;
        }
        return new LongPair(l3, l4);
    }

    public Object substring(SessionInterface sessionInterface, Object object, long l2, long l3, boolean bl, boolean bl2) {
        long l4;
        if (l3 < 0L) {
            throw Error.error(3431);
        }
        long l5 = l4 = this.typeCode == 40 ? ((ClobData)object).length(sessionInterface) : (long)((String)object).length();
        if (bl2) {
            l2 = l4 - l2;
        }
        LongPair longPair = CharacterType.substringParams(l4, l2, l3, bl);
        l2 = longPair.a;
        l3 = longPair.b;
        if (object instanceof String) {
            return ((String)object).substring((int)l2, (int)(l2 + l3));
        }
        if (object instanceof ClobData) {
            ClobData clobData = ((ClobData)object).getClob(sessionInterface, l2, l3);
            return clobData;
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object upper(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String string = ((ClobData)object).getSubString(session, 0L, (int)((ClobData)object).length(session));
            string = this.collation.toUpperCase(string);
            ClobDataID clobDataID = session.createClob(string.length());
            clobDataID.setString(session, 0L, string);
            return clobDataID;
        }
        return this.collation.toUpperCase((String)object);
    }

    public Object lower(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String string = ((ClobData)object).getSubString(session, 0L, (int)((ClobData)object).length(session));
            string = this.collation.toLowerCase(string);
            ClobDataID clobDataID = session.createClob(string.length());
            clobDataID.setString(session, 0L, string);
            return clobDataID;
        }
        return this.collation.toLowerCase((String)object);
    }

    public Object trim(SessionInterface sessionInterface, Object object, char c2, boolean bl, boolean bl2) {
        int n2;
        String string;
        if (object == null) {
            return null;
        }
        if (this.typeCode == 40) {
            long l2 = ((ClobData)object).length(sessionInterface);
            if (l2 > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            string = ((ClobData)object).getSubString(sessionInterface, 0L, (int)l2);
        } else {
            string = (String)object;
        }
        int n3 = string.length();
        if (bl2) {
            --n3;
            while (n3 >= 0 && string.charAt(n3) == c2) {
                --n3;
            }
            ++n3;
        }
        if (bl) {
            for (n2 = 0; n2 < n3 && string.charAt(n2) == c2; ++n2) {
            }
        }
        if (n2 != 0 || n3 != string.length()) {
            string = string.substring(n2, n3);
        }
        if (this.typeCode == 40) {
            ClobDataID clobDataID = sessionInterface.createClob(string.length());
            clobDataID.setString(sessionInterface, 0L, string);
            return clobDataID;
        }
        return string;
    }

    public Object overlay(SessionInterface sessionInterface, Object object, Object object2, long l2, long l3, boolean bl) {
        if (object == null || object2 == null) {
            return null;
        }
        if (!bl) {
            l3 = this.typeCode == 40 ? ((ClobData)object2).length(sessionInterface) : (long)((String)object2).length();
        }
        Object object3 = this.concat(null, this.substring(sessionInterface, object, 0L, l2, true, false), object2);
        return this.concat(null, object3, this.substring(sessionInterface, object, l2 + l3, 0L, false, false));
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        String string = object instanceof ClobData ? ((ClobData)object).getSubString(session, 0L, (int)((ClobData)object).length(session)) : (String)object;
        String string2 = object2 instanceof ClobData ? ((ClobData)object2).getSubString(session, 0L, (int)((ClobData)object2).length(session)) : (String)object2;
        if (this.typeCode == 40) {
            ClobDataID clobDataID = session.createClob(string.length() + string2.length());
            clobDataID.setString(session, 0L, string);
            clobDataID.setString(session, string.length(), string2);
            return clobDataID;
        }
        return string + string2;
    }

    public long size(SessionInterface sessionInterface, Object object) {
        if (this.typeCode == 40) {
            return ((ClobData)object).length(sessionInterface);
        }
        return ((String)object).length();
    }

    public Boolean match(Session session, String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return null;
        }
        String string2 = null;
        int n2 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) {
                ++n2;
                bl = true;
            } else if (stringArray[i2].length() == 0) {
                bl = false;
            }
            if (bl) {
                if (n2 + stringArray[i2].length() > string.length()) {
                    return Boolean.FALSE;
                }
                string2 = string.substring(n2, n2 + stringArray[i2].length());
                if (this.collation.compare(string2, stringArray[i2]) != 0) {
                    return Boolean.FALSE;
                }
                n2 += stringArray[i2].length();
                continue;
            }
            int n3 = string.indexOf(stringArray[i2], n2);
            if (n3 < 0) {
                return Boolean.FALSE;
            }
            n2 = n3 + stringArray[i2].length();
            bl = true;
        }
        return Boolean.TRUE;
    }

    public Type getCharacterType(long l2) {
        if (l2 == this.precision) {
            return this;
        }
        return CharacterType.getCharacterType(this.typeCode, l2, this.collation);
    }

    public static int getRightTrimSize(String string, char c2) {
        int n2 = string.length();
        --n2;
        while (n2 >= 0 && string.charAt(n2) == c2) {
            --n2;
        }
        return ++n2;
    }

    public static CharacterType getCharacterType(int n2, long l2) {
        switch (n2) {
            case 1: {
                if (l2 < 32L) {
                    return charArray[(int)l2];
                }
                return new CharacterType(n2, (long)((int)l2));
            }
            case 12: {
                return new CharacterType(n2, (long)((int)l2));
            }
            case 40: {
                return new ClobType(l2);
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public static CharacterType getCharacterType(int n2, long l2, Collation collation) {
        if (collation == null) {
            collation = Collation.getDefaultInstance();
        }
        switch (n2) {
            case 1: 
            case 12: {
                return new CharacterType(collation, n2, (int)l2);
            }
            case 40: {
                return new ClobType(collation, l2);
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    static {
        for (int i2 = 0; i2 < charArray.length; ++i2) {
            CharacterType.charArray[i2] = new CharacterType(1, (long)i2);
        }
    }
}

