/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.LongPair;
import org.hsqldb.types.Type;

public class BinaryType
extends Type {
    public static final long maxBinaryPrecision = Integer.MAX_VALUE;

    protected BinaryType(int n2, long l2) {
        super(61, n2, l2, 0);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode == 60 ? -2 : -3;
    }

    @Override
    public Class getJDBCClass() {
        return byte[].class;
    }

    @Override
    public String getJDBCClassName() {
        return "[B";
    }

    @Override
    public String getNameString() {
        return this.typeCode == 60 ? "BINARY" : "VARBINARY";
    }

    public String getNameFullString() {
        return this.typeCode == 60 ? "BINARY" : "BINARY VARYING";
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(this.getNameString());
        stringBuilder.append('(');
        stringBuilder.append(this.precision);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 61;
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.typeCode == this.typeCode) {
            return 0;
        }
        if (!type.isBinaryType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 14: 
            case 15: {
                return Integer.MIN_VALUE;
            }
            case 60: {
                return type.typeCode == 30 ? 4 : 2;
            }
            case 61: {
                return type.typeCode == 30 ? 4 : 2;
            }
            case 30: {
                return type.typeCode == 60 ? -4 : -2;
            }
        }
        throw Error.runtimeError(201, "BinaryType");
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.precision >= type.precision ? this : type;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        switch (type.typeCode) {
            case 14: 
            case 15: {
                long l2 = (type.precision + 7L) / 8L;
                return this.precision >= l2 ? this : BinaryType.getBinaryType(this.typeCode, l2);
            }
            case 60: {
                return this.precision >= type.precision ? this : BinaryType.getBinaryType(this.typeCode, type.precision);
            }
            case 61: {
                if (this.typeCode == 30) {
                    return this.precision >= type.precision ? this : BinaryType.getBinaryType(this.typeCode, type.precision);
                }
                return type.precision >= this.precision ? type : BinaryType.getBinaryType(type.typeCode, this.precision);
            }
            case 30: {
                return type.precision >= this.precision ? type : BinaryType.getBinaryType(type.typeCode, this.precision);
            }
            case -11: {
                return type;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        Type type2;
        if (n2 != 36) {
            return this.getAggregateType(type);
        }
        long l2 = this.precision + type.precision;
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case 14: 
            case 15: {
                l2 = this.precision + (type.precision + 7L) / 8L;
                type2 = this;
                break;
            }
            case -11: 
            case 60: {
                type2 = this;
                break;
            }
            case 61: {
                type2 = this.typeCode == 30 ? this : type;
                break;
            }
            case 30: {
                type2 = type;
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        if (l2 > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                throw Error.error(5570);
            }
            if (this.typeCode == 61) {
                l2 = Integer.MAX_VALUE;
            }
        }
        return BinaryType.getBinaryType(type2.typeCode, l2);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof BinaryData && object2 instanceof BinaryData) {
            int n2;
            byte[] byArray;
            byte[] byArray2 = ((BinaryData)object).getBytes();
            int n3 = byArray2.length > (byArray = ((BinaryData)object2).getBytes()).length ? byArray.length : byArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (byArray2[n2] == byArray[n2]) continue;
                return (byArray2[n2] & 0xFF) > (byArray[n2] & 0xFF) ? 1 : -1;
            }
            if (byArray2.length == byArray.length) {
                return 0;
            }
            if (this.typeCode == 60) {
                if (byArray2.length > byArray.length) {
                    for (n2 = byArray.length; n2 < byArray2.length; ++n2) {
                        if (byArray2[n2] == 0) continue;
                        return 1;
                    }
                } else {
                    for (n2 = byArray2.length; n2 < byArray.length; ++n2) {
                        if (byArray[n2] == 0) continue;
                        return -1;
                    }
                }
                return 0;
            }
            return byArray2.length > byArray.length ? 1 : -1;
        }
        throw Error.runtimeError(201, "BinaryType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return this.castOrConvertToType(sessionInterface, object, this, false);
    }

    @Override
    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, true);
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, false);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, true);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        return ((BlobData)object).getBytes();
    }

    Object castOrConvertToType(SessionInterface sessionInterface, Object object, Type type, boolean bl) {
        BlobData blobData;
        if (object == null) {
            return null;
        }
        switch (type.typeCode) {
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: {
                blobData = sessionInterface.getScanner().convertToBinary((String)object, false);
                type = BinaryType.getBinaryType(61, blobData.length(sessionInterface));
                break;
            }
            case 14: {
                blobData = (BlobData)object;
                type = BinaryType.getBinaryType(61, blobData.length(sessionInterface));
                break;
            }
            case -11: 
            case 30: 
            case 60: 
            case 61: {
                blobData = (BlobData)object;
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (this.precision == 0L) {
            return blobData;
        }
        if (type.typeCode == 30) {
            long l2 = blobData.length(sessionInterface);
            if (l2 > this.precision) {
                throw Error.error(3401);
            }
            byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)l2);
            blobData = new BinaryData(byArray, false);
        }
        if (blobData.length(sessionInterface) > this.precision) {
            if (!bl && sessionInterface instanceof Session && !((Session)sessionInterface).database.sqlTruncateTrailing) {
                throw Error.error(3401);
            }
            if (blobData.nonZeroLength(sessionInterface) > this.precision) {
                if (!bl) {
                    throw Error.error(3401);
                }
                sessionInterface.addWarning(Error.error(1004));
            }
        }
        switch (this.typeCode) {
            case 60: {
                if (blobData.length(sessionInterface) > this.precision) {
                    byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)this.precision);
                    blobData = new BinaryData(byArray, false);
                } else if (blobData.length(sessionInterface) < this.precision) {
                    byte[] byArray = (byte[])ArrayUtil.resizeArray(blobData.getBytes(), (int)this.precision);
                    blobData = new BinaryData(byArray, false);
                }
                return blobData;
            }
            case 61: {
                if (blobData.length(sessionInterface) > this.precision) {
                    byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)this.precision);
                    blobData = new BinaryData(byArray, false);
                }
                return blobData;
            }
        }
        throw Error.error(3471);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, false);
        }
        if (object instanceof BinaryData) {
            return object;
        }
        if (object instanceof String) {
            return this.castOrConvertToType(sessionInterface, object, Type.SQL_VARCHAR, false);
        }
        throw Error.error(3471);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return StringConverter.byteArrayToHexString(((BlobData)object).getBytes());
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLHexString(((BinaryData)object).getBytes());
    }

    @Override
    public void convertToJSON(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('\"');
        stringBuilder.append(this.convertToString(object));
        stringBuilder.append('\"');
    }

    @Override
    public boolean canConvertFrom(Type type) {
        return type.typeCode == 0 || type.isBinaryType() || type.isBitType() || type.isCharacterType();
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type.isBitType() || type.isCharacterType()) {
            return -1;
        }
        switch (this.typeCode) {
            case 61: {
                if (type.typeCode == this.typeCode) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                if (type.typeCode == 60) {
                    return this.precision >= type.precision ? 0 : -1;
                }
                if (type.typeCode != -11) break;
                return this.precision >= type.precision ? 0 : -1;
            }
            case 60: {
                if (type.typeCode == this.typeCode) {
                    return this.precision == type.precision ? 0 : -1;
                }
                if (type.typeCode != -11) break;
                return this.precision == type.precision ? 0 : -1;
            }
            case 30: {
                if (type.typeCode != this.typeCode) break;
                return this.precision >= type.precision ? 0 : -1;
            }
        }
        return -1;
    }

    public long position(SessionInterface sessionInterface, BlobData blobData, BlobData blobData2, Type type, long l2) {
        if (blobData == null || blobData2 == null) {
            return -1L;
        }
        long l3 = blobData.length(sessionInterface);
        if (l2 + l3 > blobData.length(sessionInterface)) {
            return -1L;
        }
        return blobData.position(sessionInterface, blobData2, l2);
    }

    public BlobData substring(SessionInterface sessionInterface, BlobData blobData, long l2, long l3, boolean bl) {
        if (l3 < 0L) {
            throw Error.error(3431);
        }
        long l4 = blobData.length(sessionInterface);
        LongPair longPair = CharacterType.substringParams(l4, l2, l3, bl);
        l2 = longPair.a;
        l3 = longPair.b;
        if (blobData instanceof BinaryData) {
            byte[] byArray = blobData.getBytes(sessionInterface, l2, (int)l3);
            return new BinaryData(byArray, false);
        }
        if (blobData instanceof BlobData) {
            BlobData blobData2 = blobData.getBlob(sessionInterface, l2, l3);
            return blobData2;
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    int getRightTrimSize(BlobData blobData) {
        byte[] byArray = blobData.getBytes();
        int n2 = byArray.length;
        --n2;
        while (n2 >= 0 && byArray[n2] == 0) {
            --n2;
        }
        return ++n2;
    }

    public BlobData trim(Session session, BlobData blobData, int n2, boolean bl, boolean bl2) {
        int n3;
        if (blobData == null) {
            return null;
        }
        long l2 = blobData.length(session);
        if (l2 > Integer.MAX_VALUE) {
            throw Error.error(3460);
        }
        byte[] byArray = blobData.getBytes(session, 0L, (int)l2);
        int n4 = byArray.length;
        if (bl2) {
            --n4;
            while (n4 >= 0 && byArray[n4] == n2) {
                --n4;
            }
            ++n4;
        }
        if (bl) {
            for (n3 = 0; n3 < n4 && byArray[n3] == n2; ++n3) {
            }
        }
        byte[] byArray2 = byArray;
        if (n3 != 0 || n4 != byArray.length) {
            byArray2 = new byte[n4 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, n4 - n3);
        }
        if (this.typeCode == 30) {
            BlobDataID blobDataID = session.createBlob(byArray2.length);
            blobDataID.setBytes(session, 0L, byArray2);
            return blobDataID;
        }
        return new BinaryData(byArray2, byArray2 == byArray);
    }

    public BlobData overlay(Session session, BlobData blobData, BlobData blobData2, long l2, long l3, boolean bl) {
        if (blobData == null || blobData2 == null) {
            return null;
        }
        if (!bl) {
            l3 = blobData2.length(session);
        }
        switch (this.typeCode) {
            case 60: 
            case 61: {
                BinaryData binaryData = new BinaryData(session, this.substring(session, blobData, 0L, l2, true), blobData2);
                binaryData = new BinaryData(session, binaryData, this.substring(session, blobData, l2 + l3, 0L, false));
                return binaryData;
            }
            case 30: {
                byte[] byArray = this.substring(session, blobData, 0L, l2, false).getBytes();
                long l4 = blobData.length(session) + blobData2.length(session) - l3;
                BlobDataID blobDataID = session.createBlob(l4);
                blobDataID.setBytes(session, 0L, byArray);
                blobDataID.setBytes(session, blobDataID.length(session), blobData2.getBytes());
                byArray = this.substring(session, blobData, l2 + l3, 0L, false).getBytes();
                blobDataID.setBytes(session, blobDataID.length(session), byArray);
                return blobDataID;
            }
        }
        throw Error.runtimeError(201, "BinaryType");
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        long l2 = ((BlobData)object).length(session) + ((BlobData)object2).length(session);
        if (l2 > this.precision) {
            throw Error.error(3401);
        }
        if (this.typeCode == 30) {
            BlobDataID blobDataID = session.createBlob(l2);
            blobDataID.setBytes((SessionInterface)session, 0L, (BlobData)object, 0L, ((BlobData)object).length(session));
            blobDataID.setBytes((SessionInterface)session, ((BlobData)object).length(session), (BlobData)object2, 0L, ((BlobData)object2).length(session));
            return blobDataID;
        }
        return new BinaryData(session, (BlobData)object, (BlobData)object2);
    }

    public static BinaryType getBinaryType(int n2, long l2) {
        switch (n2) {
            case 60: 
            case 61: {
                return new BinaryType(n2, l2);
            }
            case 30: {
                return new BlobType(l2);
            }
        }
        throw Error.runtimeError(201, "BinaryType");
    }
}

