/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Array;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.types.Type;
import org.hsqldb.types.TypedComparator;

public class ArrayType
extends Type {
    public static final int defaultArrayCardinality = 0x100000;
    public static final int defaultLargeArrayCardinality = Integer.MAX_VALUE;
    final Type dataType;
    final int maxCardinality;

    public ArrayType(Type type, int n2) {
        super(50, 50, 0L, 0);
        if (type == null) {
            type = Type.SQL_ALL_TYPES;
        }
        this.dataType = type;
        this.maxCardinality = n2;
    }

    @Override
    public int displaySize() {
        return 7 + (this.dataType.displaySize() + 1) * this.maxCardinality;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2003;
    }

    @Override
    public Class getJDBCClass() {
        return Array.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Array";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 0;
    }

    @Override
    public String getNameString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataType.getNameString()).append(' ');
        stringBuilder.append("ARRAY");
        if (this.maxCardinality != 0x100000) {
            stringBuilder.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getFullNameString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataType.getFullNameString()).append(' ');
        stringBuilder.append("ARRAY");
        if (this.maxCardinality != 0x100000) {
            stringBuilder.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDefinition() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataType.getDefinition()).append(' ');
        stringBuilder.append("ARRAY");
        if (this.maxCardinality != 0x100000) {
            stringBuilder.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Object[] objectArray = (Object[])object2;
        Object[] objectArray2 = (Object[])object;
        int n2 = objectArray2.length;
        if (objectArray.length < n2) {
            n2 = objectArray.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.dataType.compare(session, objectArray2[i2], objectArray[i2]);
            if (n3 == 0) continue;
            return n3;
        }
        if (objectArray2.length > objectArray.length) {
            return 1;
        }
        if (objectArray2.length < objectArray.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = this.dataType.convertToTypeLimits(sessionInterface, objectArray[i2]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type == null) {
            return object;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Type type2 = type.collectionBaseType();
        if (this.dataType.equals(type2)) {
            return object;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = this.dataType.convertToType(sessionInterface, objectArray[i2], type2);
        }
        return objectArray2;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        Object[] objectArray;
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
            bl = true;
        } else if (object instanceof JDBCArray) {
            objectArray = ((JDBCArray)object).getArrayInternal();
        } else if (object instanceof JDBCArrayBasic) {
            objectArray = (Object[])((JDBCArrayBasic)object).getArray();
            bl = true;
        } else if (object instanceof Array) {
            try {
                objectArray = (Object[])((Array)object).getArray();
                bl = true;
            }
            catch (Exception exception) {
                throw Error.error(5561);
            }
        } else {
            throw Error.error(5561);
        }
        if (bl) {
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object2 = this.dataType.convertJavaToSQL(sessionInterface, objectArray[i2]);
                objectArray2[i2] = this.dataType.convertToTypeLimits(sessionInterface, object2);
            }
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return new JDBCArray(objectArray, this.collectionBaseType(), (Type)this, sessionInterface);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        return object;
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return this.convertToSQLString(object);
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        Object[] objectArray = (Object[])object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ARRAY");
        stringBuilder.append('[');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.dataType.convertToSQLString(objectArray[i2]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void convertToJSON(Object object, StringBuilder stringBuilder) {
        Object[] objectArray = (Object[])object;
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('[');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            this.dataType.convertToJSON(objectArray[i2], stringBuilder);
        }
        stringBuilder.append(']');
    }

    public void convertToJSONsimple(Object object, StringBuilder stringBuilder) {
        Object[] objectArray = (Object[])object;
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('[');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            String string = this.dataType.convertToString(objectArray[i2]);
            stringBuilder.append((Object)string);
        }
        stringBuilder.append(']');
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isArrayType()) {
            return false;
        }
        Type type2 = type.collectionBaseType();
        return this.dataType.canConvertFrom(type2);
    }

    @Override
    public int canMoveFrom(Type type) {
        if (!type.isArrayType()) {
            return -1;
        }
        if (this.maxCardinality >= ((ArrayType)type).maxCardinality) {
            return this.dataType.canMoveFrom(type);
        }
        if (this.dataType.canMoveFrom(type) == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean canBeAssignedFrom(Type type) {
        if (type == null) {
            return true;
        }
        Type type2 = type.collectionBaseType();
        return type2 != null && this.dataType.canBeAssignedFrom(type2);
    }

    @Override
    public Type collectionBaseType() {
        return this.dataType;
    }

    @Override
    public int arrayLimitCardinality() {
        return this.maxCardinality;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this == type) {
            return this;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Type type2 = type.collectionBaseType();
        if (this.dataType.equals(type2)) {
            return ((ArrayType)type).maxCardinality > this.maxCardinality ? type : this;
        }
        Type type3 = this.dataType.getAggregateType(type2);
        int n2 = ((ArrayType)type).maxCardinality > this.maxCardinality ? ((ArrayType)type).maxCardinality : this.maxCardinality;
        return new ArrayType(type3, n2);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        ArrayType arrayType = (ArrayType)this.getAggregateType(type);
        if (type == null) {
            return arrayType;
        }
        if (n2 != 36) {
            return arrayType;
        }
        if (arrayType.maxCardinality == Integer.MAX_VALUE) {
            return arrayType;
        }
        long l2 = (long)((ArrayType)type).maxCardinality + (long)this.maxCardinality;
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new ArrayType(this.dataType, (int)l2);
    }

    @Override
    public int cardinality(Session session, Object object) {
        if (object == null) {
            return 0;
        }
        return ((Object[])object).length;
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        int n2 = ((Object[])object).length + ((Object[])object2).length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(object, 0, objectArray, 0, ((Object[])object).length);
        System.arraycopy(object2, 0, objectArray, ((Object[])object).length, ((Object[])object2).length);
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayType) {
            return super.equals(object) && this.maxCardinality == ((ArrayType)object).maxCardinality && this.dataType.equals(((ArrayType)object).dataType);
        }
        return false;
    }

    @Override
    public int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n2 = 0;
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < objectArray.length && i2 < 4; ++i2) {
            n2 += this.dataType.hashCode(objectArray[i2]);
        }
        return n2;
    }

    public void sort(Session session, Object[] objectArray, SortAndSlice sortAndSlice) {
        TypedComparator typedComparator = session.getComparator();
        typedComparator.setType(this.dataType, sortAndSlice);
        ArraySort.sort(objectArray, objectArray.length, typedComparator);
    }

    public int deDuplicate(Session session, Object object, SortAndSlice sortAndSlice) {
        Object[] objectArray = (Object[])object;
        TypedComparator typedComparator = session.getComparator();
        typedComparator.setType(this.dataType, sortAndSlice);
        return ArraySort.deDuplicate(objectArray, objectArray.length, typedComparator);
    }
}

