/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.Session;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.server.OdbcPreparedStatement;
import org.hsqldb.server.PgType;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.types.Type;

class StatementPortal {
    public Object[] parameters;
    public Result bindResult;
    public Result ackResult;
    public String lcQuery;
    public String handle;
    private Map containingMap;
    private Session session;

    public StatementPortal(String string, OdbcPreparedStatement odbcPreparedStatement, Map map) throws RecoverableOdbcFailure {
        this(string, odbcPreparedStatement, new Object[0], map);
    }

    public StatementPortal(String string, OdbcPreparedStatement odbcPreparedStatement, Object[] objectArray, Map map) throws RecoverableOdbcFailure {
        this.handle = string;
        this.lcQuery = odbcPreparedStatement.query.toLowerCase();
        this.ackResult = odbcPreparedStatement.ackResult;
        this.session = odbcPreparedStatement.session;
        this.containingMap = map;
        Type[] typeArray = Type.emptyArray;
        switch (this.ackResult.getType()) {
            case 4: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(this.ackResult);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from secondary Statement prep is of unexpected type: " + this.ackResult.getType());
            }
        }
        if (objectArray.length < 1) {
            this.parameters = new Object[0];
        } else {
            ResultMetaData resultMetaData = odbcPreparedStatement.ackResult.parameterMetaData;
            if (resultMetaData == null) {
                throw new RecoverableOdbcFailure("No metadata for Result ack");
            }
            typeArray = resultMetaData.getParameterTypes();
            if (typeArray.length != objectArray.length) {
                throw new RecoverableOdbcFailure(null, "Client didn't specify all " + typeArray.length + " parameters (" + objectArray.length + ")", "08P01");
            }
            this.parameters = new Object[objectArray.length];
            try {
                for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                    if (objectArray[i2] instanceof String) {
                        PgType pgType = PgType.getPgType(typeArray[i2]);
                        this.parameters[i2] = pgType.getParameter((String)objectArray[i2], this.session);
                        continue;
                    }
                    this.parameters[i2] = objectArray[i2];
                }
            }
            catch (SQLException sQLException) {
                throw new RecoverableOdbcFailure("Typing failure: " + sQLException);
            }
        }
        this.bindResult = Result.newPreparedExecuteRequest(typeArray, odbcPreparedStatement.ackResult.getStatementID());
        map.put(string, this);
    }

    public void close() {
        this.containingMap.remove(this.handle);
    }
}

