/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocket;
import org.hsqldb.ClientConnection;
import org.hsqldb.ColumnBase;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.server.CleanExit;
import org.hsqldb.server.InResultProcessor;
import org.hsqldb.server.OdbcPacketInputStream;
import org.hsqldb.server.OdbcPacketOutputStream;
import org.hsqldb.server.OdbcPreparedStatement;
import org.hsqldb.server.OdbcUtil;
import org.hsqldb.server.PgType;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.server.Server;
import org.hsqldb.server.StatementPortal;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

class ServerConnection
implements Runnable {
    boolean keepAlive;
    private String user;
    int dbID;
    int dbIndex;
    private volatile Session session;
    private Socket socket;
    private Server server;
    private DataInputStream dataInput;
    private DataOutputStream dataOutput;
    private long mThread;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    RowOutputInterface rowOut;
    RowInputBinary rowIn;
    Thread runnerThread;
    InResultProcessor processor;
    private static AtomicLong mCurrentThread = new AtomicLong(0L);
    protected static String TEXTBANNER_PART1 = null;
    protected static String TEXTBANNER_PART2 = null;
    private CleanExit cleanExit = new CleanExit();
    private OdbcPacketOutputStream outPacket = null;
    public static long MAX_WAIT_FOR_CLIENT_DATA;
    public static long CLIENT_DATA_POLLING_PERIOD;
    private Map sessionOdbcPsMap = new HashMap();
    private Map sessionOdbcPortalMap = new HashMap();
    private int streamProtocol = 0;
    static final int UNDEFINED_STREAM_PROTOCOL = 0;
    static final int HSQL_STREAM_PROTOCOL = 1;
    static final int ODBC_STREAM_PROTOCOL = 2;
    int odbcCommMode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection(Socket socket, Server server) {
        RowOutputBinary rowOutputBinary = new RowOutputBinary(this.mainBuffer);
        this.rowIn = new RowInputBinary(rowOutputBinary);
        this.rowOut = rowOutputBinary;
        this.socket = socket;
        this.server = server;
        this.mThread = mCurrentThread.getAndIncrement();
        Object object = server.serverConnSetSync;
        synchronized (object) {
            server.serverConnSet.add(this);
        }
    }

    void signalClose() {
        this.keepAlive = false;
        if (Thread.currentThread().equals(this.runnerThread)) {
            Result result = Result.updateZeroResult;
            try {
                result.write(this.session, this.dataOutput, this.rowOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        Object object = this;
        synchronized (object) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        object = this.server.serverConnSetSync;
        synchronized (object) {
            this.server.serverConnSet.remove(this);
        }
        try {
            this.runnerThread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void init() {
        this.runnerThread = Thread.currentThread();
        this.keepAlive = true;
        try {
            this.socket.setTcpNoDelay(true);
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            int n2 = this.handshake();
            switch (this.streamProtocol) {
                case 1: {
                    byte by = this.dataInput.readByte();
                    this.processor.receiveConnection(by);
                    break;
                }
                case 2: {
                    this.processor.receiveConnection(n2);
                    break;
                }
                default: {
                    this.keepAlive = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.mThread));
            stringBuilder.append(":Failed to connect client.");
            if (this.user != null) {
                stringBuilder.append("  User '").append(this.user).append("'.");
            }
            stringBuilder.append("  Stack trace follows.");
            this.server.printWithThread(stringBuilder.toString());
            this.server.printStackTrace(exception);
        }
    }

    private void receiveResult(int n2) throws CleanExit, IOException {
        boolean bl = false;
        Result result = Result.newResult(this.session, n2, this.dataInput, this.rowIn);
        result.readLobResults(this.session, this.dataInput);
        this.server.printRequest(this.mThread, result);
        Result result2 = null;
        switch (result.getType()) {
            case 31: {
                result2 = this.setDatabase(result);
                break;
            }
            case 5: {
                result2 = this.cancelStatement(result);
                bl = true;
                break;
            }
            case 32: {
                result2 = Result.updateZeroResult;
                bl = true;
                break;
            }
            case 10: {
                this.session.resetSession();
                result2 = Result.updateZeroResult;
                break;
            }
            case 21: {
                result2 = Result.newErrorResult(Error.error(1252));
                break;
            }
            default: {
                result2 = this.session.execute(result);
            }
        }
        result2.write(this.session, this.dataOutput, this.rowOut);
        this.rowOut.reset(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        if (bl) {
            throw this.cleanExit;
        }
    }

    private void receiveOdbcPacket(char c2) throws IOException, CleanExit {
        boolean bl = false;
        String string = null;
        OdbcPacketInputStream odbcPacketInputStream = null;
        try {
            odbcPacketInputStream = OdbcPacketInputStream.newOdbcPacketInputStream(c2, this.dataInput);
            this.server.printWithThread("Got op (" + odbcPacketInputStream.packetType + ")");
            this.server.printWithThread("Got packet length of " + odbcPacketInputStream.available() + " + type byte + 4 size header");
            if (odbcPacketInputStream.available() >= 1000000000) {
                throw new IOException("Insane packet length: " + odbcPacketInputStream.available() + " + type byte + 4 size header");
            }
        }
        catch (SocketException socketException) {
            this.server.printWithThread("Ungraceful client exit: " + socketException);
            throw this.cleanExit;
        }
        catch (IOException iOException) {
            this.server.printWithThread("Fatal ODBC protocol failure: " + iOException);
            try {
                OdbcUtil.alertClient(1, iOException.toString(), "08P01", this.dataOutput);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.cleanExit;
        }
        switch (this.odbcCommMode) {
            case 2: {
                if (odbcPacketInputStream.packetType != 'S') {
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Ignoring a '" + odbcPacketInputStream.packetType + "'");
                    }
                    return;
                }
                this.odbcCommMode = 1;
                this.server.printWithThread("EXTENDED comm session being recovered");
                break;
            }
            case 0: {
                switch (odbcPacketInputStream.packetType) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'H': 
                    case 'P': 
                    case 'S': {
                        this.odbcCommMode = 1;
                        this.server.printWithThread("Switching mode from SIMPLE to EXTENDED");
                    }
                }
                break;
            }
            case 1: {
                switch (odbcPacketInputStream.packetType) {
                    case 'Q': {
                        this.odbcCommMode = 0;
                        this.server.printWithThread("Switching mode from EXTENDED to SIMPLE");
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ODBC comm mode value: " + this.odbcCommMode);
            }
        }
        this.outPacket.reset();
        try {
            block17 : switch (odbcPacketInputStream.packetType) {
                case 'Q': {
                    int n2;
                    Object object = odbcPacketInputStream.readString();
                    if (((String)object).startsWith("BEGIN;") || ((String)object).equals("BEGIN")) {
                        object = ((String)object).equals("BEGIN") ? null : ((String)object).substring("BEGIN;".length());
                        this.server.printWithThread("ODBC Trans started.  Session AutoCommit -> F");
                        try {
                            this.session.setAutoCommit(false);
                        }
                        catch (HsqlException hsqlException) {
                            throw new RecoverableOdbcFailure("Failed to change transaction state: " + hsqlException.getMessage(), hsqlException.getSQLState());
                        }
                        this.outPacket.write("BEGIN");
                        this.outPacket.xmit('C', this.dataOutput);
                        if (object == null) {
                            bl = true;
                            break;
                        }
                    }
                    if (((String)object).startsWith("SAVEPOINT ") && ((String)object).indexOf(59) > 0) {
                        int n3 = ((String)object).indexOf(59);
                        this.server.printWithThread("Interposing BEFORE primary statement: " + ((String)object).substring(0, n3));
                        this.odbcExecDirect(((String)object).substring(0, n3));
                        object = ((String)object).substring(n3 + 1);
                    }
                    if ((n2 = ((String)object).lastIndexOf(59)) > 0) {
                        String string2 = ((String)object).substring(n2 + 1);
                        if (string2.startsWith("RELEASE ")) {
                            string = string2;
                            object = ((String)object).substring(0, n2);
                        }
                        if (string2.startsWith("show transaction_isolation")) {
                            string = null;
                            object = "values session_isolation_level()";
                        }
                    }
                    Object object2 = ((String)object).trim().toLowerCase();
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received query (" + (String)object + ")");
                    }
                    if (((String)object2).startsWith("select current_schema()")) {
                        object2 = object = "values current_schema()";
                    }
                    if (((String)object2).startsWith("show ")) {
                        object2 = object = "values " + ((String)object).substring("show ".length());
                    }
                    if (((String)object2).startsWith("values n.nspname,")) {
                        this.server.printWithThread("Swallowing 'select n.nspname,...'");
                        this.outPacket.writeShort(1);
                        this.outPacket.write("oid");
                        this.outPacket.writeInt(201);
                        this.outPacket.writeShort(1);
                        this.outPacket.writeInt(23);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.xmit('T', this.dataOutput);
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (((String)object2).startsWith("select oid, typbasetype from")) {
                        this.server.printWithThread("Simulating 'select oid, typbasetype...'");
                        this.outPacket.writeShort(2);
                        this.outPacket.write("oid");
                        this.outPacket.writeInt(101);
                        this.outPacket.writeShort(102);
                        this.outPacket.writeInt(26);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.write("typbasetype");
                        this.outPacket.writeInt(101);
                        this.outPacket.writeShort(103);
                        this.outPacket.writeInt(26);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.xmit('T', this.dataOutput);
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (((String)object2).startsWith("select ") || ((String)object2).startsWith("values ")) {
                        int n4;
                        this.server.printWithThread("Performing a real non-prepared SELECT...");
                        Result result = Result.newExecuteDirectRequest();
                        result.setPrepareOrExecuteProperties((String)object, 0, 0, 2, 0, 0, 2, null, null);
                        this.server.printWithThread((String)object);
                        Result result2 = this.session.execute(result);
                        switch (result2.getType()) {
                            case 3: {
                                break;
                            }
                            case 2: {
                                throw new RecoverableOdbcFailure(result2);
                            }
                            default: {
                                throw new RecoverableOdbcFailure("Output Result from Query execution is of unexpected type: " + result2.getType());
                            }
                        }
                        RowSetNavigator rowSetNavigator = result2.getNavigator();
                        ResultMetaData resultMetaData = result2.metaData;
                        if (resultMetaData == null) {
                            throw new RecoverableOdbcFailure("Failed to get metadata for query results");
                        }
                        int n5 = resultMetaData.getColumnCount();
                        String[] stringArray = resultMetaData.getGeneratedColumnNames();
                        Type[] typeArray = resultMetaData.columnTypes;
                        PgType[] pgTypeArray = new PgType[n5];
                        for (int i2 = 0; i2 < pgTypeArray.length; ++i2) {
                            pgTypeArray[i2] = PgType.getPgType(typeArray[i2]);
                        }
                        ColumnBase[] columnBaseArray = resultMetaData.columns;
                        this.outPacket.writeShort(n5);
                        for (n4 = 0; n4 < n5; ++n4) {
                            if (stringArray[n4] != null) {
                                this.outPacket.write(stringArray[n4]);
                            } else {
                                this.outPacket.write(columnBaseArray[n4].getNameString());
                            }
                            this.outPacket.writeInt(OdbcUtil.getTableOidForColumn(n4, resultMetaData));
                            this.outPacket.writeShort(OdbcUtil.getIdForColumn(n4, resultMetaData));
                            this.outPacket.writeInt(pgTypeArray[n4].getOid());
                            this.outPacket.writeShort(pgTypeArray[n4].getTypeWidth());
                            this.outPacket.writeInt(pgTypeArray[n4].getLPConstraint());
                            this.outPacket.writeShort(0);
                        }
                        this.outPacket.xmit('T', this.dataOutput);
                        n4 = 0;
                        while (rowSetNavigator.next()) {
                            ++n4;
                            Object[] objectArray = rowSetNavigator.getCurrent();
                            if (objectArray == null) {
                                throw new RecoverableOdbcFailure("Null row?");
                            }
                            if (objectArray.length < n5) {
                                throw new RecoverableOdbcFailure("Data element mismatch. " + n5 + " metadata cols, yet " + objectArray.length + " data elements for row " + n4);
                            }
                            this.outPacket.writeShort(n5);
                            for (int i3 = 0; i3 < n5; ++i3) {
                                if (objectArray[i3] == null) {
                                    this.outPacket.writeInt(-1);
                                    continue;
                                }
                                String string3 = pgTypeArray[i3].valueString(objectArray[i3]);
                                this.outPacket.writeSized(string3);
                                if (!this.server.isTrace()) continue;
                                this.server.printWithThread("R" + n4 + "C" + (i3 + 1) + " => (" + objectArray[i3].getClass().getName() + ") [" + string3 + "]");
                            }
                            this.outPacket.xmit('D', this.dataOutput);
                        }
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (((String)object2).startsWith("deallocate \"") && ((String)object2).charAt(((String)object2).length() - 1) == '\"') {
                        StatementPortal statementPortal;
                        String string4 = ((String)object).trim().substring("deallocate \"".length()).trim();
                        String string5 = string4.substring(0, string4.length() - 1);
                        OdbcPreparedStatement odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string5);
                        if (odbcPreparedStatement != null) {
                            odbcPreparedStatement.close();
                        }
                        if ((statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string5)) != null) {
                            statementPortal.close();
                        }
                        if (odbcPreparedStatement == null && statementPortal == null) {
                            this.server.printWithThread("Ignoring bad 'DEALLOCATE' cmd");
                        }
                        if (this.server.isTrace()) {
                            this.server.printWithThread("Deallocated PS/Portal '" + string5 + "'");
                        }
                        this.outPacket.write("DEALLOCATE");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (((String)object2).startsWith("set client_encoding to ")) {
                        this.server.printWithThread("Stubbing EXECDIR for: " + (String)object);
                        this.outPacket.write("SET");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    this.server.printWithThread("Performing a real EXECDIRECT...");
                    this.odbcExecDirect((String)object);
                    bl = true;
                    break;
                }
                case 'X': {
                    if (this.sessionOdbcPsMap.size() > (this.sessionOdbcPsMap.containsKey("") ? 1 : 0)) {
                        this.server.printWithThread("Client left " + this.sessionOdbcPsMap.size() + " PS objects open");
                    }
                    if (this.sessionOdbcPortalMap.size() > (this.sessionOdbcPortalMap.containsKey("") ? 1 : 0)) {
                        this.server.printWithThread("Client left " + this.sessionOdbcPortalMap.size() + " Portal objects open");
                    }
                    OdbcUtil.validateInputPacketSize(odbcPacketInputStream);
                    throw this.cleanExit;
                }
                case 'H': {
                    break;
                }
                case 'S': {
                    if (this.session.isAutoCommit()) {
                        try {
                            this.server.printWithThread("Silly implicit commit by Sync");
                            this.session.commit(true);
                        }
                        catch (HsqlException hsqlException) {
                            this.server.printWithThread("Implicit commit failed: " + hsqlException);
                            OdbcUtil.alertClient(2, "Implicit commit failed", hsqlException.getSQLState(), this.dataOutput);
                        }
                    }
                    bl = true;
                    break;
                }
                case 'P': {
                    String string6 = odbcPacketInputStream.readString();
                    String string7 = OdbcUtil.revertMungledPreparedQuery(odbcPacketInputStream.readString());
                    int n6 = odbcPacketInputStream.readUnsignedShort();
                    for (int i4 = 0; i4 < n6; ++i4) {
                        if (odbcPacketInputStream.readInt() == 0) continue;
                        throw new RecoverableOdbcFailure(null, "Parameter-type OID specifiers not supported yet", "0A000");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Prepare request for query (" + string7 + ") with handle '" + string6 + "'");
                    }
                    if (string6.length() > 0 && this.sessionOdbcPsMap.containsKey(string6)) {
                        throw new RecoverableOdbcFailure(null, "PS handle '" + string6 + "' already in use.  You must close it before recreating", "08P01");
                    }
                    new OdbcPreparedStatement(string6, string7, this.sessionOdbcPsMap, this.session);
                    this.outPacket.xmit('1', this.dataOutput);
                    break;
                }
                case 'D': {
                    int n7;
                    ResultMetaData resultMetaData;
                    Type[] typeArray;
                    char c3 = odbcPacketInputStream.readByteChar();
                    String string8 = odbcPacketInputStream.readString();
                    OdbcPreparedStatement odbcPreparedStatement = null;
                    StatementPortal statementPortal = null;
                    if (c3 == 'S') {
                        odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string8);
                    } else if (c3 == 'P') {
                        statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string8);
                    } else {
                        throw new RecoverableOdbcFailure(null, "Description packet request type invalid: " + c3, "08P01");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Describe request for " + c3 + " of  handle '" + string8 + "'");
                    }
                    if (odbcPreparedStatement == null && statementPortal == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for " + c3 + " handle: " + string8, "08P01");
                    }
                    Result result = odbcPreparedStatement == null ? statementPortal.ackResult : odbcPreparedStatement.ackResult;
                    ResultMetaData resultMetaData2 = result.parameterMetaData;
                    int n8 = resultMetaData2.getColumnCount();
                    if (n8 != (typeArray = resultMetaData2.getParameterTypes()).length) {
                        throw new RecoverableOdbcFailure("Parameter count mismatch.  Count of " + n8 + " reported, but there are " + typeArray.length + " param md objects");
                    }
                    if (c3 == 'S') {
                        this.outPacket.writeShort(n8);
                        for (int i5 = 0; i5 < typeArray.length; ++i5) {
                            this.outPacket.writeInt(PgType.getPgType(typeArray[i5]).getOid());
                        }
                        this.outPacket.xmit('t', this.dataOutput);
                    }
                    if ((resultMetaData = result.metaData).getColumnCount() < 1) {
                        if (this.server.isTrace()) {
                            this.server.printWithThread("Non-rowset query so returning NoData packet");
                        }
                        this.outPacket.xmit('n', this.dataOutput);
                        break;
                    }
                    String[] stringArray = resultMetaData.getGeneratedColumnNames();
                    if (resultMetaData.getColumnCount() != stringArray.length) {
                        throw new RecoverableOdbcFailure("Couldn't get all column names: " + resultMetaData.getColumnCount() + " cols. but only got " + stringArray.length + " col. names");
                    }
                    Type[] typeArray2 = resultMetaData.columnTypes;
                    PgType[] pgTypeArray = new PgType[stringArray.length];
                    ColumnBase[] columnBaseArray = resultMetaData.columns;
                    for (n7 = 0; n7 < pgTypeArray.length; ++n7) {
                        pgTypeArray[n7] = PgType.getPgType(typeArray2[n7]);
                    }
                    if (stringArray.length != columnBaseArray.length) {
                        throw new RecoverableOdbcFailure("Col data mismatch.  " + columnBaseArray.length + " col instances but " + stringArray.length + " col names");
                    }
                    this.outPacket.writeShort(stringArray.length);
                    for (n7 = 0; n7 < stringArray.length; ++n7) {
                        this.outPacket.write(stringArray[n7]);
                        this.outPacket.writeInt(OdbcUtil.getTableOidForColumn(n7, resultMetaData));
                        this.outPacket.writeShort(OdbcUtil.getIdForColumn(n7, resultMetaData));
                        this.outPacket.writeInt(pgTypeArray[n7].getOid());
                        this.outPacket.writeShort(pgTypeArray[n7].getTypeWidth());
                        this.outPacket.writeInt(pgTypeArray[n7].getLPConstraint());
                        this.outPacket.writeShort(0);
                    }
                    this.outPacket.xmit('T', this.dataOutput);
                    break;
                }
                case 'B': {
                    OdbcPreparedStatement odbcPreparedStatement;
                    int n9;
                    String string9 = odbcPacketInputStream.readString();
                    String string10 = odbcPacketInputStream.readString();
                    int n10 = odbcPacketInputStream.readUnsignedShort();
                    boolean[] blArray = new boolean[n10];
                    for (int i6 = 0; i6 < n10; ++i6) {
                        boolean bl2 = blArray[i6] = odbcPacketInputStream.readUnsignedShort() != 0;
                        if (!this.server.isTrace() || !blArray[i6]) continue;
                        this.server.printWithThread("Binary param #" + i6);
                    }
                    int n11 = odbcPacketInputStream.readUnsignedShort();
                    Object[] objectArray = new Object[n11];
                    for (n9 = 0; n9 < objectArray.length; ++n9) {
                        objectArray[n9] = n9 < blArray.length && blArray[n9] ? odbcPacketInputStream.readSizedBinaryData() : odbcPacketInputStream.readSizedString();
                    }
                    n9 = odbcPacketInputStream.readUnsignedShort();
                    for (int i7 = 0; i7 < n9; ++i7) {
                        if (odbcPacketInputStream.readUnsignedShort() == 0) continue;
                        throw new RecoverableOdbcFailure(null, "Binary output values not supported", "0A000");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Bind request to make Portal from (" + string10 + ")' with handle '" + string9 + "'");
                    }
                    if ((odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string10)) == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for PS handle: " + string10, "08P01");
                    }
                    if (string9.length() > 0 && this.sessionOdbcPortalMap.containsKey(string9)) {
                        throw new RecoverableOdbcFailure(null, "Portal handle '" + string9 + "' already in use.  You must close it before recreating", "08P01");
                    }
                    ResultMetaData resultMetaData = odbcPreparedStatement.ackResult.parameterMetaData;
                    if (n11 != resultMetaData.getColumnCount()) {
                        throw new RecoverableOdbcFailure(null, "Client didn't specify all " + resultMetaData.getColumnCount() + " parameters (" + n11 + ")", "08P01");
                    }
                    new StatementPortal(string9, odbcPreparedStatement, objectArray, this.sessionOdbcPortalMap);
                    this.outPacket.xmit('2', this.dataOutput);
                    break;
                }
                case 'E': {
                    StatementPortal statementPortal;
                    String string11 = odbcPacketInputStream.readString();
                    int n12 = odbcPacketInputStream.readInt();
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Exec request for " + n12 + " rows from portal handle '" + string11 + "'");
                    }
                    if ((statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string11)) == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for Portal handle: " + string11, "08P01");
                    }
                    statementPortal.bindResult.setPreparedExecuteProperties(statementPortal.parameters, n12, 0, 0, 0);
                    Result result = this.session.execute(statementPortal.bindResult);
                    switch (result.getType()) {
                        case 1: {
                            this.outPacket.write(OdbcUtil.echoBackReplyString(statementPortal.lcQuery, result.getUpdateCount()));
                            this.outPacket.xmit('C', this.dataOutput);
                            if (!statementPortal.lcQuery.equals("commit") && !statementPortal.lcQuery.startsWith("commit ") && !statementPortal.lcQuery.equals("rollback") && !statementPortal.lcQuery.startsWith("rollback ")) break block17;
                            try {
                                this.session.setAutoCommit(true);
                                break block17;
                            }
                            catch (HsqlException hsqlException) {
                                throw new RecoverableOdbcFailure("Failed to change transaction state: " + hsqlException.getMessage(), hsqlException.getSQLState());
                            }
                        }
                        case 3: {
                            break;
                        }
                        case 2: {
                            throw new RecoverableOdbcFailure(result);
                        }
                        default: {
                            throw new RecoverableOdbcFailure("Output Result from Portal execution is of unexpected type: " + result.getType());
                        }
                    }
                    RowSetNavigator rowSetNavigator = result.getNavigator();
                    int n13 = 0;
                    int n14 = statementPortal.ackResult.metaData.getColumnCount();
                    while (rowSetNavigator.next()) {
                        int n15;
                        ++n13;
                        Object[] objectArray = rowSetNavigator.getCurrent();
                        if (objectArray == null) {
                            throw new RecoverableOdbcFailure("Null row?");
                        }
                        if (objectArray.length < n14) {
                            throw new RecoverableOdbcFailure("Data element mismatch. " + n14 + " metadata cols, yet " + objectArray.length + " data elements for row " + n13);
                        }
                        this.outPacket.writeShort(n14);
                        Type[] typeArray = statementPortal.ackResult.metaData.columnTypes;
                        PgType[] pgTypeArray = new PgType[n14];
                        for (n15 = 0; n15 < pgTypeArray.length; ++n15) {
                            pgTypeArray[n15] = PgType.getPgType(typeArray[n15]);
                        }
                        for (n15 = 0; n15 < n14; ++n15) {
                            if (objectArray[n15] == null) {
                                this.outPacket.writeInt(-1);
                                continue;
                            }
                            String string12 = pgTypeArray[n15].valueString(objectArray[n15]);
                            this.outPacket.writeSized(string12);
                            if (!this.server.isTrace()) continue;
                            this.server.printWithThread("R" + n13 + "C" + (n15 + 1) + " => (" + objectArray[n15].getClass().getName() + ") [" + string12 + "]");
                        }
                        this.outPacket.xmit('D', this.dataOutput);
                    }
                    if (rowSetNavigator.getSize() == 0 || rowSetNavigator.afterLast()) {
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        break;
                    }
                    this.outPacket.xmit('s', this.dataOutput);
                    break;
                }
                case 'C': {
                    char c4 = odbcPacketInputStream.readByteChar();
                    String string13 = odbcPacketInputStream.readString();
                    OdbcPreparedStatement odbcPreparedStatement = null;
                    StatementPortal statementPortal = null;
                    if (c4 == 'S') {
                        odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string13);
                        if (odbcPreparedStatement != null) {
                            odbcPreparedStatement.close();
                        }
                    } else if (c4 == 'P') {
                        statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string13);
                        if (statementPortal != null) {
                            statementPortal.close();
                        }
                    } else {
                        throw new RecoverableOdbcFailure(null, "Description packet request type invalid: " + c4, "08P01");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Closed " + c4 + " '" + string13 + "'? " + (odbcPreparedStatement != null || statementPortal != null));
                    }
                    this.outPacket.xmit('3', this.dataOutput);
                    break;
                }
                default: {
                    throw new RecoverableOdbcFailure(null, "Unsupported operation type (" + odbcPacketInputStream.packetType + ")", "0A000");
                }
            }
            OdbcUtil.validateInputPacketSize(odbcPacketInputStream);
            if (string != null) {
                this.server.printWithThread("Interposing AFTER primary statement: " + string);
                this.odbcExecDirect(string);
            }
            if (bl) {
                this.outPacket.reset();
                this.outPacket.writeByte(this.session.isAutoCommit() ? 73 : 84);
                this.outPacket.xmit('Z', this.dataOutput);
            }
        }
        catch (RecoverableOdbcFailure recoverableOdbcFailure) {
            Result result = recoverableOdbcFailure.getErrorResult();
            if (result == null) {
                String string14 = recoverableOdbcFailure.getSqlStateCode();
                String string15 = recoverableOdbcFailure.toString();
                String string16 = recoverableOdbcFailure.getClientMessage();
                if (this.server.isTrace()) {
                    this.server.printWithThread(string15);
                }
                if (string16 != null) {
                    OdbcUtil.alertClient(2, string16, string14, this.dataOutput);
                }
            } else {
                if (this.server.isTrace()) {
                    this.server.printWithThread("Result object error: " + result.getMainString());
                }
                OdbcUtil.alertClient(2, result.getMainString(), result.getSubString(), this.dataOutput);
            }
            switch (this.odbcCommMode) {
                case 0: {
                    this.outPacket.reset();
                    this.outPacket.writeByte(69);
                    this.outPacket.xmit('Z', this.dataOutput);
                    break;
                }
                case 1: {
                    this.odbcCommMode = 2;
                    this.server.printWithThread("Reverting to EXT_RECOVER mode");
                }
            }
        }
    }

    @Override
    public void run() {
        block8: {
            this.init();
            if (this.session != null) {
                try {
                    while (this.keepAlive) {
                        byte by = this.dataInput.readByte();
                        this.processor.receiveResult((char)by);
                    }
                }
                catch (CleanExit cleanExit) {
                    this.keepAlive = false;
                }
                catch (IOException iOException) {
                    this.server.printWithThread(this.mThread + ":disconnected " + this.user);
                }
                catch (HsqlException hsqlException) {
                    if (this.keepAlive) {
                        this.server.printStackTrace(hsqlException);
                    }
                }
                catch (Throwable throwable) {
                    if (!this.keepAlive) break block8;
                    this.server.printStackTrace(throwable);
                }
            }
        }
        this.close();
    }

    private Result setDatabase(Result result) {
        try {
            String string = result.getDatabaseName();
            this.dbIndex = this.server.getDBIndex(string);
            this.dbID = this.server.dbID[this.dbIndex];
            this.user = result.getMainString();
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to connect user '" + this.user + "' to DB (" + string + ")");
            }
            this.session = DatabaseManager.newSession(this.dbID, this.user, result.getSubString(), result.getZoneString());
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Connected user '" + this.user + "'");
            }
            return Result.newConnectionAcknowledgeResponse(this.session);
        }
        catch (HsqlException hsqlException) {
            this.session = null;
            return Result.newErrorResult(hsqlException);
        }
        catch (Throwable throwable) {
            this.session = null;
            return Result.newErrorResult(throwable);
        }
    }

    private Result cancelStatement(Result result) {
        try {
            this.dbID = result.getDatabaseId();
            long l2 = result.getSessionId();
            this.session = DatabaseManager.getSession(this.dbID, l2);
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to cancel statement  to DB (" + this.dbID + ")");
            }
            return this.session.cancel(result);
        }
        catch (HsqlException hsqlException) {}
        finally {
            this.session = null;
            return Result.updateZeroResult;
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB Connection @" + Integer.toString(this.hashCode(), 16);
    }

    public int handshake() throws IOException {
        long l2 = new Date().getTime() + MAX_WAIT_FOR_CLIENT_DATA;
        if (!(this.socket instanceof SSLSocket)) {
            do {
                try {
                    Thread.sleep(CLIENT_DATA_POLLING_PERIOD);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.dataInput.available() < 5 && new Date().getTime() < l2);
            if (this.dataInput.available() < 1) {
                this.dataOutput.write((TEXTBANNER_PART1 + "2.3.4.0" + TEXTBANNER_PART2 + "\n").getBytes());
                this.dataOutput.flush();
                throw Error.error(404);
            }
        }
        int n2 = this.dataInput.readInt();
        switch (n2 >> 24) {
            case 80: {
                this.server.print("Rejected attempt from client using hsql HTTP protocol");
                return 0;
            }
            case 0: {
                this.streamProtocol = 2;
                this.processor = new OdbcInResultProcessor();
                break;
            }
            default: {
                this.streamProtocol = 1;
                this.processor = new HsqlInResultProcessor();
                if (n2 == -2030400) break;
                if (n2 == -1900000) {
                    n2 = -2000000;
                }
                String string = ClientConnection.toNetCompVersionString(n2);
                throw Error.error(null, 403, 0, new String[]{"2.7.1", string});
            }
        }
        return n2;
    }

    private void odbcConnect(int n2) throws IOException {
        int n3 = this.dataInput.readUnsignedShort();
        int n4 = this.dataInput.readUnsignedShort();
        if (n3 == 1 && n4 == 7) {
            this.server.print("A pre-version 2.0 client attempted to connect.  We rejected them.");
            return;
        }
        if (n3 == 1234 && n4 == 5679) {
            this.dataOutput.writeByte(78);
            this.odbcConnect(this.dataInput.readInt());
            return;
        }
        if (n3 == 1234 && n4 == 5678) {
            if (n2 != 16) {
                this.server.print("ODBC cancellation request sent wrong packet length: " + n2);
            }
            this.server.print("Got an ODBC cancellation request for thread ID " + this.dataInput.readInt() + ", but we don't support OOB cancellation yet.  Ignoring this request and closing the connection.");
            return;
        }
        this.server.printWithThread("ODBC client connected.  ODBC Protocol Compatibility Version " + n3 + "." + n4);
        OdbcPacketInputStream odbcPacketInputStream = OdbcPacketInputStream.newOdbcPacketInputStream('\u0000', (InputStream)this.dataInput, n2 - 8);
        Map map = odbcPacketInputStream.readStringPairs();
        if (this.server.isTrace()) {
            this.server.print("String Pairs from ODBC client: " + map);
        }
        try {
            try {
                OdbcUtil.validateInputPacketSize(odbcPacketInputStream);
            }
            catch (RecoverableOdbcFailure recoverableOdbcFailure) {
                throw new ClientFailure(recoverableOdbcFailure.toString(), recoverableOdbcFailure.getClientMessage());
            }
            odbcPacketInputStream.close();
            if (!map.containsKey("database")) {
                throw new ClientFailure("Client did not identify database", "Target database not identified");
            }
            if (!map.containsKey("user")) {
                throw new ClientFailure("Client did not identify user", "Target account not identified");
            }
            String string = (String)map.get("database");
            this.user = (String)map.get("user");
            if (string.equals("/")) {
                string = "";
            }
            this.dataOutput.writeByte(82);
            this.dataOutput.writeInt(8);
            this.dataOutput.writeInt(3);
            this.dataOutput.flush();
            char c2 = '\u0000';
            try {
                c2 = (char)this.dataInput.readByte();
            }
            catch (EOFException eOFException) {
                this.server.printWithThread("Looks like we got a goofy psql no-auth attempt.  Will probably retry properly very shortly");
                return;
            }
            if (c2 != 'p') {
                throw new ClientFailure("Expected password prefix 'p', but got '" + c2 + "'", "Password value not prefixed with 'p'");
            }
            int n5 = this.dataInput.readInt() - 5;
            if (n5 < 0) {
                throw new ClientFailure("Client submitted invalid password length " + n5, "Invalid password length " + n5);
            }
            String string2 = ServerConnection.readNullTermdUTF(n5, this.dataInput);
            this.dbIndex = this.server.getDBIndex(string);
            this.dbID = this.server.dbID[this.dbIndex];
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to connect user '" + this.user + "' to DB (" + string + ")");
            }
            try {
                this.session = DatabaseManager.newSession(this.dbID, this.user, string2, DateTimeType.systemTimeZone.getID());
            }
            catch (Exception exception) {
                throw new ClientFailure("User name or password denied: " + exception, "Login attempt rejected");
            }
        }
        catch (ClientFailure clientFailure) {
            this.server.print(clientFailure.toString());
            OdbcUtil.alertClient(1, clientFailure.getClientMessage(), "08006", this.dataOutput);
            return;
        }
        this.outPacket = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        this.outPacket.writeInt(0);
        this.outPacket.xmit('R', this.dataOutput);
        for (int i2 = 0; i2 < OdbcUtil.hardcodedParams.length; ++i2) {
            OdbcUtil.writeParam(OdbcUtil.hardcodedParams[i2][0], OdbcUtil.hardcodedParams[i2][1], this.dataOutput);
        }
        this.outPacket.writeByte(73);
        this.outPacket.xmit('Z', this.dataOutput);
        OdbcUtil.alertClient(7, "MHello\nYou have connected to HyperSQL ODBC Server", this.dataOutput);
        this.dataOutput.flush();
    }

    private static String readNullTermdUTF(int n2, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[n2 + 3];
        byArray[0] = (byte)(n2 >>> 8);
        byArray[1] = (byte)n2;
        for (int i2 = 0; i2 < n2 + 1; i2 += inputStream.read(byArray, 2 + i2, n2 + 1 - i2)) {
        }
        if (byArray[byArray.length - 1] != 0) {
            throw new IOException("String not null-terminated");
        }
        for (int i3 = 2; i3 < byArray.length - 1; ++i3) {
            if (byArray[i3] != 0) continue;
            throw new RuntimeException("Null internal to String at offset " + (i3 - 2));
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    private void odbcExecDirect(String string) throws RecoverableOdbcFailure, IOException {
        Object object = string;
        String string2 = ((String)object).trim().toLowerCase();
        if (string2.startsWith("release ") && !string2.startsWith("release savepoint")) {
            this.server.printWithThread("Transmogrifying 'RELEASE ...' to 'RELEASE SAVEPOINT...");
            object = ((String)object).trim().substring(0, "release ".length()) + "SAVEPOINT " + ((String)object).trim().substring("release ".length());
        }
        Result result = Result.newExecuteDirectRequest();
        result.setPrepareOrExecuteProperties((String)object, 0, 0, 1, 0, 0, 2, null, null);
        this.server.printWithThread((String)object);
        Result result2 = this.session.execute(result);
        switch (result2.getType()) {
            case 1: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(result2);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from execution is of unexpected type: " + result2.getType());
            }
        }
        this.outPacket.reset();
        this.outPacket.write(OdbcUtil.echoBackReplyString(string2, result2.getUpdateCount()));
        this.outPacket.xmit('C', this.dataOutput);
        if (string2.equals("commit") || string2.startsWith("commit ") || string2.equals("rollback") || string2.startsWith("rollback ")) {
            try {
                this.session.setAutoCommit(true);
            }
            catch (HsqlException hsqlException) {
                throw new RecoverableOdbcFailure("Failed to change transaction state: " + hsqlException.getMessage(), hsqlException.getSQLState());
            }
        }
    }

    static {
        int n2 = ResourceBundleHandler.getBundleHandle("org_hsqldb_server_Server_messages", null);
        if (n2 < 0) {
            throw new RuntimeException("MISSING Resource Bundle.  See source code");
        }
        TEXTBANNER_PART1 = ResourceBundleHandler.getString(n2, "textbanner.part1");
        TEXTBANNER_PART2 = ResourceBundleHandler.getString(n2, "textbanner.part2");
        if (TEXTBANNER_PART1 == null || TEXTBANNER_PART2 == null) {
            throw new RuntimeException("MISSING Resource Bundle msg definition.  See source code");
        }
        MAX_WAIT_FOR_CLIENT_DATA = 1000L;
        CLIENT_DATA_POLLING_PERIOD = 100L;
    }

    class HsqlInResultProcessor
    implements InResultProcessor {
        HsqlInResultProcessor() {
        }

        @Override
        public void receiveConnection(int n2) throws CleanExit, IOException {
            this.receiveResult(n2);
        }

        @Override
        public void receiveResult(int n2) throws CleanExit, IOException {
            ServerConnection.this.receiveResult(n2);
        }
    }

    class OdbcInResultProcessor
    implements InResultProcessor {
        OdbcInResultProcessor() {
        }

        @Override
        public void receiveConnection(int n2) throws IOException {
            ServerConnection.this.odbcConnect(n2);
        }

        @Override
        public void receiveResult(int n2) throws CleanExit, IOException {
            ServerConnection.this.receiveOdbcPacket((char)n2);
        }
    }

    private static class ClientFailure
    extends Exception {
        private String clientMessage = null;

        public ClientFailure(String string, String string2) {
            super(string);
            this.clientMessage = string2;
        }

        public String getClientMessage() {
            return this.clientMessage;
        }
    }
}

