/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.IOException;
import java.util.Locale;
import org.hsqldb.ColumnBase;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.server.OdbcPacketInputStream;
import org.hsqldb.server.OdbcPacketOutputStream;
import org.hsqldb.server.RecoverableOdbcFailure;

public class OdbcUtil {
    static final int ODBC_SM_DATABASE = 64;
    static final int ODBC_SM_USER = 32;
    static final int ODBC_SM_OPTIONS = 64;
    static final int ODBC_SM_UNUSED = 64;
    static final int ODBC_SM_TTY = 64;
    static final int ODBC_AUTH_REQ_PASSWORD = 3;
    static final int ODBC_AUTH_REQ_OK = 0;
    static String[][] hardcodedParams = new String[][]{{"client_encoding", "SQL_ASCII"}, {"DateStyle", "ISO, MDY"}, {"integer_datetimes", "on"}, {"is_superuser", "on"}, {"server_encoding", "SQL_ASCII"}, {"server_version", "8.3.1"}, {"session_authorization", "blaine"}, {"standard_conforming_strings", "off"}, {"TimeZone", "US/Eastern"}};
    static final int ODBC_SIMPLE_MODE = 0;
    static final int ODBC_EXTENDED_MODE = 1;
    static final int ODBC_EXT_RECOVER_MODE = 2;
    static final int ODBC_SEVERITY_FATAL = 1;
    static final int ODBC_SEVERITY_ERROR = 2;
    static final int ODBC_SEVERITY_PANIC = 3;
    static final int ODBC_SEVERITY_WARNING = 4;
    static final int ODBC_SEVERITY_NOTICE = 5;
    static final int ODBC_SEVERITY_DEBUG = 6;
    static final int ODBC_SEVERITY_INFO = 7;
    static final int ODBC_SEVERITY_LOG = 8;
    static final IntKeyHashMap odbcSeverityMap = new IntKeyHashMap();

    static void validateInputPacketSize(OdbcPacketInputStream odbcPacketInputStream) throws RecoverableOdbcFailure {
        int n2 = -1;
        try {
            n2 = odbcPacketInputStream.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n2 < 1) {
            return;
        }
        throw new RecoverableOdbcFailure("Client supplied bad length for " + odbcPacketInputStream.packetType + " packet.  " + n2 + " bytes available after processing", "Bad length for " + odbcPacketInputStream.packetType + " packet.  " + n2 + " extra bytes", "08P01");
    }

    static String echoBackReplyString(String string, int n2) {
        int n3;
        String string2 = string.trim().toUpperCase(Locale.ENGLISH);
        for (n3 = 0; n3 < string2.length() && !Character.isWhitespace(string2.charAt(n3)); ++n3) {
        }
        String string3 = string2.substring(0, n3);
        StringBuilder stringBuilder = new StringBuilder(string3);
        if (string3.equals("UPDATE") || string3.equals("DELETE")) {
            stringBuilder.append(' ').append(n2);
        } else if (string3.equals("CREATE") || string3.equals("DROP")) {
            int n4;
            int n5;
            for (n5 = n3; n5 < string2.length() && Character.isWhitespace(string2.charAt(n5)); ++n5) {
            }
            for (n4 = n5; n4 < string2.length() && Character.isWhitespace(string2.charAt(n4)); ++n4) {
            }
            stringBuilder.append(' ').append(string2, n5, n4);
        } else if (string3.equals("INSERT")) {
            stringBuilder.append(' ').append(0).append(' ').append(n2);
        }
        return stringBuilder.toString();
    }

    static void writeParam(String string, String string2, DataOutputStream dataOutputStream) throws IOException {
        OdbcPacketOutputStream odbcPacketOutputStream = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        odbcPacketOutputStream.write(string);
        odbcPacketOutputStream.write(string2);
        odbcPacketOutputStream.xmit('S', dataOutputStream);
        odbcPacketOutputStream.close();
    }

    static void alertClient(int n2, String string, DataOutputStream dataOutputStream) throws IOException {
        OdbcUtil.alertClient(n2, string, null, dataOutputStream);
    }

    static void alertClient(int n2, String string, String string2, DataOutputStream dataOutputStream) throws IOException {
        if (string2 == null) {
            string2 = "XX000";
        }
        if (!odbcSeverityMap.containsKey(n2)) {
            throw new IllegalArgumentException("Unknown severity value (" + n2 + ")");
        }
        OdbcPacketOutputStream odbcPacketOutputStream = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        odbcPacketOutputStream.write("S" + odbcSeverityMap.get(n2));
        if (n2 < 5) {
            odbcPacketOutputStream.write("C" + string2);
        }
        odbcPacketOutputStream.write("M" + string);
        odbcPacketOutputStream.writeByte(0);
        odbcPacketOutputStream.xmit(n2 < 5 ? (char)'E' : 'N', dataOutputStream);
        odbcPacketOutputStream.close();
    }

    static String revertMungledPreparedQuery(String string) {
        return string.replaceAll("\\$\\d+", "?");
    }

    public static int getTableOidForColumn(int n2, ResultMetaData resultMetaData) {
        if (!resultMetaData.isTableColumn(n2)) {
            return 0;
        }
        ColumnBase columnBase = resultMetaData.columns[n2];
        int n3 = (columnBase.getSchemaNameString() + "." + columnBase.getTableNameString()).hashCode();
        if (n3 < 0) {
            n3 *= -1;
        }
        return n3;
    }

    public static short getIdForColumn(int n2, ResultMetaData resultMetaData) {
        if (!resultMetaData.isTableColumn(n2)) {
            return 0;
        }
        short s2 = (short)resultMetaData.getGeneratedColumnNames()[n2].hashCode();
        if (s2 < 0) {
            s2 = (short)(s2 * -1);
        }
        return s2;
    }

    public static String hexCharsToOctalOctets(String string) {
        int n2 = string.length();
        if (n2 != n2 / 2 * 2) {
            throw new IllegalArgumentException("Hex character lists contains an odd number of characters: " + n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 0;
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'f') {
                n3 += 10 + c2 - 97;
            } else if (c2 >= 'A' && c2 <= 'F') {
                n3 += 10 + c2 - 65;
            } else if (c2 >= '0' && c2 <= '9') {
                n3 += c2 - 48;
            } else {
                throw new IllegalArgumentException("Non-hex character in input at offset " + i2 + ": " + c2);
            }
            n3 <<= 4;
            c2 = string.charAt(++i2);
            if (c2 >= 'a' && c2 <= 'f') {
                n3 += 10 + c2 - 97;
            } else if (c2 >= 'A' && c2 <= 'F') {
                n3 += 10 + c2 - 65;
            } else if (c2 >= '0' && c2 <= '9') {
                n3 += c2 - 48;
            } else {
                throw new IllegalArgumentException("Non-hex character in input at offset " + i2 + ": " + c2);
            }
            stringBuilder.append('\\');
            stringBuilder.append((char)(48 + (n3 >> 6)));
            stringBuilder.append((char)(48 + (n3 >> 3 & 7)));
            stringBuilder.append((char)(48 + (n3 & 7)));
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("(" + OdbcUtil.hexCharsToOctalOctets(stringArray[0]) + ")");
    }

    static {
        odbcSeverityMap.put(1, "FATAL");
        odbcSeverityMap.put(2, "ERROR");
        odbcSeverityMap.put(3, "PANIC");
        odbcSeverityMap.put(4, "WARNING");
        odbcSeverityMap.put(5, "NOTICE");
        odbcSeverityMap.put(6, "DEBUG");
        odbcSeverityMap.put(7, "INFO");
        odbcSeverityMap.put(8, "LOG");
    }
}

