/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.hsqldb.HsqlException;
import org.hsqldb.types.BinaryData;

class OdbcPacketInputStream
extends DataInputStream {
    char packetType;
    private InputStream bufferStream;

    static OdbcPacketInputStream newOdbcPacketInputStream(char c2, InputStream inputStream, int n2) throws IOException {
        return OdbcPacketInputStream.newOdbcPacketInputStream(c2, inputStream, (Integer)n2);
    }

    static OdbcPacketInputStream newOdbcPacketInputStream(char c2, InputStream inputStream) throws IOException {
        return OdbcPacketInputStream.newOdbcPacketInputStream(c2, inputStream, null);
    }

    private static OdbcPacketInputStream newOdbcPacketInputStream(char c2, InputStream inputStream, Integer n2) throws IOException {
        int n3;
        int n4;
        byte[] byArray;
        int n5 = 0;
        if (n2 == null) {
            byArray = new byte[4];
            n4 = 0;
            while ((n3 = inputStream.read(byArray, n4, byArray.length - n4)) > 0) {
                n4 += n3;
            }
            if (n4 != byArray.length) {
                throw new EOFException("Failed to read size header int");
            }
            n5 = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) - 4;
        } else {
            n5 = n2;
        }
        byArray = new byte[n5];
        n4 = 0;
        while ((n3 = inputStream.read(byArray, n4, byArray.length - n4)) > 0) {
            n4 += n3;
        }
        if (n4 != byArray.length) {
            throw new EOFException("Failed to read packet contents from given stream");
        }
        return new OdbcPacketInputStream(c2, new ByteArrayInputStream(byArray));
    }

    private OdbcPacketInputStream(char c2, InputStream inputStream) {
        super(inputStream);
        this.packetType = c2;
    }

    Map readStringPairs() throws IOException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string = this.readString()).length() >= 1) {
            hashMap.put(string, this.readString());
        }
        return hashMap;
    }

    String readString() throws IOException {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(88);
        byteArrayOutputStream.write(88);
        while ((by = this.readByte()) > 0) {
            byteArrayOutputStream.write(by);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        int n2 = byArray.length - 2;
        byArray[0] = (byte)(n2 >>> 8);
        byArray[1] = (byte)n2;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    BinaryData readSizedBinaryData() throws IOException {
        int n2 = this.readInt();
        try {
            return n2 < 0 ? null : new BinaryData(n2, this);
        }
        catch (HsqlException hsqlException) {
            throw new IOException(hsqlException.getMessage());
        }
    }

    String readSizedString() throws IOException {
        int n2 = this.readInt();
        return n2 < 0 ? null : this.readString(n2);
    }

    String readString(int n2) throws IOException {
        int n3;
        int n4;
        byte[] byArray = new byte[n2 + 2];
        byArray[0] = (byte)(n2 >>> 8);
        byArray[1] = (byte)n2;
        for (n3 = 0; (n4 = this.read(byArray, 2 + n3, n2 - n3)) > -1 && n3 < n2; n3 += n4) {
        }
        if (n3 != n2) {
            throw new EOFException("Packet ran dry");
        }
        for (n4 = 2; n4 < byArray.length - 1; ++n4) {
            if (byArray[n4] != 0) continue;
            throw new RuntimeException("Null internal to String at offset " + (n4 - 2));
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    public char readByteChar() throws IOException {
        return (char)this.readByte();
    }
}

