/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.Row;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowOutputBinaryEncode
extends RowOutputBinary {
    final Crypto crypto;

    public RowOutputBinaryEncode(Crypto crypto, int n2, int n3) {
        super(n2, n3);
        this.crypto = crypto;
    }

    @Override
    public void writeData(Row row, Type[] typeArray) {
        if (this.crypto == null) {
            super.writeData(row, typeArray);
        } else {
            int n2 = this.count;
            this.ensureRoom(row.getStorageSize());
            this.writeInt(0);
            super.writeData(row, typeArray);
            int n3 = this.count - n2 - 4;
            int n4 = this.crypto.encode(this.buffer, n2 + 4, n3, this.buffer, n2 + 4);
            this.writeIntData(n4, n2);
            this.count = n2 + 4 + n4;
        }
    }

    @Override
    public int getSize(Row row) {
        int n2 = super.getSize(row);
        if (this.crypto != null) {
            n2 = this.crypto.getEncodedSize(n2 - 4) + 8;
        }
        return n2;
    }

    @Override
    public RowOutputInterface duplicate() {
        return new RowOutputBinaryEncode(this.crypto, 128, this.scale);
    }
}

