/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.RowInsertInterface;
import org.hsqldb.persist.RowInsertSimple;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader8;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.types.Type;

public class TextFileOps {
    public static Result loadTextData(Session session, String string, Table table, int n2) {
        RandomAccessInterface randomAccessInterface;
        Database database = session.database;
        FileUtil fileUtil = FileUtil.getFileUtil();
        TextFileSettings textFileSettings = new TextFileSettings(database.getProperties(), string);
        String string2 = textFileSettings.getFileName();
        if (string2 == null || string2.length() == 0) {
            throw Error.error(301);
        }
        string2 = fileUtil.canonicalOrAbsolutePath(string2);
        boolean bl = FileUtil.getFileUtil().exists(string2);
        if (!bl) {
            throw Error.error(null, 452, 42, new String[]{string2, "file does not exist"});
        }
        try {
            randomAccessInterface = RAFile.newScaledRAFile(database, string2, true, 5);
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new String[]{string2, throwable.toString()});
        }
        RowInputInterface rowInputInterface = textFileSettings.isQuoted || textFileSettings.isAllQuoted ? new RowInputTextQuoted(textFileSettings) : new RowInputText(textFileSettings);
        TextFileReader textFileReader = TextFileReader8.newTextFileReader(randomAccessInterface, textFileSettings, rowInputInterface, true);
        RowInsertInterface.ErrorLogger errorLogger = n2 == 2 ? new RowInsertSimple.InsertErrorHandler(database, string2) : new RowInsertSimple.DefaultErrorHandler();
        RowInsertSimple rowInsertSimple = new RowInsertSimple(session, errorLogger, n2);
        PersistentStore persistentStore = table.getRowStore(session);
        Type[] typeArray = table.getColumnTypes();
        boolean bl2 = textFileSettings.isIgnoreFirst;
        try {
            while ((rowInputInterface = textFileReader.readObject()) != null) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                Object[] objectArray = rowInputInterface.readData(typeArray);
                if (textFileSettings.isNullDef) {
                    table.generateDefaultForNull(objectArray);
                }
                table.generateAndCheckData(session, objectArray);
                if (n2 == 4) continue;
                rowInsertSimple.insert(table, persistentStore, objectArray);
            }
            rowInsertSimple.finishTable();
        }
        catch (Throwable throwable) {
            long l2 = textFileReader.getLineNumber();
            throw Error.error(throwable, 483, 0, new String[]{String.valueOf(l2), throwable.toString()});
        }
        finally {
            rowInsertSimple.close();
            try {
                if (errorLogger != null) {
                    errorLogger.close();
                }
            }
            catch (Exception exception) {}
            try {
                randomAccessInterface.close();
            }
            catch (Exception exception) {}
        }
        return Result.newUpdateCountResult((int)textFileReader.getLineNumber());
    }

    public static Result unloadTextData(Session session, String string, Table table) {
        RAFileSimple rAFileSimple;
        Database database = session.database;
        FileUtil fileUtil = FileUtil.getFileUtil();
        TextFileSettings textFileSettings = new TextFileSettings(database.getProperties(), string);
        String string2 = textFileSettings.getFileName();
        int n2 = 0;
        if (string2 == null || string2.length() == 0) {
            throw Error.error(301);
        }
        string2 = fileUtil.canonicalOrAbsolutePath(string2);
        boolean bl = FileUtil.getFileUtil().exists(string2);
        if (bl) {
            throw Error.error(null, 487, 42, new String[]{string2, "file exists"});
        }
        try {
            rAFileSimple = new RAFileSimple(database.logger, string2, "rw");
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new String[]{string2});
        }
        RowOutputText rowOutputText = textFileSettings.isQuoted || textFileSettings.isAllQuoted ? new RowOutputTextQuoted(textFileSettings) : new RowOutputText(textFileSettings);
        PersistentStore persistentStore = table.getRowStore(session);
        Type[] typeArray = table.getColumnTypes();
        RowIterator rowIterator = table.rowIteratorForScript(persistentStore);
        long l2 = 0L;
        try {
            while (rowIterator.next()) {
                rowOutputText.reset();
                Row row = rowIterator.getCurrentRow();
                rowOutputText.writeData(row, typeArray);
                rowOutputText.writeEnd();
                rAFileSimple.seek(l2);
                rAFileSimple.write(rowOutputText.getOutputStream().getBuffer(), 0, rowOutputText.getOutputStream().size());
                l2 += (long)rowOutputText.getOutputStream().size();
                ++n2;
            }
            rAFileSimple.synch();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new String[]{string2});
        }
        finally {
            try {
                rAFileSimple.close();
            }
            catch (Exception exception) {}
        }
        return Result.newUpdateCountResult(n2);
    }
}

