/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerSimple
implements TableSpaceManager {
    DataFileCache cache;
    final int scale;

    public TableSpaceManagerSimple(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.scale = dataFileCache.getDataFileScale();
    }

    @Override
    public int getSpaceID() {
        return 7;
    }

    @Override
    public void release(long l2, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePosition(int n2) {
        this.cache.writeLock.lock();
        try {
            long l2 = this.cache.getFileFreePos();
            long l3 = l2 / (long)this.scale;
            long l4 = l2 + (long)n2;
            if (l4 > this.cache.maxDataFileSize) {
                this.cache.logSevereEvent("data file reached maximum size " + this.cache.dataFileName, null);
                throw Error.error(468);
            }
            this.cache.fileFreePosition = l4;
            long l5 = l3;
            return l5;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean hasFileRoom(long l2) {
        return true;
    }

    @Override
    public void addFileBlock(long l2, long l3) {
    }

    @Override
    public void initialiseFileBlock(LongLookup longLookup, long l2, long l3) {
    }

    @Override
    public void reset() {
    }

    @Override
    public long getLostBlocksSize() {
        return 0L;
    }

    @Override
    public boolean isDefaultSpace() {
        return true;
    }
}

